/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import org.apache.asterix.builders.IAsterixListBuilder;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.runtime.evaluators.functions.ArrayRepeatDescriptor$_Gen;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.TaggedValuePointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class ArrayRepeatDescriptor$_InnerGen1
implements IScalarEvaluator {
    private final ArrayBackedValueStorage storage = new ArrayBackedValueStorage();
    private final IScalarEvaluator repeatedValueEval;
    private final IScalarEvaluator repeatEval;
    private final IPointable repeatedValueArg;
    private final IPointable repeatArg;
    private final TaggedValuePointable repeatArgValue;
    private final IAsterixListBuilder listBuilder;
    final /* synthetic */ ArrayRepeatDescriptor$_Gen this$0;

    public ArrayRepeatDescriptor$_InnerGen1(ArrayRepeatDescriptor$_Gen this$0, IScalarEvaluatorFactory[] args, IHyracksTaskContext ctx) throws HyracksDataException {
        this.this$0 = this$0;
        this.repeatedValueEval = args[0].createScalarEvaluator(ctx);
        this.repeatEval = args[1].createScalarEvaluator(ctx);
        this.repeatedValueArg = new VoidPointable();
        this.repeatArg = new VoidPointable();
        this.repeatArgValue = new TaggedValuePointable();
        this.listBuilder = new OrderedListBuilder();
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        this.repeatedValueEval.evaluate(tuple, this.repeatedValueArg);
        this.repeatEval.evaluate(tuple, this.repeatArg);
        this.repeatArgValue.set((IValueReference)this.repeatArg);
        if (!ATypeHierarchy.isCompatible((ATypeTag)ATypeTag.DOUBLE, (ATypeTag)ATypeTag.VALUE_TYPE_MAPPING[this.repeatArgValue.getTag()])) {
            PointableHelper.setNull(result);
            return;
        }
        String name = this.this$0.getIdentifier().getName();
        double repetitions = ATypeHierarchy.getDoubleValue((String)name, (int)1, (byte[])this.repeatArg.getByteArray(), (int)this.repeatArg.getStartOffset());
        if (Double.isNaN(repetitions) || Double.isInfinite(repetitions) || Math.floor(repetitions) < repetitions || repetitions < 0.0) {
            PointableHelper.setNull(result);
            return;
        }
        this.listBuilder.reset(ArrayRepeatDescriptor$_Gen.access$000(this.this$0));
        int i = 0;
        while ((double)i < repetitions) {
            this.listBuilder.addItem((IValueReference)this.repeatedValueArg);
            ++i;
        }
        this.storage.reset();
        this.listBuilder.write(this.storage.getDataOutput(), true);
        result.set((IValueReference)this.storage);
    }
}

