/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.apache.asterix.builders.AbvsBuilderFactory;
import org.apache.asterix.builders.ArrayListFactory;
import org.apache.asterix.builders.IAsterixListBuilder;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.builders.UnorderedListBuilder;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.dataflow.data.nontagged.comparators.AObjectAscBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.serde.AOrderedListSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AUnorderedListSerializerDeserializer;
import org.apache.asterix.formats.nontagged.BinaryHashFunctionFactoryProvider;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.functions.IFunctionTypeInferer;
import org.apache.asterix.om.pointables.PointableAllocator;
import org.apache.asterix.om.pointables.base.DefaultOpenFieldType;
import org.apache.asterix.om.pointables.base.IVisitablePointable;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.util.container.IObjectFactory;
import org.apache.asterix.om.util.container.IObjectPool;
import org.apache.asterix.om.util.container.ListObjectPool;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.common.ListAccessor;
import org.apache.asterix.runtime.evaluators.functions.CastTypeEvaluator;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.functions.FunctionTypeInferers;
import org.apache.asterix.runtime.utils.ArrayFunctionsUtil;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryHashFunction;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IMutableValueStorage;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class ArrayIntersectDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    private IAType[] argTypes;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new ArrayIntersectDescriptor();
        }

        public IFunctionTypeInferer createFunctionTypeInferer() {
            return FunctionTypeInferers.SET_ARGUMENTS_TYPE;
        }
    };

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.ARRAY_INTERSECT;
    }

    public void setImmutableStates(Object ... states) {
        this.argTypes = (IAType[])states;
    }

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) throws AlgebricksException {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(IHyracksTaskContext ctx) throws HyracksDataException {
                return new ArrayIntersectEval(args, ctx);
            }
        };
    }

    public class ArrayIntersectEval
    implements IScalarEvaluator {
        private final ListAccessor listAccessor;
        private final IPointable pointable;
        private final ArrayBackedValueStorage currentItemStorage;
        private final IPointable[] listsArgs;
        private final IScalarEvaluator[] listsEval;
        private final IBinaryHashFunction binaryHashFunction;
        private final Int2ObjectMap<List<ValueListIndex>> hashes;
        private final PointableAllocator pointableAllocator = new PointableAllocator();
        private final IObjectPool<IMutableValueStorage, ATypeTag> storageAllocator = new ListObjectPool((IObjectFactory)new AbvsBuilderFactory());
        private final IObjectPool<List<ValueListIndex>, ATypeTag> arrayListAllocator = new ListObjectPool((IObjectFactory)new ArrayListFactory());
        private final IObjectPool<ValueListIndex, ATypeTag> valueListIndexAllocator;
        private final ArrayBackedValueStorage finalResult;
        private final CastTypeEvaluator caster;
        private final IBinaryComparator comp;
        private IAsterixListBuilder orderedListBuilder = null;
        private IAsterixListBuilder unorderedListBuilder = null;

        public ArrayIntersectEval(IScalarEvaluatorFactory[] args, IHyracksTaskContext ctx) throws HyracksDataException {
            this.valueListIndexAllocator = new ListObjectPool((IObjectFactory)new ValueListIndexAllocator());
            this.hashes = new Int2ObjectOpenHashMap();
            this.finalResult = new ArrayBackedValueStorage();
            this.listAccessor = new ListAccessor();
            this.caster = new CastTypeEvaluator();
            this.comp = AObjectAscBinaryComparatorFactory.INSTANCE.createBinaryComparator();
            this.listsArgs = new IPointable[args.length];
            this.listsEval = new IScalarEvaluator[args.length];
            this.pointable = new VoidPointable();
            this.currentItemStorage = new ArrayBackedValueStorage();
            for (int i = 0; i < args.length; ++i) {
                this.listsArgs[i] = new VoidPointable();
                this.listsEval[i] = args[i].createScalarEvaluator(ctx);
            }
            this.binaryHashFunction = BinaryHashFunctionFactoryProvider.INSTANCE.getBinaryHashFunctionFactory(null).createBinaryHashFunction();
        }

        public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
            boolean returnNull = false;
            AbstractCollectionType outList = null;
            int minListIndex = 0;
            int minSize = -1;
            try {
                IAsterixListBuilder listBuilder;
                for (int i = 0; i < this.listsEval.length; ++i) {
                    this.listsEval[i].evaluate(tuple, this.pointable);
                    if (returnNull) continue;
                    byte listArgType = this.pointable.getByteArray()[this.pointable.getStartOffset()];
                    ATypeTag listTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(listArgType);
                    if (!listTag.isListType()) {
                        returnNull = true;
                        continue;
                    }
                    if (outList != null && outList.getTypeTag() != listTag) {
                        throw new RuntimeDataException(38, ArrayIntersectDescriptor.this.sourceLoc, new Serializable[0]);
                    }
                    if (outList == null) {
                        outList = (AbstractCollectionType)DefaultOpenFieldType.getDefaultOpenFieldType((ATypeTag)listTag);
                    }
                    this.caster.resetAndAllocate((IAType)outList, ArrayIntersectDescriptor.this.argTypes[i], this.listsEval[i]);
                    this.caster.cast(this.pointable, this.listsArgs[i]);
                    int nextSize = this.getNumItems(outList, this.listsArgs[i].getByteArray(), this.listsArgs[i].getStartOffset());
                    if (nextSize >= minSize && minSize != -1) continue;
                    minSize = nextSize;
                    minListIndex = i;
                }
                if (returnNull) {
                    PointableHelper.setNull(result);
                    return;
                }
                if (outList.getTypeTag() == ATypeTag.ARRAY) {
                    if (this.orderedListBuilder == null) {
                        this.orderedListBuilder = new OrderedListBuilder();
                    }
                    listBuilder = this.orderedListBuilder;
                } else {
                    if (this.unorderedListBuilder == null) {
                        this.unorderedListBuilder = new UnorderedListBuilder();
                    }
                    listBuilder = this.unorderedListBuilder;
                }
                this.hashes.clear();
                IPointable listArg = this.listsArgs[minListIndex];
                this.listAccessor.reset(listArg.getByteArray(), listArg.getStartOffset());
                this.buildRestrictiveList(this.listAccessor);
                listBuilder.reset(outList);
                if (!this.hashes.isEmpty()) {
                    for (int listIndex = 0; listIndex < this.listsArgs.length; ++listIndex) {
                        listArg = this.listsArgs[listIndex];
                        this.listAccessor.reset(listArg.getByteArray(), listArg.getStartOffset());
                        this.processList(this.listAccessor, listIndex, listBuilder);
                    }
                }
                this.finalResult.reset();
                listBuilder.write(this.finalResult.getDataOutput(), true);
                result.set((IValueReference)this.finalResult);
            }
            catch (IOException e) {
                throw HyracksDataException.create((Throwable)e);
            }
            finally {
                this.caster.deallocatePointables();
                this.valueListIndexAllocator.reset();
                this.storageAllocator.reset();
                this.arrayListAllocator.reset();
                this.pointableAllocator.reset();
            }
        }

        private int getNumItems(AbstractCollectionType listType, byte[] listBytes, int offset) {
            if (listType.getTypeTag() == ATypeTag.ARRAY) {
                return AOrderedListSerializerDeserializer.getNumberOfItems((byte[])listBytes, (int)offset);
            }
            return AUnorderedListSerializerDeserializer.getNumberOfItems((byte[])listBytes, (int)offset);
        }

        private void buildRestrictiveList(ListAccessor listAccessor) throws IOException {
            if (listAccessor.size() > 0) {
                IVisitablePointable item = this.pointableAllocator.allocateEmpty();
                ArrayBackedValueStorage storage = (ArrayBackedValueStorage)this.storageAllocator.allocate(null);
                storage.reset();
                for (int j = 0; j < listAccessor.size(); ++j) {
                    List sameHashes;
                    int hash;
                    boolean itemInStorage = listAccessor.getOrWriteItem(j, (IPointable)item, storage);
                    this.validateItem((IPointable)item);
                    if (!this.notNullAndMissing((IPointable)item) || !this.addToSmallestList((IPointable)item, hash = this.binaryHashFunction.hash(item.getByteArray(), item.getStartOffset(), item.getLength()), sameHashes = (List)this.hashes.get(hash))) continue;
                    item = this.pointableAllocator.allocateEmpty();
                    if (!itemInStorage) continue;
                    storage = (ArrayBackedValueStorage)this.storageAllocator.allocate(null);
                    storage.reset();
                }
            }
        }

        private void processList(ListAccessor listAccessor, int listIndex, IAsterixListBuilder listBuilder) throws IOException {
            for (int j = 0; j < listAccessor.size(); ++j) {
                listAccessor.getOrWriteItem(j, this.pointable, this.currentItemStorage);
                this.validateItem(this.pointable);
                if (!this.notNullAndMissing(this.pointable)) continue;
                int hash = this.binaryHashFunction.hash(this.pointable.getByteArray(), this.pointable.getStartOffset(), this.pointable.getLength());
                List sameHashes = (List)this.hashes.get(hash);
                this.incrementIfCommonValue(this.pointable, sameHashes, listIndex, listBuilder);
            }
        }

        private boolean addToSmallestList(IPointable item, int hash, List<ValueListIndex> sameHashes) throws IOException {
            if (sameHashes == null) {
                List newHashes = (List)this.arrayListAllocator.allocate(null);
                newHashes.clear();
                ValueListIndex valueListIndex = (ValueListIndex)this.valueListIndexAllocator.allocate(null);
                valueListIndex.set(item, -1);
                newHashes.add(valueListIndex);
                this.hashes.put(hash, (Object)newHashes);
                return true;
            }
            if (ArrayFunctionsUtil.findItem((IValueReference)item, sameHashes, this.comp) == null) {
                ValueListIndex valueListIndex = (ValueListIndex)this.valueListIndexAllocator.allocate(null);
                valueListIndex.set(item, -1);
                sameHashes.add(valueListIndex);
                return true;
            }
            return false;
        }

        private void incrementIfCommonValue(IPointable item, List<ValueListIndex> sameHashes, int listIndex, IAsterixListBuilder listBuilder) throws IOException {
            if (sameHashes != null) {
                this.incrementIfExists(sameHashes, item, listIndex, listBuilder);
            }
        }

        private boolean notNullAndMissing(IPointable item) {
            byte tag = item.getByteArray()[item.getStartOffset()];
            return tag != ATypeTag.SERIALIZED_NULL_TYPE_TAG && tag != ATypeTag.SERIALIZED_MISSING_TYPE_TAG;
        }

        private void incrementIfExists(List<ValueListIndex> sameHashes, IPointable item, int listIndex, IAsterixListBuilder listBuilder) throws HyracksDataException {
            ValueListIndex sameValue = ArrayFunctionsUtil.findItem((IValueReference)item, sameHashes, this.comp);
            if (sameValue != null && listIndex - sameValue.listIndex == 1) {
                sameValue.listIndex = listIndex;
                if (listIndex == this.listsArgs.length - 1) {
                    listBuilder.addItem((IValueReference)item);
                }
            }
        }

        private void validateItem(IPointable item) throws RuntimeDataException {
            if (((ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(item.getByteArray()[item.getStartOffset()])).isDerivedType()) {
                throw new RuntimeDataException(36, ArrayIntersectDescriptor.this.sourceLoc, new Serializable[0]);
            }
        }
    }

    protected class ValueListIndexAllocator
    implements IObjectFactory<ValueListIndex, ATypeTag> {
        protected ValueListIndexAllocator() {
        }

        public ValueListIndex create(ATypeTag arg) {
            return new ValueListIndex();
        }
    }

    protected class ValueListIndex
    implements IValueReference {
        private IPointable value;
        private int listIndex;

        protected ValueListIndex() {
        }

        protected void set(IPointable value, int listIndex) {
            this.value = value;
            this.listIndex = listIndex;
        }

        public byte[] getByteArray() {
            return this.value.getByteArray();
        }

        public int getStartOffset() {
            return this.value.getStartOffset();
        }

        public int getLength() {
            return this.value.getLength();
        }
    }
}

