/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.IOException;
import java.io.Serializable;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.dataflow.data.nontagged.comparators.AObjectAscBinaryComparatorFactory;
import org.apache.asterix.om.base.AMutableInt32;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.runtime.evaluators.common.ListAccessor;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public abstract class AbstractArraySearchEval
implements IScalarEvaluator {
    private final IPointable listArg;
    private final IPointable searchedValueArg;
    private final IPointable tempVal;
    private final IScalarEvaluator listEval;
    private final IScalarEvaluator searchedValueEval;
    private final IBinaryComparator comp;
    private final ListAccessor listAccessor;
    private final SourceLocation sourceLocation;
    private final AMutableInt32 intValue;
    protected final ArrayBackedValueStorage storage = new ArrayBackedValueStorage();

    public AbstractArraySearchEval(IScalarEvaluatorFactory[] args, IHyracksTaskContext ctx, SourceLocation sourceLoc) throws HyracksDataException {
        this.listArg = new VoidPointable();
        this.searchedValueArg = new VoidPointable();
        this.tempVal = new VoidPointable();
        this.listEval = args[0].createScalarEvaluator(ctx);
        this.searchedValueEval = args[1].createScalarEvaluator(ctx);
        this.comp = AObjectAscBinaryComparatorFactory.INSTANCE.createBinaryComparator();
        this.listAccessor = new ListAccessor();
        this.intValue = new AMutableInt32(-1);
        this.sourceLocation = sourceLoc;
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        this.listEval.evaluate(tuple, this.listArg);
        byte[] listBytes = this.listArg.getByteArray();
        int listOffset = this.listArg.getStartOffset();
        this.searchedValueEval.evaluate(tuple, this.searchedValueArg);
        byte[] valueBytes = this.searchedValueArg.getByteArray();
        int valueOffset = this.searchedValueArg.getStartOffset();
        int valueLength = this.searchedValueArg.getLength();
        if (((ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(valueBytes[valueOffset])).isDerivedType()) {
            throw new RuntimeDataException(36, this.sourceLocation, new Serializable[0]);
        }
        if (!((ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(listBytes[listOffset])).isListType()) {
            PointableHelper.setNull(result);
            return;
        }
        this.intValue.setValue(-1);
        this.listAccessor.reset(listBytes, listOffset);
        int numItems = this.listAccessor.size();
        try {
            for (int i = 0; i < numItems; ++i) {
                this.listAccessor.getOrWriteItem(i, this.tempVal, this.storage);
                if (this.comp.compare(this.tempVal.getByteArray(), this.tempVal.getStartOffset(), this.tempVal.getLength(), valueBytes, valueOffset, valueLength) != 0) continue;
                this.intValue.setValue(i);
                break;
            }
            this.processResult(this.intValue, result);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    protected abstract void processResult(AMutableInt32 var1, IPointable var2) throws HyracksDataException;
}

