/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.IOException;
import java.util.List;
import org.apache.asterix.builders.AbvsBuilderFactory;
import org.apache.asterix.builders.ArrayListFactory;
import org.apache.asterix.builders.IAsterixListBuilder;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.builders.UnorderedListBuilder;
import org.apache.asterix.om.pointables.PointableAllocator;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnorderedListType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.TypeTagUtil;
import org.apache.asterix.om.util.container.IObjectFactory;
import org.apache.asterix.om.util.container.IObjectPool;
import org.apache.asterix.om.util.container.ListObjectPool;
import org.apache.asterix.runtime.evaluators.common.ListAccessor;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IMutableValueStorage;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public abstract class AbstractArrayProcessEval
implements IScalarEvaluator {
    private final AOrderedListType orderedListType = new AOrderedListType((IAType)BuiltinType.ANY, null);
    private final AUnorderedListType unorderedListType = new AUnorderedListType((IAType)BuiltinType.ANY, null);
    private final ArrayBackedValueStorage storage = new ArrayBackedValueStorage();
    private final IScalarEvaluator listArgEval;
    private final ListAccessor listAccessor;
    private final IPointable listArg = new VoidPointable();
    private IAType inputListType;
    private IAsterixListBuilder orderedListBuilder = null;
    private IAsterixListBuilder unorderedListBuilder = null;
    protected final PointableAllocator pointableAllocator = new PointableAllocator();
    protected final IObjectPool<IMutableValueStorage, ATypeTag> storageAllocator = new ListObjectPool((IObjectFactory)new AbvsBuilderFactory());
    protected final IObjectPool<List<IPointable>, ATypeTag> arrayListAllocator = new ListObjectPool((IObjectFactory)new ArrayListFactory());

    public AbstractArrayProcessEval(IScalarEvaluatorFactory[] args, IHyracksTaskContext ctx, IAType inputListType) throws HyracksDataException {
        this.listArgEval = args[0].createScalarEvaluator(ctx);
        this.listAccessor = new ListAccessor();
        this.inputListType = inputListType;
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        AbstractCollectionType outputListType;
        IAsterixListBuilder listBuilder;
        this.listArgEval.evaluate(tuple, this.listArg);
        byte listArgType = this.listArg.getByteArray()[this.listArg.getStartOffset()];
        if (listArgType == ATypeTag.SERIALIZED_ORDEREDLIST_TYPE_TAG) {
            if (this.orderedListBuilder == null) {
                this.orderedListBuilder = new OrderedListBuilder();
            }
            listBuilder = this.orderedListBuilder;
        } else if (listArgType == ATypeTag.SERIALIZED_UNORDEREDLIST_TYPE_TAG) {
            if (this.unorderedListBuilder == null) {
                this.unorderedListBuilder = new UnorderedListBuilder();
            }
            listBuilder = this.unorderedListBuilder;
        } else {
            PointableHelper.setNull(result);
            return;
        }
        this.listAccessor.reset(this.listArg.getByteArray(), this.listArg.getStartOffset());
        if (!this.inputListType.getTypeTag().isListType()) {
            ATypeTag itemType = this.listAccessor.getItemType();
            if (this.listAccessor.getListType() == ATypeTag.ARRAY) {
                this.orderedListType.setItemType(TypeTagUtil.getBuiltinTypeByTag((ATypeTag)itemType));
                outputListType = this.orderedListType;
            } else {
                this.unorderedListType.setItemType(TypeTagUtil.getBuiltinTypeByTag((ATypeTag)itemType));
                outputListType = this.unorderedListType;
            }
        } else {
            outputListType = (AbstractCollectionType)this.inputListType;
        }
        listBuilder.reset(outputListType);
        try {
            this.processList(this.listAccessor, listBuilder);
            this.storage.reset();
            listBuilder.write(this.storage.getDataOutput(), true);
            result.set((IValueReference)this.storage);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
        finally {
            this.pointableAllocator.reset();
            this.storageAllocator.reset();
            this.arrayListAllocator.reset();
        }
    }

    protected abstract void processList(ListAccessor var1, IAsterixListBuilder var2) throws IOException;
}

