/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.constructors;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.dataflow.data.nontagged.serde.ABooleanSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ADoubleSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AFloatSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt16SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt32SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt64SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt8SerializerDeserializer;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.runtime.evaluators.common.NumberUtils;
import org.apache.asterix.runtime.exceptions.InvalidDataFormatException;
import org.apache.asterix.runtime.exceptions.UnsupportedTypeException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.data.std.util.GrowableArray;
import org.apache.hyracks.data.std.util.UTF8StringBuilder;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public abstract class AbstractStringConstructorEvaluator
implements IScalarEvaluator {
    protected final IScalarEvaluator inputEval;
    protected final SourceLocation sourceLoc;
    protected final IPointable inputArg;
    protected final ArrayBackedValueStorage resultStorage;
    protected final DataOutput out;
    protected final UTF8StringBuilder builder;
    protected final GrowableArray baaos;

    protected AbstractStringConstructorEvaluator(IScalarEvaluator inputEval, SourceLocation sourceLoc) {
        this.inputEval = inputEval;
        this.sourceLoc = sourceLoc;
        this.resultStorage = new ArrayBackedValueStorage();
        this.out = this.resultStorage.getDataOutput();
        this.inputArg = new VoidPointable();
        this.builder = new UTF8StringBuilder();
        this.baaos = new GrowableArray();
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        try {
            this.inputEval.evaluate(tuple, this.inputArg);
            this.resultStorage.reset();
            this.evaluateImpl(result);
        }
        catch (IOException e) {
            throw new InvalidDataFormatException(this.sourceLoc, this.getIdentifier(), e, ATypeTag.SERIALIZED_STRING_TYPE_TAG);
        }
    }

    protected void evaluateImpl(IPointable result) throws IOException {
        int offset;
        byte[] serString = this.inputArg.getByteArray();
        ATypeTag tt = ATypeTag.VALUE_TYPE_MAPPING[serString[offset = this.inputArg.getStartOffset()]];
        if (tt == ATypeTag.STRING) {
            result.set((IValueReference)this.inputArg);
        } else {
            int len = this.inputArg.getLength();
            this.baaos.reset();
            this.builder.reset(this.baaos, len);
            int startOffset = offset + 1;
            switch (tt) {
                case TINYINT: {
                    byte i = AInt8SerializerDeserializer.getByte((byte[])serString, (int)startOffset);
                    this.builder.appendString(String.valueOf(i));
                    break;
                }
                case SMALLINT: {
                    short i = AInt16SerializerDeserializer.getShort((byte[])serString, (int)startOffset);
                    this.builder.appendString(String.valueOf(i));
                    break;
                }
                case INTEGER: {
                    int i = AInt32SerializerDeserializer.getInt((byte[])serString, (int)startOffset);
                    this.builder.appendString(String.valueOf(i));
                    break;
                }
                case BIGINT: {
                    long l = AInt64SerializerDeserializer.getLong((byte[])serString, (int)startOffset);
                    this.builder.appendString(String.valueOf(l));
                    break;
                }
                case DOUBLE: {
                    double d = ADoubleSerializerDeserializer.getDouble((byte[])serString, (int)startOffset);
                    if (Double.isNaN(d)) {
                        this.builder.appendUtf8StringPointable(NumberUtils.NAN);
                        break;
                    }
                    if (d == Double.POSITIVE_INFINITY) {
                        this.builder.appendUtf8StringPointable(NumberUtils.POSITIVE_INF);
                        break;
                    }
                    if (d == Double.NEGATIVE_INFINITY) {
                        this.builder.appendUtf8StringPointable(NumberUtils.NEGATIVE_INF);
                        break;
                    }
                    this.builder.appendString(String.valueOf(d));
                    break;
                }
                case FLOAT: {
                    float f = AFloatSerializerDeserializer.getFloat((byte[])serString, (int)startOffset);
                    if (Float.isNaN(f)) {
                        this.builder.appendUtf8StringPointable(NumberUtils.NAN);
                        break;
                    }
                    if (f == Float.POSITIVE_INFINITY) {
                        this.builder.appendUtf8StringPointable(NumberUtils.POSITIVE_INF);
                        break;
                    }
                    if (f == Float.NEGATIVE_INFINITY) {
                        this.builder.appendUtf8StringPointable(NumberUtils.NEGATIVE_INF);
                        break;
                    }
                    this.builder.appendString(String.valueOf(f));
                    break;
                }
                case BOOLEAN: {
                    boolean b = ABooleanSerializerDeserializer.getBoolean((byte[])serString, (int)startOffset);
                    this.builder.appendString(String.valueOf(b));
                    break;
                }
                default: {
                    throw new UnsupportedTypeException(this.sourceLoc, this.getIdentifier(), serString[offset]);
                }
            }
            this.builder.finish();
            this.out.write(ATypeTag.SERIALIZED_STRING_TYPE_TAG);
            this.out.write(this.baaos.getByteArray(), 0, this.baaos.getLength());
            result.set((IValueReference)this.resultStorage);
        }
    }

    protected abstract FunctionIdentifier getIdentifier();
}

