/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.constructors;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.ADouble;
import org.apache.asterix.om.base.AMutableDouble;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.common.NumberUtils;
import org.apache.asterix.runtime.evaluators.staticcodegen.TypeChecker;
import org.apache.asterix.runtime.exceptions.InvalidDataFormatException;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public abstract class AbstractDoubleConstructorEvaluator$_EvaluatorGen
implements IScalarEvaluator {
    protected static final ISerializerDeserializer<ADouble> DOUBLE_SERDE = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADOUBLE);
    protected final IScalarEvaluator inputEval;
    protected final SourceLocation sourceLoc;
    protected final ArrayBackedValueStorage resultStorage;
    protected final DataOutput out;
    protected final IPointable inputArg;
    protected final AMutableDouble aDouble;
    protected final UTF8StringPointable utf8Ptr;
    private final TypeChecker typeChecker;

    protected AbstractDoubleConstructorEvaluator$_EvaluatorGen(IScalarEvaluator inputEval, SourceLocation sourceLoc) {
        this.inputEval = inputEval;
        this.sourceLoc = sourceLoc;
        this.resultStorage = new ArrayBackedValueStorage();
        this.out = this.resultStorage.getDataOutput();
        this.inputArg = new VoidPointable();
        this.aDouble = new AMutableDouble(0.0);
        this.utf8Ptr = new UTF8StringPointable();
        this.typeChecker = new TypeChecker();
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        try {
            this.inputEval.evaluate(tuple, this.inputArg);
            if (this.typeChecker.isMissing(this.inputArg, result)) {
                return;
            }
            if (this.typeChecker.isNull(result)) {
                return;
            }
            this.resultStorage.reset();
            this.evaluateImpl(result);
        }
        catch (IOException e) {
            throw new InvalidDataFormatException(this.sourceLoc, this.getIdentifier(), e, ATypeTag.SERIALIZED_DOUBLE_TYPE_TAG);
        }
    }

    protected void evaluateImpl(IPointable result) throws IOException {
        int startOffset;
        byte[] bytes = this.inputArg.getByteArray();
        byte tt = bytes[startOffset = this.inputArg.getStartOffset()];
        if (tt == ATypeTag.SERIALIZED_DOUBLE_TYPE_TAG) {
            result.set((IValueReference)this.inputArg);
        } else if (tt == ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
            this.utf8Ptr.set(bytes, startOffset + 1, this.inputArg.getLength() - 1);
            if (NumberUtils.parseDouble(this.utf8Ptr, this.aDouble)) {
                DOUBLE_SERDE.serialize((Object)this.aDouble, this.out);
                result.set((IValueReference)this.resultStorage);
            } else {
                this.handleUparseableString(result);
            }
        } else {
            throw new TypeMismatchException(this.sourceLoc, this.getIdentifier(), (Integer)0, tt, ATypeTag.SERIALIZED_STRING_TYPE_TAG);
        }
    }

    protected void handleUparseableString(IPointable result) throws HyracksDataException {
        throw new InvalidDataFormatException(this.sourceLoc, this.getIdentifier(), ATypeTag.SERIALIZED_DOUBLE_TYPE_TAG);
    }

    protected abstract FunctionIdentifier getIdentifier();
}

