/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.constructors;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.ALine;
import org.apache.asterix.om.base.AMutableLine;
import org.apache.asterix.om.base.AMutablePoint;
import org.apache.asterix.om.base.APoint;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.exceptions.InvalidDataFormatException;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class ALineConstructorDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new ALineConstructorDescriptor();
        }
    };

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(final IHyracksTaskContext ctx) throws HyracksDataException {
                return new IScalarEvaluator(){
                    private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
                    private DataOutput out = this.resultStorage.getDataOutput();
                    private IPointable inputArg = new VoidPointable();
                    private IScalarEvaluator eval;
                    private AMutableLine aLine;
                    private AMutablePoint[] aPoint;
                    private ISerializerDeserializer<ALine> lineSerde;
                    private final UTF8StringPointable utf8Ptr;
                    {
                        this.eval = args[0].createScalarEvaluator(ctx);
                        this.aLine = new AMutableLine(null, null);
                        this.aPoint = new AMutablePoint[]{new AMutablePoint(0.0, 0.0), new AMutablePoint(0.0, 0.0)};
                        this.lineSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ALINE);
                        this.utf8Ptr = new UTF8StringPointable();
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        block4: {
                            try {
                                this.eval.evaluate(tuple, this.inputArg);
                                byte[] serString = this.inputArg.getByteArray();
                                int offset = this.inputArg.getStartOffset();
                                int len = this.inputArg.getLength();
                                byte tt = serString[offset];
                                if (tt == ATypeTag.SERIALIZED_LINE_TYPE_TAG) {
                                    result.set((IValueReference)this.inputArg);
                                    break block4;
                                }
                                if (tt == ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
                                    this.resultStorage.reset();
                                    this.utf8Ptr.set(serString, offset + 1, len - 1);
                                    String s = this.utf8Ptr.toString();
                                    int commaIndex = s.indexOf(44);
                                    int spaceIndex = s.indexOf(32, commaIndex + 1);
                                    this.aPoint[0].setValue(Double.parseDouble(s.substring(0, commaIndex)), Double.parseDouble(s.substring(commaIndex + 1, spaceIndex)));
                                    commaIndex = s.indexOf(44, spaceIndex + 1);
                                    this.aPoint[1].setValue(Double.parseDouble(s.substring(spaceIndex + 1, commaIndex)), Double.parseDouble(s.substring(commaIndex + 1, s.length())));
                                    this.aLine.setValue((APoint)this.aPoint[0], (APoint)this.aPoint[1]);
                                    this.lineSerde.serialize((Object)this.aLine, this.out);
                                    result.set((IValueReference)this.resultStorage);
                                    break block4;
                                }
                                throw new TypeMismatchException(ALineConstructorDescriptor.this.sourceLoc, ALineConstructorDescriptor.this.getIdentifier(), (Integer)0, tt, ATypeTag.SERIALIZED_STRING_TYPE_TAG);
                            }
                            catch (IOException e) {
                                throw new InvalidDataFormatException(ALineConstructorDescriptor.this.sourceLoc, ALineConstructorDescriptor.this.getIdentifier(), e, ATypeTag.SERIALIZED_INTERVAL_TYPE_TAG);
                            }
                        }
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.LINE_CONSTRUCTOR;
    }
}

