/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.constructors;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AInt8;
import org.apache.asterix.om.base.AMutableInt8;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.exceptions.InvalidDataFormatException;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class AInt8ConstructorDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new AInt8ConstructorDescriptor();
        }
    };

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(final IHyracksTaskContext ctx) throws HyracksDataException {
                return new IScalarEvaluator(){
                    private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
                    private DataOutput out = this.resultStorage.getDataOutput();
                    private IPointable inputArg = new VoidPointable();
                    private IScalarEvaluator eval;
                    private byte value;
                    private int offset;
                    private boolean positive;
                    private AMutableInt8 aInt8;
                    private ISerializerDeserializer<AInt8> int8Serde;
                    private final UTF8StringPointable utf8Ptr;
                    {
                        this.eval = args[0].createScalarEvaluator(ctx);
                        this.aInt8 = new AMutableInt8(0);
                        this.int8Serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT8);
                        this.utf8Ptr = new UTF8StringPointable();
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        block12: {
                            try {
                                this.eval.evaluate(tuple, this.inputArg);
                                byte[] serString = this.inputArg.getByteArray();
                                int startOffset = this.inputArg.getStartOffset();
                                int len = this.inputArg.getLength();
                                byte tt = serString[startOffset];
                                if (tt == ATypeTag.SERIALIZED_INT8_TYPE_TAG) {
                                    result.set((IValueReference)this.inputArg);
                                    break block12;
                                }
                                if (tt == ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
                                    this.resultStorage.reset();
                                    this.utf8Ptr.set(serString, startOffset + 1, len - 1);
                                    this.offset = this.utf8Ptr.getCharStartOffset();
                                    this.value = 0;
                                    this.positive = true;
                                    int limit = -127;
                                    if (serString[this.offset] == 43) {
                                        ++this.offset;
                                    } else if (serString[this.offset] == 45) {
                                        ++this.offset;
                                        this.positive = false;
                                        limit = -128;
                                    }
                                    int end = startOffset + len;
                                    while (this.offset < end) {
                                        if (serString[this.offset] < 48 || serString[this.offset] > 57) {
                                            if (serString[this.offset] == 105 && serString[this.offset + 1] == 56 && this.offset + 2 == end) break;
                                            throw new InvalidDataFormatException(AInt8ConstructorDescriptor.this.sourceLoc, AInt8ConstructorDescriptor.this.getIdentifier(), ATypeTag.SERIALIZED_INT8_TYPE_TAG);
                                        }
                                        this.value = (byte)(this.value * 10);
                                        int digit = serString[this.offset] - 48;
                                        if (this.value < limit + digit) {
                                            throw new InvalidDataFormatException(AInt8ConstructorDescriptor.this.sourceLoc, AInt8ConstructorDescriptor.this.getIdentifier(), ATypeTag.SERIALIZED_INT8_TYPE_TAG);
                                        }
                                        this.value = (byte)(this.value - digit);
                                        ++this.offset;
                                    }
                                    if (this.value > 0) {
                                        throw new InvalidDataFormatException(AInt8ConstructorDescriptor.this.sourceLoc, AInt8ConstructorDescriptor.this.getIdentifier(), ATypeTag.SERIALIZED_INT8_TYPE_TAG);
                                    }
                                    if (this.value < 0 && this.positive) {
                                        this.value = (byte)(this.value * -1);
                                    }
                                    this.aInt8.setValue(this.value);
                                    this.int8Serde.serialize((Object)this.aInt8, this.out);
                                    result.set((IValueReference)this.resultStorage);
                                    break block12;
                                }
                                throw new TypeMismatchException(AInt8ConstructorDescriptor.this.sourceLoc, AInt8ConstructorDescriptor.this.getIdentifier(), (Integer)0, tt, ATypeTag.SERIALIZED_STRING_TYPE_TAG);
                            }
                            catch (IOException e1) {
                                throw new InvalidDataFormatException(AInt8ConstructorDescriptor.this.sourceLoc, AInt8ConstructorDescriptor.this.getIdentifier(), e1, ATypeTag.SERIALIZED_INT8_TYPE_TAG);
                            }
                        }
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.INT8_CONSTRUCTOR;
    }
}

