/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.constructors;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.ADateTime;
import org.apache.asterix.om.base.AMutableDateTime;
import org.apache.asterix.om.base.temporal.ADateParserFactory;
import org.apache.asterix.om.base.temporal.ATimeParserFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.constructors.ADateTimeConstructorDescriptor$_EvaluatorFactoryGen;
import org.apache.asterix.runtime.evaluators.constructors.ADateTimeConstructorDescriptor$_Gen;
import org.apache.asterix.runtime.evaluators.staticcodegen.TypeChecker;
import org.apache.asterix.runtime.exceptions.InvalidDataFormatException;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

class ADateTimeConstructorDescriptor$_EvaluatorGen
implements IScalarEvaluator {
    private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private DataOutput out = this.resultStorage.getDataOutput();
    private IPointable inputArg = new VoidPointable();
    private IScalarEvaluator eval;
    private AMutableDateTime aDateTime;
    private ISerializerDeserializer<ADateTime> datetimeSerde;
    private final UTF8StringPointable utf8Ptr;
    final /* synthetic */ IHyracksTaskContext val$ctx;
    final /* synthetic */ ADateTimeConstructorDescriptor$_EvaluatorFactoryGen this$1;
    private final TypeChecker typeChecker;

    ADateTimeConstructorDescriptor$_EvaluatorGen(ADateTimeConstructorDescriptor$_EvaluatorFactoryGen this$1, IHyracksTaskContext iHyracksTaskContext) throws HyracksDataException {
        this.this$1 = this$1;
        this.val$ctx = iHyracksTaskContext;
        this.eval = this.this$1.val$args[0].createScalarEvaluator(this.val$ctx);
        this.aDateTime = new AMutableDateTime(0L);
        this.datetimeSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADATETIME);
        this.utf8Ptr = new UTF8StringPointable();
        this.typeChecker = new TypeChecker();
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        block8: {
            try {
                this.resultStorage.reset();
                this.eval.evaluate(tuple, this.inputArg);
                if (this.typeChecker.isMissing(this.inputArg, result)) {
                    return;
                }
                if (this.typeChecker.isNull(result)) {
                    return;
                }
                byte[] serString = this.inputArg.getByteArray();
                int offset = this.inputArg.getStartOffset();
                int len = this.inputArg.getLength();
                byte tt = serString[offset];
                if (tt == ATypeTag.SERIALIZED_DATETIME_TYPE_TAG) {
                    result.set((IValueReference)this.inputArg);
                    break block8;
                }
                if (tt == ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
                    this.utf8Ptr.set(serString, offset + 1, len - 1);
                    int stringLength = this.utf8Ptr.getUTF8Length();
                    int startOffset = this.utf8Ptr.getCharStartOffset();
                    if (stringLength < 14) {
                        throw new InvalidDataFormatException(ADateTimeConstructorDescriptor$_Gen.access$000(this.this$1.this$0), this.this$1.this$0.getIdentifier(), ATypeTag.SERIALIZED_DATETIME_TYPE_TAG);
                    }
                    short timeOffset = (short)(serString[startOffset] == 45 ? 1 : 0);
                    timeOffset = (short)(timeOffset + 8);
                    if (serString[startOffset + timeOffset] != 84 && serString[startOffset + (timeOffset = (short)(timeOffset + 2))] != 84) {
                        throw new InvalidDataFormatException(ADateTimeConstructorDescriptor$_Gen.access$100(this.this$1.this$0), this.this$1.this$0.getIdentifier(), ATypeTag.SERIALIZED_DATETIME_TYPE_TAG);
                    }
                    long chrononTimeInMs = ADateParserFactory.parseDatePart((byte[])serString, (int)startOffset, (int)timeOffset);
                    this.aDateTime.setValue(chrononTimeInMs += (long)ATimeParserFactory.parseTimePart((byte[])serString, (int)(startOffset + timeOffset + 1), (int)(stringLength - timeOffset - 1)));
                    this.datetimeSerde.serialize((Object)this.aDateTime, this.out);
                    result.set((IValueReference)this.resultStorage);
                    break block8;
                }
                throw new TypeMismatchException(ADateTimeConstructorDescriptor$_Gen.access$200(this.this$1.this$0), this.this$1.this$0.getIdentifier(), (Integer)0, tt, ATypeTag.SERIALIZED_STRING_TYPE_TAG);
            }
            catch (IOException e) {
                throw new InvalidDataFormatException(ADateTimeConstructorDescriptor$_Gen.access$300(this.this$1.this$0), this.this$1.this$0.getIdentifier(), e, ATypeTag.SERIALIZED_DATETIME_TYPE_TAG);
            }
        }
    }
}

