/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.comparisons;

import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.base.ANull;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.runtime.evaluators.comparisons.AbstractComparisonEvaluator;
import org.apache.asterix.runtime.exceptions.UnsupportedTypeException;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;

public abstract class AbstractValueComparisonEvaluator
extends AbstractComparisonEvaluator {
    protected ISerializerDeserializer<ABoolean> serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ABOOLEAN);
    protected ISerializerDeserializer<ANull> nullSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ANULL);

    public AbstractValueComparisonEvaluator(IScalarEvaluatorFactory evalLeftFactory, IScalarEvaluatorFactory evalRightFactory, IHyracksTaskContext ctx, SourceLocation sourceLoc) throws HyracksDataException {
        super(evalLeftFactory, evalRightFactory, ctx, sourceLoc);
    }

    @Override
    protected void evaluateImpl(IPointable result) throws HyracksDataException {
        this.resultStorage.reset();
        if (this.isTotallyOrderable()) {
            this.checkTotallyOrderable();
        }
        if (this.comparabilityCheck()) {
            int r = this.compare();
            ABoolean b = this.getComparisonResult(r) ? ABoolean.TRUE : ABoolean.FALSE;
            this.serde.serialize((Object)b, this.out);
        } else {
            this.nullSerde.serialize((Object)ANull.NULL, this.out);
        }
        result.set((IValueReference)this.resultStorage);
    }

    protected abstract boolean isTotallyOrderable();

    protected abstract boolean getComparisonResult(int var1);

    protected void checkTotallyOrderable() throws HyracksDataException {
        if (this.argLeft.getLength() != 0) {
            ATypeTag typeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(this.argLeft.getTag());
            switch (typeTag) {
                case DURATION: 
                case INTERVAL: 
                case LINE: 
                case POINT: 
                case POINT3D: 
                case POLYGON: 
                case CIRCLE: 
                case RECTANGLE: {
                    throw new UnsupportedTypeException(this.sourceLoc, "comparison operations (>, >=, <, and <=)", this.argLeft.getTag());
                }
            }
            return;
        }
    }
}

