/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.accessors;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.dataflow.data.nontagged.serde.ADayTimeDurationSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ADurationSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt32SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt64SerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AInt64;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.base.temporal.GregorianCalendarSystem;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class TemporalMillisecondAccessor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    private static final FunctionIdentifier FID = BuiltinFunctions.ACCESSOR_TEMPORAL_MILLISEC;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new TemporalMillisecondAccessor();
        }
    };

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(final IHyracksTaskContext ctx) throws HyracksDataException {
                return new IScalarEvaluator(){
                    private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
                    private final DataOutput out = this.resultStorage.getDataOutput();
                    private final IPointable argPtr = new VoidPointable();
                    private final IScalarEvaluator eval;
                    private final GregorianCalendarSystem calSystem;
                    private final ISerializerDeserializer<AInt64> intSerde;
                    private final AMutableInt64 aMutableInt64;
                    {
                        this.eval = args[0].createScalarEvaluator(ctx);
                        this.calSystem = GregorianCalendarSystem.getInstance();
                        this.intSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT64);
                        this.aMutableInt64 = new AMutableInt64(0L);
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        this.eval.evaluate(tuple, this.argPtr);
                        byte[] bytes = this.argPtr.getByteArray();
                        int startOffset = this.argPtr.getStartOffset();
                        this.resultStorage.reset();
                        try {
                            if (bytes[startOffset] == ATypeTag.SERIALIZED_DURATION_TYPE_TAG) {
                                this.aMutableInt64.setValue((long)this.calSystem.getDurationMillisecond(ADurationSerializerDeserializer.getDayTime((byte[])bytes, (int)(startOffset + 1))));
                                this.intSerde.serialize((Object)this.aMutableInt64, this.out);
                                result.set((IValueReference)this.resultStorage);
                                return;
                            }
                            if (bytes[startOffset] == ATypeTag.SERIALIZED_DAY_TIME_DURATION_TYPE_TAG) {
                                this.aMutableInt64.setValue((long)this.calSystem.getDurationMillisecond(ADayTimeDurationSerializerDeserializer.getDayTime((byte[])bytes, (int)(startOffset + 1))));
                                this.intSerde.serialize((Object)this.aMutableInt64, this.out);
                                result.set((IValueReference)this.resultStorage);
                                return;
                            }
                            long chrononTimeInMs = 0L;
                            if (bytes[startOffset] == ATypeTag.SERIALIZED_TIME_TYPE_TAG) {
                                chrononTimeInMs = AInt32SerializerDeserializer.getInt((byte[])bytes, (int)(startOffset + 1));
                            } else if (bytes[startOffset] == ATypeTag.SERIALIZED_DATETIME_TYPE_TAG) {
                                chrononTimeInMs = AInt64SerializerDeserializer.getLong((byte[])bytes, (int)(startOffset + 1));
                            } else {
                                throw new TypeMismatchException(TemporalMillisecondAccessor.this.sourceLoc, TemporalMillisecondAccessor.this.getIdentifier(), (Integer)0, bytes[startOffset], ATypeTag.SERIALIZED_DURATION_TYPE_TAG, ATypeTag.SERIALIZED_DAY_TIME_DURATION_TYPE_TAG, ATypeTag.SERIALIZED_TIME_TYPE_TAG, ATypeTag.SERIALIZED_DATETIME_TYPE_TAG);
                            }
                            int ms = this.calSystem.getMillisOfSec(chrononTimeInMs);
                            this.aMutableInt64.setValue((long)ms);
                            this.intSerde.serialize((Object)this.aMutableInt64, this.out);
                        }
                        catch (IOException e) {
                            throw HyracksDataException.create((Throwable)e);
                        }
                        result.set((IValueReference)this.resultStorage);
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return FID;
    }
}

