/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.aggregates.std;

import java.io.IOException;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.ANull;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.aggregates.std.AbstractSumAggregateFunction;
import org.apache.asterix.runtime.exceptions.UnsupportedItemTypeException;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class SqlSumAggregateFunction
extends AbstractSumAggregateFunction {
    private final boolean isLocalAgg;

    public SqlSumAggregateFunction(IScalarEvaluatorFactory[] args, IHyracksTaskContext context, boolean isLocalAgg, SourceLocation sourceLoc) throws HyracksDataException {
        super(args, context, sourceLoc);
        this.isLocalAgg = isLocalAgg;
    }

    @Override
    protected void processNull() {
    }

    @Override
    protected void processSystemNull() throws HyracksDataException {
        if (this.isLocalAgg) {
            throw new UnsupportedItemTypeException(this.sourceLoc, BuiltinFunctions.SQL_SUM, ATypeTag.SERIALIZED_SYSTEM_NULL_TYPE_TAG);
        }
    }

    @Override
    protected void finishSystemNull() throws IOException {
        if (this.isLocalAgg) {
            this.resultStorage.getDataOutput().writeByte(ATypeTag.SYSTEM_NULL.serialize());
        } else {
            this.serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ANULL);
            this.serde.serialize((Object)ANull.NULL, this.resultStorage.getDataOutput());
        }
    }
}

