/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.rtree.impls;

import java.util.List;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilter;
import org.apache.hyracks.storage.am.btree.api.IBTreeLeafFrame;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.btree.impls.BTreeRangeSearchCursor;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.common.api.ILSMIndexCursor;
import org.apache.hyracks.storage.am.common.impls.NoOpIndexAccessParameters;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMHarness;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeCursorInitialState;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeDiskComponent;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeMemoryComponent;
import org.apache.hyracks.storage.am.rtree.api.IRTreeInteriorFrame;
import org.apache.hyracks.storage.am.rtree.api.IRTreeLeafFrame;
import org.apache.hyracks.storage.am.rtree.impls.RTree;
import org.apache.hyracks.storage.am.rtree.impls.RTreeSearchCursor;
import org.apache.hyracks.storage.am.rtree.impls.SearchPredicate;
import org.apache.hyracks.storage.common.EnforcedIndexCursor;
import org.apache.hyracks.storage.common.ICursorInitialState;
import org.apache.hyracks.storage.common.IIndexAccessParameters;
import org.apache.hyracks.storage.common.IModificationOperationCallback;
import org.apache.hyracks.storage.common.ISearchOperationCallback;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.MultiComparator;

public abstract class LSMRTreeAbstractCursor
extends EnforcedIndexCursor
implements ILSMIndexCursor {
    protected boolean open;
    protected RTreeSearchCursor[] rtreeCursors;
    protected BTreeRangeSearchCursor[] btreeCursors;
    protected RTree.RTreeAccessor[] rtreeAccessors;
    protected BTree.BTreeAccessor[] btreeAccessors;
    protected BloomFilter[] bloomFilters;
    protected MultiComparator btreeCmp;
    protected int numberOfTrees;
    protected SearchPredicate rtreeSearchPredicate;
    protected RangePredicate btreeRangePredicate;
    protected ITupleReference frameTuple;
    protected boolean includeMutableComponent;
    protected ILSMHarness lsmHarness;
    protected boolean foundNext;
    protected final ILSMIndexOperationContext opCtx;
    protected ISearchOperationCallback searchCallback;
    protected List<ILSMComponent> operationalComponents;
    protected long[] hashes = BloomFilter.createHashArray();

    public LSMRTreeAbstractCursor(ILSMIndexOperationContext opCtx) {
        this.opCtx = opCtx;
        this.btreeRangePredicate = new RangePredicate(null, null, true, true, null, null);
    }

    public RTreeSearchCursor getCursor(int cursorIndex) {
        return this.rtreeCursors[cursorIndex];
    }

    public void doOpen(ICursorInitialState initialState, ISearchPredicate searchPred) throws HyracksDataException {
        LSMRTreeCursorInitialState lsmInitialState = (LSMRTreeCursorInitialState)initialState;
        if (this.btreeCmp == null) {
            this.btreeCmp = lsmInitialState.getBTreeCmp();
            this.btreeRangePredicate.setLowKeyCmp(this.btreeCmp);
            this.btreeRangePredicate.setHighKeyCmp(this.btreeCmp);
        }
        this.operationalComponents = lsmInitialState.getOperationalComponents();
        this.lsmHarness = lsmInitialState.getLSMHarness();
        this.numberOfTrees = this.operationalComponents.size();
        this.searchCallback = lsmInitialState.getSearchOperationCallback();
        int numComponenets = this.operationalComponents.size();
        if (this.rtreeCursors == null || this.rtreeCursors.length != numComponenets) {
            this.rtreeCursors = new RTreeSearchCursor[this.numberOfTrees];
            this.btreeCursors = new BTreeRangeSearchCursor[this.numberOfTrees];
            this.rtreeAccessors = new RTree.RTreeAccessor[this.numberOfTrees];
            this.btreeAccessors = new BTree.BTreeAccessor[this.numberOfTrees];
            this.bloomFilters = new BloomFilter[this.numberOfTrees];
        }
        this.includeMutableComponent = false;
        for (int i = 0; i < this.numberOfTrees; ++i) {
            BTree btree;
            RTree rtree;
            ILSMComponent component = this.operationalComponents.get(i);
            if (component.getType() == ILSMComponent.LSMComponentType.MEMORY) {
                this.includeMutableComponent = true;
                if (this.btreeCursors[i] == null) {
                    this.btreeCursors[i] = new BTreeRangeSearchCursor((IBTreeLeafFrame)lsmInitialState.getBTreeLeafFrameFactory().createFrame(), false);
                } else {
                    this.btreeCursors[i].close();
                }
                rtree = ((LSMRTreeMemoryComponent)component).getIndex();
                btree = ((LSMRTreeMemoryComponent)component).getBuddyIndex();
                this.bloomFilters[i] = null;
            } else {
                if (this.btreeCursors[i] == null) {
                    this.btreeCursors[i] = new BTreeRangeSearchCursor((IBTreeLeafFrame)lsmInitialState.getBTreeLeafFrameFactory().createFrame(), false);
                } else {
                    this.btreeCursors[i].close();
                }
                rtree = ((LSMRTreeDiskComponent)component).getIndex();
                btree = ((LSMRTreeDiskComponent)component).getBuddyIndex();
                this.bloomFilters[i] = ((LSMRTreeDiskComponent)component).getBloomFilter();
            }
            if (this.rtreeCursors[i] == null) {
                this.rtreeCursors[i] = new RTreeSearchCursor((IRTreeInteriorFrame)lsmInitialState.getRTreeInteriorFrameFactory().createFrame(), (IRTreeLeafFrame)lsmInitialState.getRTreeLeafFrameFactory().createFrame());
            } else {
                this.rtreeCursors[i].close();
            }
            if (this.rtreeAccessors[i] == null) {
                this.rtreeAccessors[i] = rtree.createAccessor((IIndexAccessParameters)NoOpIndexAccessParameters.INSTANCE);
                this.btreeAccessors[i] = btree.createAccessor((IIndexAccessParameters)NoOpIndexAccessParameters.INSTANCE);
                continue;
            }
            this.rtreeAccessors[i].reset(rtree, (IModificationOperationCallback)NoOpOperationCallback.INSTANCE);
            this.btreeAccessors[i].reset(btree, (IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
        }
        this.rtreeSearchPredicate = (SearchPredicate)searchPred;
        this.btreeRangePredicate.setHighKey(null);
        this.btreeRangePredicate.setLowKey(null);
        this.open = true;
    }

    public void doDestroy() throws HyracksDataException {
        if (!this.open) {
            return;
        }
        try {
            if (this.rtreeCursors != null && this.btreeCursors != null) {
                for (int i = 0; i < this.numberOfTrees; ++i) {
                    this.rtreeCursors[i].destroy();
                    this.btreeCursors[i].destroy();
                }
            }
            this.rtreeCursors = null;
            this.btreeCursors = null;
        }
        finally {
            this.lsmHarness.endSearch(this.opCtx);
        }
        this.foundNext = false;
        this.open = false;
    }

    public ITupleReference doGetTuple() {
        return this.frameTuple;
    }

    public boolean getSearchOperationCallbackProceedResult() {
        return false;
    }
}

