/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.rtree.impls;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ILinearizeComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomCalculations;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilterSpecification;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.common.api.IIndexOperationContext;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrameFactory;
import org.apache.hyracks.storage.am.common.api.ITwoPCIndexBulkLoader;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponentFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMHarness;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallbackFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationScheduler;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexFileManager;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicy;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTracker;
import org.apache.hyracks.storage.am.lsm.common.api.ITwoPCIndex;
import org.apache.hyracks.storage.am.lsm.common.impls.ChainedLSMDiskComponentBulkLoader;
import org.apache.hyracks.storage.am.lsm.common.impls.ExternalIndexHarness;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFileReferences;
import org.apache.hyracks.storage.am.lsm.common.impls.LoadOperation;
import org.apache.hyracks.storage.am.lsm.rtree.impls.ExternalRTreeOpContext;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTree;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeAccessor;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeDeletedKeysBTreeMergeCursor;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeDiskComponent;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeMergeOperation;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeSortedCursor;
import org.apache.hyracks.storage.am.rtree.impls.SearchPredicate;
import org.apache.hyracks.storage.common.ICursorInitialState;
import org.apache.hyracks.storage.common.IIndexAccessParameters;
import org.apache.hyracks.storage.common.IIndexBulkLoader;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.ISearchOperationCallback;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;
import org.apache.hyracks.storage.common.buffercache.IPageWriteFailureCallback;
import org.apache.hyracks.util.trace.ITracer;

public class ExternalRTree
extends LSMRTree
implements ITwoPCIndex {
    private final List<ILSMDiskComponent> secondDiskComponents = new LinkedList<ILSMDiskComponent>();
    private int version = 0;
    private final int fieldCount;

    public ExternalRTree(IIOManager ioManager, ITreeIndexFrameFactory rtreeInteriorFrameFactory, ITreeIndexFrameFactory rtreeLeafFrameFactory, ITreeIndexFrameFactory btreeInteriorFrameFactory, ITreeIndexFrameFactory btreeLeafFrameFactory, IBufferCache diskBufferCache, ILSMIndexFileManager fileNameManager, ILSMDiskComponentFactory componentFactory, double bloomFilterFalsePositiveRate, int fieldCount, IBinaryComparatorFactory[] rtreeCmpFactories, IBinaryComparatorFactory[] btreeCmpFactories, ILinearizeComparatorFactory linearizer, int[] comparatorFields, IBinaryComparatorFactory[] linearizerArray, ILSMMergePolicy mergePolicy, ILSMOperationTracker opTracker, ILSMIOOperationScheduler ioScheduler, ILSMIOOperationCallbackFactory ioOpCallbackFactory, int[] buddyBTreeFields, boolean durable, boolean isPointMBR, ITracer tracer) throws HyracksDataException {
        super(ioManager, rtreeInteriorFrameFactory, rtreeLeafFrameFactory, btreeInteriorFrameFactory, btreeLeafFrameFactory, diskBufferCache, fileNameManager, componentFactory, bloomFilterFalsePositiveRate, rtreeCmpFactories, btreeCmpFactories, linearizer, comparatorFields, linearizerArray, mergePolicy, opTracker, ioScheduler, ioOpCallbackFactory, buddyBTreeFields, durable, isPointMBR, tracer);
        this.fieldCount = fieldCount;
    }

    public ExternalIndexHarness getHarness() {
        return (ExternalIndexHarness)super.getHarness();
    }

    public void subsumeMergedComponents(ILSMDiskComponent newComponent, List<ILSMComponent> mergedComponents) throws HyracksDataException {
        int swapIndex;
        List olderList;
        List<ILSMDiskComponent> newerList;
        if (this.version == 0) {
            newerList = this.diskComponents;
            olderList = this.secondDiskComponents;
        } else {
            newerList = this.secondDiskComponents;
            olderList = this.diskComponents;
        }
        if (olderList.containsAll(mergedComponents)) {
            swapIndex = olderList.indexOf(mergedComponents.get(0));
            olderList.removeAll(mergedComponents);
            olderList.add(swapIndex, newComponent);
        }
        swapIndex = newerList.indexOf(mergedComponents.get(0));
        newerList.removeAll(mergedComponents);
        newerList.add(swapIndex, newComponent);
    }

    public List<ILSMDiskComponent> getDiskComponents() {
        if (this.version == 0) {
            return this.diskComponents;
        }
        return this.secondDiskComponents;
    }

    public void deleteTransactionComponent() throws HyracksDataException {
        this.fileManager.deleteTransactionFiles();
    }

    public void addDiskComponent(ILSMDiskComponent c) throws HyracksDataException {
        if (this.version == 0) {
            this.diskComponents.add(0, c);
        } else if (this.version == 1) {
            this.secondDiskComponents.add(0, c);
        }
    }

    public void commitTransactionDiskComponent(ILSMDiskComponent newComponent) throws HyracksDataException {
        List olderList;
        List<ILSMDiskComponent> newerList;
        if (this.version == 0) {
            newerList = this.diskComponents;
            olderList = this.secondDiskComponents;
            this.version = 1;
        } else {
            newerList = this.secondDiskComponents;
            olderList = this.diskComponents;
            this.version = 0;
        }
        olderList.clear();
        olderList.addAll(newerList);
        if (newComponent != null) {
            olderList.add(0, newComponent);
        }
    }

    public synchronized void activate() throws HyracksDataException {
        if (this.isActive) {
            throw new HyracksDataException("Failed to activate the index since it is already activated.");
        }
        if (this.diskComponents.size() == 0 && this.secondDiskComponents.size() == 0) {
            List validFileReferences = this.fileManager.cleanupAndGetValidFiles();
            for (LSMComponentFileReferences lsmComonentFileReference : validFileReferences) {
                ILSMDiskComponent component = this.createDiskComponent(this.componentFactory, lsmComonentFileReference.getInsertIndexFileReference(), lsmComonentFileReference.getDeleteIndexFileReference(), lsmComonentFileReference.getBloomFilterFileReference(), false);
                this.diskComponents.add(component);
                this.secondDiskComponents.add(component);
            }
            this.getHarness().indexFirstTimeActivated();
        } else {
            LSMRTreeDiskComponent component;
            for (ILSMComponent iLSMComponent : this.diskComponents) {
                component = (LSMRTreeDiskComponent)iLSMComponent;
                component.activate(false);
            }
            for (ILSMComponent iLSMComponent : this.secondDiskComponents) {
                if (this.diskComponents.contains(iLSMComponent)) continue;
                component = (LSMRTreeDiskComponent)iLSMComponent;
                component.activate(false);
            }
        }
        this.isActive = true;
    }

    public synchronized void create() throws HyracksDataException {
        super.create();
        this.secondDiskComponents.clear();
    }

    @Override
    public void search(ILSMIndexOperationContext ictx, IIndexCursor cursor, ISearchPredicate pred) throws HyracksDataException {
        ExternalRTreeOpContext ctx = (ExternalRTreeOpContext)ictx;
        List operationalComponents = ictx.getComponentHolder();
        ctx.getInitialState().setOperationalComponents(operationalComponents);
        cursor.open((ICursorInitialState)ctx.getInitialState(), pred);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ILSMDiskComponent doMerge(ILSMIOOperation operation) throws HyracksDataException {
        LSMRTreeMergeOperation mergeOp = (LSMRTreeMergeOperation)operation;
        IIndexCursor cursor = mergeOp.getCursor();
        SearchPredicate rtreeSearchPred = new SearchPredicate(null, null);
        ILSMIndexOperationContext opCtx = ((LSMRTreeSortedCursor)cursor).getOpCtx();
        this.search(opCtx, cursor, (ISearchPredicate)rtreeSearchPred);
        LSMRTreeDiskComponent mergedComponent = (LSMRTreeDiskComponent)this.createDiskComponent(this.componentFactory, mergeOp.getTarget(), mergeOp.getBTreeTarget(), mergeOp.getBloomFilterTarget(), true);
        boolean keepDeleteTuples = false;
        if (this.version == 0) {
            keepDeleteTuples = mergeOp.getMergingComponents().get(mergeOp.getMergingComponents().size() - 1) != this.diskComponents.get(this.diskComponents.size() - 1);
        } else {
            boolean bl = keepDeleteTuples = mergeOp.getMergingComponents().get(mergeOp.getMergingComponents().size() - 1) != this.secondDiskComponents.get(this.secondDiskComponents.size() - 1);
        }
        if (keepDeleteTuples) {
            LSMRTreeDeletedKeysBTreeMergeCursor btreeCursor = new LSMRTreeDeletedKeysBTreeMergeCursor(opCtx);
            this.search(opCtx, (IIndexCursor)btreeCursor, (ISearchPredicate)rtreeSearchPred);
            BTree btree = mergedComponent.getBuddyIndex();
            IIndexBulkLoader btreeBulkLoader = btree.createBulkLoader(1.0f, true, 0L, false);
            long numElements = 0L;
            for (int i = 0; i < mergeOp.getMergingComponents().size(); ++i) {
                numElements += ((LSMRTreeDiskComponent)((Object)mergeOp.getMergingComponents().get(i))).getBloomFilter().getNumElements();
            }
            int maxBucketsPerElement = BloomCalculations.maxBucketsPerElement((long)numElements);
            BloomFilterSpecification bloomFilterSpec = BloomCalculations.computeBloomSpec((int)maxBucketsPerElement, (double)this.bloomFilterFalsePositiveRate);
            IIndexBulkLoader builder = mergedComponent.getBloomFilter().createBuilder(numElements, bloomFilterSpec.getNumHashes(), bloomFilterSpec.getNumBucketsPerElements());
            try {
                while (btreeCursor.hasNext()) {
                    btreeCursor.next();
                    ITupleReference tuple = btreeCursor.getTuple();
                    btreeBulkLoader.add(tuple);
                    builder.add(tuple);
                }
            }
            finally {
                btreeCursor.destroy();
                builder.end();
            }
            btreeBulkLoader.end();
        }
        IIndexBulkLoader bulkLoader = mergedComponent.getIndex().createBulkLoader(1.0f, false, 0L, false);
        try {
            while (cursor.hasNext()) {
                cursor.next();
                ITupleReference frameTuple = cursor.getTuple();
                bulkLoader.add(frameTuple);
            }
        }
        finally {
            cursor.destroy();
        }
        bulkLoader.end();
        return mergedComponent;
    }

    public void deactivate(boolean flushOnExit) throws HyracksDataException {
        if (!this.isActive) {
            throw new HyracksDataException("Failed to deactivate the index since it is already deactivated.");
        }
        for (ILSMDiskComponent c : this.diskComponents) {
            c.deactivateAndPurge();
        }
        for (ILSMDiskComponent c : this.secondDiskComponents) {
            if (this.diskComponents.contains(c)) continue;
            c.deactivateAndPurge();
        }
        this.isActive = false;
    }

    public void clear() throws HyracksDataException {
        if (!this.isActive) {
            throw new HyracksDataException("Failed to clear the index since it is not activated.");
        }
        this.getHarness().indexClear();
        for (ILSMDiskComponent c : this.diskComponents) {
            c.deactivateAndDestroy();
            this.secondDiskComponents.remove(c);
        }
        for (ILSMDiskComponent c : this.secondDiskComponents) {
            c.deactivateAndDestroy();
        }
        this.diskComponents.clear();
        this.secondDiskComponents.clear();
        this.version = 0;
    }

    public void destroy() throws HyracksDataException {
        if (this.isActive) {
            throw new HyracksDataException("Failed to destroy the index since it is activated.");
        }
        for (ILSMDiskComponent c : this.diskComponents) {
            c.destroy();
            this.secondDiskComponents.remove(c);
        }
        for (ILSMDiskComponent c : this.secondDiskComponents) {
            c.destroy();
        }
        this.diskComponents.clear();
        this.secondDiskComponents.clear();
        this.fileManager.deleteDirs();
        this.version = 0;
    }

    @Override
    public void modify(IIndexOperationContext ictx, ITupleReference tuple) throws HyracksDataException {
        throw new UnsupportedOperationException("tuple modify not supported in LSM-Disk-Only-RTree");
    }

    public ILSMIOOperation createFlushOperation(ILSMIndexOperationContext ctx) throws HyracksDataException {
        throw new UnsupportedOperationException("flush not supported in LSM-Disk-Only-RTree");
    }

    @Override
    public ILSMDiskComponent doFlush(ILSMIOOperation operation) throws HyracksDataException {
        throw new UnsupportedOperationException("flush not supported in LSM-Disk-Only-RTree");
    }

    public void getOperationalComponents(ILSMIndexOperationContext ctx) {
        List operationalComponents = ctx.getComponentHolder();
        List<ILSMDiskComponent> immutableComponents = this.version == 0 ? this.diskComponents : this.secondDiskComponents;
        ExternalRTreeOpContext opCtx = (ExternalRTreeOpContext)ctx;
        operationalComponents.clear();
        switch (ctx.getOperation()) {
            case SEARCH: {
                if (opCtx.getTargetIndexVersion() == 0) {
                    operationalComponents.addAll(this.diskComponents);
                    break;
                }
                operationalComponents.addAll(this.secondDiskComponents);
                break;
            }
            case MERGE: {
                operationalComponents.addAll(ctx.getComponentsToBeMerged());
                break;
            }
            case FULL_MERGE: {
                operationalComponents.addAll(immutableComponents);
                break;
            }
            case REPLICATE: {
                operationalComponents.addAll(ctx.getComponentsToBeReplicated());
                break;
            }
            case FLUSH: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Operation " + ctx.getOperation() + " not supported.");
            }
        }
    }

    public IIndexBulkLoader createBulkLoader(float fillLevel, boolean verifyInput, long numElementsHint, Map<String, Object> parameters) throws HyracksDataException {
        return new LSMTwoPCRTreeBulkLoader(fillLevel, verifyInput, 0L, false, parameters);
    }

    public IIndexBulkLoader createTransactionBulkLoader(float fillLevel, boolean verifyInput, long numElementsHint, Map<String, Object> parameters) throws HyracksDataException {
        return new LSMTwoPCRTreeBulkLoader(fillLevel, verifyInput, numElementsHint, true, parameters);
    }

    public ILSMIOOperation createMergeOperation(ILSMIndexOperationContext ctx) throws HyracksDataException {
        ExternalRTreeOpContext rctx = this.createOpContext((ISearchOperationCallback)NoOpOperationCallback.INSTANCE, -1);
        rctx.setOperation(IndexOperation.MERGE);
        List mergingComponents = ctx.getComponentHolder();
        LSMRTreeSortedCursor cursor = new LSMRTreeSortedCursor((ILSMIndexOperationContext)rctx, this.linearizer, this.buddyBTreeFields);
        LSMComponentFileReferences relMergeFileRefs = this.getMergeFileReferences((ILSMDiskComponent)mergingComponents.get(mergingComponents.size() - 1), (ILSMDiskComponent)mergingComponents.get(0));
        LSMRTreeAccessor accessor = new LSMRTreeAccessor((ILSMHarness)this.getHarness(), (ILSMIndexOperationContext)rctx, this.buddyBTreeFields);
        LSMRTreeMergeOperation mergeOp = new LSMRTreeMergeOperation((ILSMIndexAccessor)accessor, (IIndexCursor)cursor, relMergeFileRefs.getInsertIndexFileReference(), relMergeFileRefs.getDeleteIndexFileReference(), relMergeFileRefs.getBloomFilterFileReference(), this.ioOpCallback, this.fileManager.getBaseDir().getAbsolutePath());
        this.ioOpCallback.scheduled((ILSMIOOperation)mergeOp);
        return mergeOp;
    }

    public ILSMIndexAccessor createAccessor(ISearchOperationCallback searchCallback, int targetIndexVersion) throws HyracksDataException {
        return new LSMRTreeAccessor((ILSMHarness)this.getHarness(), (ILSMIndexOperationContext)this.createOpContext(searchCallback, targetIndexVersion), this.buddyBTreeFields);
    }

    public ExternalRTreeOpContext createOpContext(ISearchOperationCallback searchCallback, int targetVersion) {
        return new ExternalRTreeOpContext((ILSMIndex)this, this.rtreeCmpFactories, this.btreeCmpFactories, searchCallback, targetVersion, (ILSMHarness)this.getHarness(), this.comparatorFields, this.linearizerArray, this.rtreeLeafFrameFactory, this.rtreeInteriorFrameFactory, this.btreeLeafFrameFactory, this.tracer);
    }

    @Override
    public ILSMIndexAccessor createAccessor(IIndexAccessParameters iap) {
        return new LSMRTreeAccessor((ILSMHarness)this.getHarness(), (ILSMIndexOperationContext)this.createOpContext(iap.getSearchOperationCallback(), this.version), this.buddyBTreeFields);
    }

    public int getCurrentVersion() {
        return this.version;
    }

    public void setCurrentVersion(int version) {
        this.version = version;
    }

    public List<ILSMDiskComponent> getFirstComponentList() {
        return this.diskComponents;
    }

    public List<ILSMDiskComponent> getSecondComponentList() {
        return this.secondDiskComponents;
    }

    public void commitTransaction() throws HyracksDataException {
        LSMComponentFileReferences componentFileRefrences = this.fileManager.getTransactionFileReferenceForCommit();
        ILSMDiskComponent component = null;
        if (componentFileRefrences != null) {
            component = this.createDiskComponent(this.componentFactory, componentFileRefrences.getInsertIndexFileReference(), componentFileRefrences.getDeleteIndexFileReference(), componentFileRefrences.getBloomFilterFileReference(), false);
        }
        this.getHarness().addTransactionComponents(component);
    }

    public void abortTransaction() throws HyracksDataException {
        this.fileManager.deleteTransactionFiles();
    }

    public void recoverTransaction() throws HyracksDataException {
        this.fileManager.recoverTransaction();
    }

    @Override
    public int getFieldCount() {
        return this.fieldCount;
    }

    public class LSMTwoPCRTreeBulkLoader
    implements IIndexBulkLoader,
    ITwoPCIndexBulkLoader {
        private final ILSMDiskComponent component;
        private final boolean isTransaction;
        private final LoadOperation loadOp;
        private final ChainedLSMDiskComponentBulkLoader componentBulkLoader;

        public LSMTwoPCRTreeBulkLoader(float fillFactor, boolean verifyInput, long numElementsHint, boolean isTransaction, Map<String, Object> parameters) throws HyracksDataException {
            LSMComponentFileReferences componentFileRefs;
            this.isTransaction = isTransaction;
            if (isTransaction) {
                try {
                    componentFileRefs = ExternalRTree.this.fileManager.getNewTransactionFileReference();
                }
                catch (IOException e) {
                    throw HyracksDataException.create((Throwable)e);
                }
                this.component = ExternalRTree.this.createDiskComponent(ExternalRTree.this.componentFactory, componentFileRefs.getInsertIndexFileReference(), componentFileRefs.getDeleteIndexFileReference(), componentFileRefs.getBloomFilterFileReference(), true);
            } else {
                componentFileRefs = ExternalRTree.this.fileManager.getRelFlushFileReference();
                this.component = ExternalRTree.this.createDiskComponent(ExternalRTree.this.bulkLoadComponentFactory, componentFileRefs.getInsertIndexFileReference(), componentFileRefs.getDeleteIndexFileReference(), componentFileRefs.getBloomFilterFileReference(), true);
            }
            this.loadOp = new LoadOperation(componentFileRefs, ExternalRTree.this.ioOpCallback, ExternalRTree.this.getIndexIdentifier(), parameters);
            this.loadOp.setNewComponent(this.component);
            ExternalRTree.this.ioOpCallback.scheduled((ILSMIOOperation)this.loadOp);
            ExternalRTree.this.ioOpCallback.beforeOperation((ILSMIOOperation)this.loadOp);
            this.componentBulkLoader = this.component.createBulkLoader((ILSMIOOperation)this.loadOp, fillFactor, verifyInput, numElementsHint, false, true, false);
        }

        public void add(ITupleReference tuple) throws HyracksDataException {
            this.componentBulkLoader.add(tuple);
        }

        public void end() throws HyracksDataException {
            block7: {
                try {
                    ExternalRTree.this.ioOpCallback.afterOperation((ILSMIOOperation)this.loadOp);
                    this.componentBulkLoader.end();
                    if (this.component.getComponentSize() <= 0L) break block7;
                    if (this.isTransaction) {
                        try {
                            this.component.markAsValid(ExternalRTree.this.durable, (IPageWriteFailureCallback)this.loadOp);
                        }
                        finally {
                            ExternalRTree.this.ioOpCallback.afterFinalize((ILSMIOOperation)this.loadOp);
                        }
                        this.component.deactivate();
                        break block7;
                    }
                    ExternalRTree.this.ioOpCallback.afterFinalize((ILSMIOOperation)this.loadOp);
                    ExternalRTree.this.getHarness().addBulkLoadedComponent((ILSMIOOperation)this.loadOp);
                }
                finally {
                    ExternalRTree.this.ioOpCallback.completed((ILSMIOOperation)this.loadOp);
                }
            }
        }

        public void delete(ITupleReference tuple) throws HyracksDataException {
            this.componentBulkLoader.delete(tuple);
        }

        public void abort() throws HyracksDataException {
            try {
                try {
                    this.componentBulkLoader.abort();
                }
                finally {
                    ExternalRTree.this.ioOpCallback.afterFinalize((ILSMIOOperation)this.loadOp);
                }
            }
            finally {
                ExternalRTree.this.ioOpCallback.completed((ILSMIOOperation)this.loadOp);
            }
        }

        public void writeFailed(ICachedPage page, Throwable failure) {
            throw new UnsupportedOperationException();
        }

        public boolean hasFailed() {
            return this.loadOp.hasFailed();
        }

        public Throwable getFailure() {
            return this.loadOp.getFailure();
        }
    }
}

