/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.common.tuples;

import org.apache.hyracks.data.std.primitive.ShortPointable;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrame;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleReference;
import org.apache.hyracks.storage.am.common.util.BitOperationUtils;

public class SimpleTupleReference
implements ITreeIndexTupleReference {
    protected byte[] buf;
    protected int fieldStartIndex;
    protected int fieldCount;
    protected int tupleStartOff;
    protected int nullFlagsBytes;
    protected int fieldSlotsBytes;

    @Override
    public void resetByTupleOffset(byte[] buf, int tupleStartOff) {
        this.buf = buf;
        this.tupleStartOff = tupleStartOff;
    }

    @Override
    public void resetByTupleIndex(ITreeIndexFrame frame, int tupleIndex) {
        this.resetByTupleOffset(frame.getBuffer().array(), frame.getTupleOffset(tupleIndex));
    }

    @Override
    public void setFieldCount(int fieldCount) {
        this.fieldCount = fieldCount;
        this.nullFlagsBytes = this.getNullFlagsBytes();
        this.fieldSlotsBytes = this.getFieldSlotsBytes();
        this.fieldStartIndex = 0;
    }

    @Override
    public void setFieldCount(int fieldStartIndex, int fieldCount) {
        this.fieldCount = fieldCount;
        this.fieldStartIndex = fieldStartIndex;
    }

    public int getFieldCount() {
        return this.fieldCount;
    }

    public byte[] getFieldData(int fIdx) {
        return this.buf;
    }

    public int getFieldLength(int fIdx) {
        if (fIdx == 0) {
            return ShortPointable.getShort((byte[])this.buf, (int)(this.tupleStartOff + this.nullFlagsBytes));
        }
        return ShortPointable.getShort((byte[])this.buf, (int)(this.tupleStartOff + this.nullFlagsBytes + fIdx * 2)) - ShortPointable.getShort((byte[])this.buf, (int)(this.tupleStartOff + this.nullFlagsBytes + (fIdx - 1) * 2));
    }

    public int getFieldStart(int fIdx) {
        if (fIdx == 0) {
            return this.tupleStartOff + this.nullFlagsBytes + this.fieldSlotsBytes;
        }
        return this.tupleStartOff + this.nullFlagsBytes + this.fieldSlotsBytes + ShortPointable.getShort((byte[])this.buf, (int)(this.tupleStartOff + this.nullFlagsBytes + (fIdx - 1) * 2));
    }

    protected int getNullFlagsBytes() {
        return BitOperationUtils.getFlagBytes(this.fieldCount);
    }

    protected int getFieldSlotsBytes() {
        return this.fieldCount * 2;
    }

    @Override
    public int getTupleSize() {
        return this.nullFlagsBytes + this.fieldSlotsBytes + ShortPointable.getShort((byte[])this.buf, (int)(this.tupleStartOff + this.nullFlagsBytes + (this.fieldCount - 1) * 2));
    }
}

