/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.common.buffercache;

import org.apache.hyracks.storage.common.buffercache.BufferCache;
import org.apache.hyracks.storage.common.buffercache.CachedPage;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;
import org.apache.hyracks.storage.common.buffercache.IFIFOPageWriter;
import org.apache.hyracks.util.ExitUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FIFOLocalWriter
implements IFIFOPageWriter {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final FIFOLocalWriter INSTANCE = new FIFOLocalWriter();
    private static final boolean DEBUG = false;

    private FIFOLocalWriter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(ICachedPage page, BufferCache bufferCache) {
        CachedPage cPage = (CachedPage)page;
        try {
            bufferCache.write(cPage);
        }
        catch (Exception e) {
            page.writeFailed(e);
            LOGGER.warn("Failed to write page {}", (Object)cPage, (Object)e);
        }
        catch (Throwable th) {
            LOGGER.error("FIFOLocalWriter has encountered a fatal error", th);
            ExitUtil.halt((int)1);
        }
        finally {
            bufferCache.returnPage(cPage);
        }
    }
}

