/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnionAllOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class PushAssignBelowUnionAllRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (!op.hasInputs()) {
            return false;
        }
        boolean modified = false;
        for (int i = 0; i < op.getInputs().size(); ++i) {
            int j;
            AbstractLogicalOperator childOp = (AbstractLogicalOperator)((Mutable)op.getInputs().get(i)).getValue();
            if (childOp.getOperatorTag() != LogicalOperatorTag.ASSIGN) continue;
            AssignOperator assignOp = (AssignOperator)childOp;
            for (Mutable expr : assignOp.getExpressions()) {
                if (((ILogicalExpression)expr.getValue()).isFunctional()) continue;
                return false;
            }
            AbstractLogicalOperator childOfChildOp = (AbstractLogicalOperator)((Mutable)assignOp.getInputs().get(0)).getValue();
            if (childOfChildOp.getOperatorTag() != LogicalOperatorTag.UNIONALL) continue;
            UnionAllOperator unionOp = (UnionAllOperator)childOfChildOp;
            HashSet<LogicalVariable> assignUsedVars = new HashSet<LogicalVariable>();
            VariableUtilities.getUsedVariables((ILogicalOperator)assignOp, assignUsedVars);
            List assignVars = assignOp.getVariables();
            AssignOperator[] newAssignOps = new AssignOperator[2];
            for (j = 0; j < unionOp.getInputs().size(); ++j) {
                newAssignOps[j] = this.createAssignBelowUnionAllBranch(unionOp, j, assignOp, assignUsedVars, context);
            }
            for (j = 0; j < assignVars.size(); ++j) {
                LogicalVariable first = (LogicalVariable)newAssignOps[0].getVariables().get(j);
                LogicalVariable second = (LogicalVariable)newAssignOps[1].getVariables().get(j);
                Triple varMapping = new Triple((Object)first, (Object)second, assignVars.get(j));
                unionOp.getVariableMappings().add(varMapping);
            }
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)unionOp);
            op.getInputs().set(i, assignOp.getInputs().get(0));
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)op);
            modified = true;
        }
        return modified;
    }

    private AssignOperator createAssignBelowUnionAllBranch(UnionAllOperator unionOp, int inputIndex, AssignOperator originalAssignOp, Set<LogicalVariable> assignUsedVars, IOptimizationContext context) throws AlgebricksException {
        AssignOperator newAssignOp = this.cloneAssignOperator(originalAssignOp, context);
        newAssignOp.getInputs().add(new MutableObject(((Mutable)unionOp.getInputs().get(inputIndex)).getValue()));
        ((Mutable)unionOp.getInputs().get(inputIndex)).setValue((Object)newAssignOp);
        int numVarMappings = unionOp.getVariableMappings().size();
        for (int i = 0; i < numVarMappings; ++i) {
            Triple varMapping = (Triple)unionOp.getVariableMappings().get(i);
            if (!assignUsedVars.contains(varMapping.third)) continue;
            LogicalVariable replacementVar = inputIndex == 0 ? (LogicalVariable)varMapping.first : (LogicalVariable)varMapping.second;
            VariableUtilities.substituteVariables((ILogicalOperator)newAssignOp, (LogicalVariable)((LogicalVariable)varMapping.third), (LogicalVariable)replacementVar, (ITypingContext)context);
        }
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)newAssignOp);
        return newAssignOp;
    }

    private AssignOperator cloneAssignOperator(AssignOperator assignOp, IOptimizationContext context) {
        ArrayList<LogicalVariable> vars = new ArrayList<LogicalVariable>();
        ArrayList<MutableObject> exprs = new ArrayList<MutableObject>();
        int numVars = assignOp.getVariables().size();
        for (int i = 0; i < numVars; ++i) {
            vars.add(context.newVar());
            exprs.add(new MutableObject((Object)((ILogicalExpression)((Mutable)assignOp.getExpressions().get(i)).getValue()).cloneExpression()));
        }
        AssignOperator assignCloneOp = new AssignOperator(vars, exprs);
        assignCloneOp.setSourceLocation(assignOp.getSourceLocation());
        assignCloneOp.setExecutionMode(assignOp.getExecutionMode());
        return assignCloneOp;
    }
}

