/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractLogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.AlgebricksBuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionReferenceTransform;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class ExtractCommonExpressionsRule
implements IAlgebraicRewriteRule {
    private final List<ILogicalExpression> originalAssignExprs = new ArrayList<ILogicalExpression>();
    private final CommonExpressionSubstitutionVisitor substVisitor = new CommonExpressionSubstitutionVisitor();
    private final Map<ILogicalExpression, ExprEquivalenceClass> exprEqClassMap = new HashMap<ILogicalExpression, ExprEquivalenceClass>();
    private static final Set<LogicalOperatorTag> ignoreOps = new HashSet<LogicalOperatorTag>(6);

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        this.exprEqClassMap.clear();
        this.substVisitor.setContext(context);
        boolean modified = this.removeCommonExpressions(opRef, context);
        if (modified) {
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)opRef.getValue());
        }
        return modified;
    }

    private void updateEquivalenceClassMap(LogicalVariable lhs, Mutable<ILogicalExpression> rhsExprRef, ILogicalExpression rhsExpr, ILogicalOperator op) {
        ExprEquivalenceClass exprEqClass = this.exprEqClassMap.get(rhsExpr);
        if (exprEqClass == null) {
            exprEqClass = new ExprEquivalenceClass(op, rhsExprRef);
            this.exprEqClassMap.put(rhsExpr, exprEqClass);
        }
        exprEqClass.setVariable(lhs);
    }

    private boolean removeCommonExpressions(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        ILogicalExpression expr;
        Mutable exprRef;
        int i;
        AssignOperator assignOp;
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)opRef.getValue())) {
            return false;
        }
        boolean modified = false;
        for (Mutable inputOpRef : op.getInputs()) {
            if (!this.removeCommonExpressions((Mutable<ILogicalOperator>)inputOpRef, context)) continue;
            modified = true;
        }
        if (op.getOperatorTag() == LogicalOperatorTag.REPLICATE || op.getOperatorTag() == LogicalOperatorTag.SPLIT) {
            this.exprEqClassMap.clear();
            return modified;
        }
        if (ignoreOps.contains(op.getOperatorTag())) {
            return modified;
        }
        if (op.getOperatorTag() == LogicalOperatorTag.ASSIGN) {
            assignOp = (AssignOperator)op;
            this.originalAssignExprs.clear();
            int numVars = assignOp.getVariables().size();
            for (i = 0; i < numVars; ++i) {
                exprRef = (Mutable)assignOp.getExpressions().get(i);
                expr = (ILogicalExpression)exprRef.getValue();
                this.originalAssignExprs.add(expr.cloneExpression());
            }
        }
        this.substVisitor.setOperator((ILogicalOperator)op);
        if (op.acceptExpressionTransform((ILogicalExpressionReferenceTransform)this.substVisitor)) {
            modified = true;
        }
        if (op.getOperatorTag() == LogicalOperatorTag.ASSIGN) {
            assignOp = (AssignOperator)op;
            int numVars = assignOp.getVariables().size();
            for (i = 0; i < numVars; ++i) {
                exprRef = (Mutable)assignOp.getExpressions().get(i);
                expr = (ILogicalExpression)exprRef.getValue();
                if (expr.getExpressionTag() == LogicalExpressionTag.VARIABLE || expr.getExpressionTag() == LogicalExpressionTag.CONSTANT) continue;
                LogicalVariable lhs = (LogicalVariable)assignOp.getVariables().get(i);
                this.updateEquivalenceClassMap(lhs, (Mutable<ILogicalExpression>)exprRef, (ILogicalExpression)exprRef.getValue(), (ILogicalOperator)op);
                this.updateEquivalenceClassMap(lhs, (Mutable<ILogicalExpression>)exprRef, this.originalAssignExprs.get(i), (ILogicalOperator)op);
            }
        }
        if (modified) {
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)op);
            context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)op);
        }
        return modified;
    }

    private boolean containsExpr(ILogicalExpression expr, ILogicalExpression searchExpr) {
        if (expr == searchExpr) {
            return true;
        }
        if (expr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return false;
        }
        AbstractFunctionCallExpression funcExpr = (AbstractFunctionCallExpression)expr;
        for (Mutable argRef : funcExpr.getArguments()) {
            if (!this.containsExpr((ILogicalExpression)argRef.getValue(), searchExpr)) continue;
            return true;
        }
        return false;
    }

    private boolean isEqJoinCondition(ILogicalExpression expr) {
        AbstractFunctionCallExpression funcExpr = (AbstractFunctionCallExpression)expr;
        if (funcExpr.getFunctionIdentifier().equals((Object)AlgebricksBuiltinFunctions.EQ)) {
            ILogicalExpression arg1 = (ILogicalExpression)((Mutable)funcExpr.getArguments().get(0)).getValue();
            ILogicalExpression arg2 = (ILogicalExpression)((Mutable)funcExpr.getArguments().get(1)).getValue();
            if (arg1.getExpressionTag() == LogicalExpressionTag.VARIABLE && arg2.getExpressionTag() == LogicalExpressionTag.VARIABLE) {
                return true;
            }
        }
        return false;
    }

    static {
        ignoreOps.add(LogicalOperatorTag.UNNEST);
        ignoreOps.add(LogicalOperatorTag.UNNEST_MAP);
        ignoreOps.add(LogicalOperatorTag.ORDER);
        ignoreOps.add(LogicalOperatorTag.PROJECT);
        ignoreOps.add(LogicalOperatorTag.AGGREGATE);
        ignoreOps.add(LogicalOperatorTag.RUNNINGAGGREGATE);
    }

    private final class ExprEquivalenceClass {
        private final ILogicalOperator firstOp;
        private final Mutable<ILogicalExpression> firstExprRef;
        private LogicalVariable var;

        public ExprEquivalenceClass(ILogicalOperator firstOp, Mutable<ILogicalExpression> firstExprRef) {
            this.firstOp = firstOp;
            this.firstExprRef = firstExprRef;
        }

        public ILogicalOperator getFirstOperator() {
            return this.firstOp;
        }

        public Mutable<ILogicalExpression> getFirstExpression() {
            return this.firstExprRef;
        }

        public void setVariable(LogicalVariable var) {
            this.var = var;
        }

        public LogicalVariable getVariable() {
            return this.var;
        }

        public boolean variableIsSet() {
            return this.var != null;
        }
    }

    private class CommonExpressionSubstitutionVisitor
    implements ILogicalExpressionReferenceTransform {
        private IOptimizationContext context;
        private ILogicalOperator op;

        private CommonExpressionSubstitutionVisitor() {
        }

        public void setContext(IOptimizationContext context) {
            this.context = context;
        }

        public void setOperator(ILogicalOperator op) throws AlgebricksException {
            this.op = op;
        }

        public boolean transform(Mutable<ILogicalExpression> exprRef) throws AlgebricksException {
            AbstractLogicalExpression expr = (AbstractLogicalExpression)exprRef.getValue();
            boolean modified = false;
            ExprEquivalenceClass exprEqClass = (ExprEquivalenceClass)ExtractCommonExpressionsRule.this.exprEqClassMap.get(expr);
            if (exprEqClass != null) {
                HashSet liveVars;
                if (exprEqClass.variableIsSet()) {
                    if (expr.isFunctional()) {
                        liveVars = new HashSet();
                        ArrayList usedVars = new ArrayList();
                        VariableUtilities.getLiveVariables((ILogicalOperator)this.op, liveVars);
                        VariableUtilities.getUsedVariables((ILogicalOperator)this.op, usedVars);
                        if (liveVars.contains(exprEqClass.getVariable()) || !liveVars.containsAll(usedVars) || this.op == exprEqClass.getFirstOperator()) {
                            VariableReferenceExpression varRef = new VariableReferenceExpression(exprEqClass.getVariable());
                            varRef.setSourceLocation(expr.getSourceLocation());
                            exprRef.setValue((Object)varRef);
                            return true;
                        }
                    }
                } else if (expr.isFunctional() && this.assignCommonExpression(exprEqClass, (ILogicalExpression)expr)) {
                    liveVars = new HashSet();
                    VariableUtilities.getLiveVariables((ILogicalOperator)this.op, liveVars);
                    if (liveVars.contains(exprEqClass.getVariable())) {
                        VariableReferenceExpression varRef = new VariableReferenceExpression(exprEqClass.getVariable());
                        varRef.setSourceLocation(expr.getSourceLocation());
                        exprRef.setValue((Object)varRef);
                        return true;
                    }
                }
            } else if (expr.getExpressionTag() != LogicalExpressionTag.VARIABLE && expr.getExpressionTag() != LogicalExpressionTag.CONSTANT) {
                exprEqClass = new ExprEquivalenceClass(this.op, exprRef);
                ExtractCommonExpressionsRule.this.exprEqClassMap.put(expr, exprEqClass);
            }
            if (expr.getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL) {
                AbstractFunctionCallExpression funcExpr = (AbstractFunctionCallExpression)expr;
                for (Mutable arg : funcExpr.getArguments()) {
                    if (!this.transform((Mutable<ILogicalExpression>)arg)) continue;
                    modified = true;
                }
            }
            return modified;
        }

        private boolean assignCommonExpression(ExprEquivalenceClass exprEqClass, ILogicalExpression expr) throws AlgebricksException {
            SourceLocation sourceLoc = expr.getSourceLocation();
            AbstractLogicalOperator firstOp = (AbstractLogicalOperator)exprEqClass.getFirstOperator();
            Mutable<ILogicalExpression> firstExprRef = exprEqClass.getFirstExpression();
            if (firstOp.getInputs().size() > 1) {
                return false;
            }
            LogicalVariable newVar = this.context.newVar();
            AssignOperator newAssign = new AssignOperator(newVar, (Mutable)new MutableObject((Object)((ILogicalExpression)firstExprRef.getValue()).cloneExpression()));
            newAssign.setSourceLocation(sourceLoc);
            newAssign.getInputs().add(new MutableObject(((Mutable)firstOp.getInputs().get(0)).getValue()));
            newAssign.setExecutionMode(firstOp.getExecutionMode());
            ((Mutable)firstOp.getInputs().get(0)).setValue((Object)newAssign);
            VariableReferenceExpression newVarRef = new VariableReferenceExpression(newVar);
            newVarRef.setSourceLocation(sourceLoc);
            firstExprRef.setValue((Object)newVarRef);
            exprEqClass.setVariable(newVar);
            this.context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)newAssign);
            this.context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)firstOp);
            return true;
        }

        private ILogicalExpression getEnclosingExpression(Mutable<ILogicalExpression> conditionExprRef, ILogicalExpression commonSubExpr) {
            ILogicalExpression conditionExpr = (ILogicalExpression)conditionExprRef.getValue();
            if (conditionExpr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
                return null;
            }
            if (ExtractCommonExpressionsRule.this.isEqJoinCondition(commonSubExpr)) {
                return null;
            }
            AbstractFunctionCallExpression conditionFuncExpr = (AbstractFunctionCallExpression)conditionExpr;
            AbstractFunctionCallExpression enclosingBoolExpr = null;
            FunctionIdentifier funcIdent = conditionFuncExpr.getFunctionIdentifier();
            if (funcIdent.equals((Object)AlgebricksBuiltinFunctions.AND) || funcIdent.equals((Object)AlgebricksBuiltinFunctions.OR)) {
                Iterator argIter = conditionFuncExpr.getArguments().iterator();
                while (argIter.hasNext()) {
                    Mutable argRef = (Mutable)argIter.next();
                    if (!ExtractCommonExpressionsRule.this.containsExpr((ILogicalExpression)argRef.getValue(), commonSubExpr)) continue;
                    enclosingBoolExpr = (ILogicalExpression)argRef.getValue();
                    argIter.remove();
                    break;
                }
                if (conditionFuncExpr.getArguments().size() == 1) {
                    conditionExprRef.setValue(((Mutable)conditionFuncExpr.getArguments().get(0)).getValue());
                }
            } else {
                if (!ExtractCommonExpressionsRule.this.containsExpr((ILogicalExpression)conditionExprRef.getValue(), commonSubExpr)) {
                    return null;
                }
                enclosingBoolExpr = conditionFuncExpr;
                conditionExprRef.setValue((Object)ConstantExpression.TRUE);
            }
            return enclosingBoolExpr;
        }
    }
}

