/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.http.server;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hyracks.http.server.HttpServer;

public class WebManager {
    private final List<HttpServer> servers = new ArrayList<HttpServer>();
    private final EventLoopGroup bosses;
    private final EventLoopGroup workers;

    public WebManager() {
        this(1, 0);
    }

    public WebManager(int numWorkers) {
        this(1, numWorkers);
    }

    public WebManager(int numBosses, int numWorkers) {
        this.bosses = new NioEventLoopGroup(numBosses);
        this.workers = new NioEventLoopGroup(numWorkers);
    }

    public List<HttpServer> getServers() {
        return this.servers;
    }

    public EventLoopGroup getBosses() {
        return this.bosses;
    }

    public EventLoopGroup getWorkers() {
        return this.workers;
    }

    public void start() throws Exception {
        for (HttpServer server : this.servers) {
            server.start();
        }
    }

    public void stop() throws Exception {
        List<Exception> stopExceptions = Collections.synchronizedList(new ArrayList());
        this.servers.parallelStream().forEach(server -> {
            try {
                server.stop();
            }
            catch (Exception e) {
                stopExceptions.add(e);
            }
        });
        this.workers.shutdownGracefully().sync();
        this.bosses.shutdownGracefully().sync();
        if (!stopExceptions.isEmpty()) {
            Exception ex = null;
            for (Exception stopException : stopExceptions) {
                if (ex == null) {
                    ex = stopException;
                    continue;
                }
                ex.addSuppressed(stopException);
            }
            throw ex;
        }
    }

    public void add(HttpServer server) {
        this.servers.add(server);
    }
}

