/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.http.server;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.apache.hyracks.http.api.IServletResponse;
import org.apache.hyracks.http.server.ChunkedNettyOutputStream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChunkedResponse
implements IServletResponse {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ChannelHandlerContext ctx;
    private final ChunkedNettyOutputStream outputStream;
    private final PrintWriter writer;
    private HttpResponse response;
    private boolean headerSent;
    private ByteBuf error;
    private ChannelFuture future;
    private boolean done;
    private final boolean keepAlive;

    public ChunkedResponse(ChannelHandlerContext ctx, FullHttpRequest request, int chunkSize) {
        this.ctx = ctx;
        this.outputStream = new ChunkedNettyOutputStream(ctx, chunkSize, this);
        this.writer = new PrintWriter(this.outputStream);
        this.response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR);
        this.response.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        this.keepAlive = HttpUtil.isKeepAlive((HttpMessage)request);
        this.response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)(this.keepAlive ? HttpHeaderValues.KEEP_ALIVE : HttpHeaderValues.CLOSE));
    }

    @Override
    public IServletResponse setHeader(CharSequence name, Object value) throws IOException {
        if (this.headerSent) {
            throw new IOException("Can't add more headers since the initial response was sent");
        }
        this.response.headers().set(name, value);
        return this;
    }

    @Override
    public ChannelFuture lastContentFuture() {
        return this.future;
    }

    @Override
    public PrintWriter writer() {
        return this.writer;
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
        if (this.error == null && this.response.status() == HttpResponseStatus.OK) {
            if (!this.done) {
                this.future = this.ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
            }
        } else if (this.headerSent) {
            LOGGER.log(Level.WARN, "Error after header write of chunked response");
            if (this.error != null) {
                this.error.release();
            }
            this.future = this.ctx.channel().close();
        } else {
            this.fullResponse(this.response.protocolVersion(), this.response.status(), this.error == null ? this.ctx.alloc().buffer(0, 0) : this.error, this.response.headers());
        }
        this.done = true;
    }

    public HttpResponseStatus status() {
        return this.response.status();
    }

    public void beforeFlush() {
        if (!this.headerSent && this.response.status() == HttpResponseStatus.OK) {
            this.ctx.write((Object)this.response, this.ctx.channel().voidPromise());
            this.headerSent = true;
        }
    }

    public void error(ByteBuf error) {
        if (this.error == null) {
            this.error = error;
        } else {
            this.error.capacity(this.error.capacity() + error.capacity());
            this.error.writeBytes(error);
        }
    }

    @Override
    public OutputStream outputStream() {
        return this.outputStream;
    }

    @Override
    public void setStatus(HttpResponseStatus status) {
        this.response.setStatus(status);
    }

    public boolean isHeaderSent() {
        return this.headerSent;
    }

    public void fullReponse(ByteBuf buffer) {
        this.fullResponse(this.response.protocolVersion(), this.response.status(), buffer, this.response.headers());
    }

    private void fullResponse(HttpVersion version, HttpResponseStatus status, ByteBuf buffer, HttpHeaders headers) {
        DefaultFullHttpResponse fullResponse = new DefaultFullHttpResponse(version, status, buffer);
        fullResponse.headers().set(headers);
        fullResponse.headers().remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
        fullResponse.headers().setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, buffer.readableBytes());
        this.future = this.ctx.writeAndFlush((Object)fullResponse);
        this.headerSent = true;
        this.done = true;
    }

    @Override
    public void notifyChannelWritable() {
        this.outputStream.channelWritabilityChanged();
    }

    @Override
    public void notifyChannelInactive() {
        this.outputStream.channelWritabilityChanged();
    }

    @Override
    public void cancel() {
        this.outputStream.cancel();
    }
}

