/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import java.util.List;
import java.util.Map;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.common.impls.IndexAccessParameters;
import org.apache.hyracks.storage.am.common.impls.NoOpIndexAccessParameters;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicy;
import org.apache.hyracks.storage.common.IIndexAccessParameters;
import org.apache.hyracks.storage.common.IModificationOperationCallback;
import org.apache.hyracks.storage.common.ISearchOperationCallback;

public class ConstantMergePolicy
implements ILSMMergePolicy {
    private int numComponents;

    @Override
    public void diskComponentAdded(ILSMIndex index, boolean fullMergeIsRequested) throws HyracksDataException {
        List<ILSMDiskComponent> immutableComponents = index.getDiskComponents();
        if (!this.areComponentsMergable(immutableComponents)) {
            return;
        }
        if (fullMergeIsRequested) {
            IndexAccessParameters iap = new IndexAccessParameters((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
            ILSMIndexAccessor accessor = index.createAccessor((IIndexAccessParameters)iap);
            accessor.scheduleFullMerge();
        } else if (immutableComponents.size() >= this.numComponents) {
            ILSMIndexAccessor accessor = index.createAccessor((IIndexAccessParameters)NoOpIndexAccessParameters.INSTANCE);
            accessor.scheduleMerge(immutableComponents);
        }
    }

    @Override
    public void configure(Map<String, String> properties) {
        this.numComponents = Integer.parseInt(properties.get("num-components"));
    }

    @Override
    public boolean isMergeLagging(ILSMIndex index) throws HyracksDataException {
        List<ILSMDiskComponent> immutableComponents = index.getDiskComponents();
        int totalImmutableComponentCount = immutableComponents.size();
        if (totalImmutableComponentCount < this.numComponents) {
            return false;
        }
        boolean isMergeOngoing = this.isMergeOngoing(immutableComponents);
        if (isMergeOngoing) {
            return true;
        }
        if (!this.areComponentsMergable(immutableComponents)) {
            throw new IllegalStateException();
        }
        ILSMIndexAccessor accessor = index.createAccessor((IIndexAccessParameters)NoOpIndexAccessParameters.INSTANCE);
        accessor.scheduleMerge(immutableComponents);
        return true;
    }

    private boolean areComponentsMergable(List<ILSMDiskComponent> immutableComponents) {
        for (ILSMComponent iLSMComponent : immutableComponents) {
            if (iLSMComponent.getState() == ILSMComponent.ComponentState.READABLE_UNWRITABLE) continue;
            return false;
        }
        return true;
    }

    private boolean isMergeOngoing(List<ILSMDiskComponent> immutableComponents) {
        int size = immutableComponents.size();
        for (int i = 0; i < size; ++i) {
            if (immutableComponents.get(i).getState() != ILSMComponent.ComponentState.READABLE_MERGING) continue;
            return true;
        }
        return false;
    }
}

