/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.data.std.primitive;

import com.fasterxml.jackson.databind.JsonNode;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IJsonSerializable;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;
import org.apache.hyracks.data.std.api.AbstractPointable;
import org.apache.hyracks.data.std.api.IComparable;
import org.apache.hyracks.data.std.api.IHashable;
import org.apache.hyracks.data.std.api.INumeric;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IPointableFactory;
import org.apache.hyracks.data.std.primitive.FixedLengthTypeTrait;
import org.apache.hyracks.data.std.primitive.IntegerPointable;

public final class FloatPointable
extends AbstractPointable
implements IHashable,
IComparable,
INumeric {
    public static final ITypeTraits TYPE_TRAITS = new FixedLengthTypeTrait(4);
    public static final FloatPointableFactory FACTORY = new FloatPointableFactory();

    private static int getIntBits(byte[] bytes, int start) {
        return IntegerPointable.getInteger(bytes, start);
    }

    public static float getFloat(byte[] bytes, int start) {
        int bits = FloatPointable.getIntBits(bytes, start);
        return Float.intBitsToFloat(bits);
    }

    public static void setFloat(byte[] bytes, int start, float value) {
        int bits = Float.floatToIntBits(value);
        IntegerPointable.setInteger(bytes, start, bits);
    }

    public float getFloat() {
        return FloatPointable.getFloat(this.bytes, this.start);
    }

    public void setFloat(float value) {
        FloatPointable.setFloat(this.bytes, this.start, value);
    }

    public float preIncrement() {
        float v = this.getFloat();
        this.setFloat(v += 1.0f);
        return v;
    }

    public float postIncrement() {
        float v;
        float f = v = this.getFloat();
        v = f + 1.0f;
        float ov = f;
        this.setFloat(v);
        return ov;
    }

    @Override
    public int compareTo(IPointable pointer) {
        return this.compareTo(pointer.getByteArray(), pointer.getStartOffset(), pointer.getLength());
    }

    @Override
    public int compareTo(byte[] bytes, int start, int length) {
        float ov;
        float v = this.getFloat();
        return v < (ov = FloatPointable.getFloat(bytes, start)) ? -1 : (v > ov ? 1 : 0);
    }

    @Override
    public int hash() {
        return FloatPointable.getIntBits(this.bytes, this.start);
    }

    @Override
    public byte byteValue() {
        return (byte)this.getFloat();
    }

    @Override
    public short shortValue() {
        return (short)this.getFloat();
    }

    @Override
    public int intValue() {
        return (int)this.getFloat();
    }

    @Override
    public long longValue() {
        return (long)this.getFloat();
    }

    @Override
    public float floatValue() {
        return this.getFloat();
    }

    @Override
    public double doubleValue() {
        return this.getFloat();
    }

    public static final class FloatPointableFactory
    implements IPointableFactory {
        private static final long serialVersionUID = 1L;

        @Override
        public IPointable createPointable() {
            return new FloatPointable();
        }

        @Override
        public ITypeTraits getTypeTraits() {
            return TYPE_TRAITS;
        }

        public JsonNode toJson(IPersistedResourceRegistry registry) throws HyracksDataException {
            return registry.getClassIdentifier(this.getClass(), 1L);
        }

        public static IJsonSerializable fromJson(IPersistedResourceRegistry registry, JsonNode json) {
            return FACTORY;
        }
    }
}

