/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.data.std.primitive;

import com.fasterxml.jackson.databind.JsonNode;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IJsonSerializable;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;
import org.apache.hyracks.data.std.api.AbstractPointable;
import org.apache.hyracks.data.std.api.IComparable;
import org.apache.hyracks.data.std.api.IHashable;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IPointableFactory;
import org.apache.hyracks.data.std.primitive.FixedLengthTypeTrait;

public final class BooleanPointable
extends AbstractPointable
implements IHashable,
IComparable {
    public static final BooleanPointableFactory FACTORY = new BooleanPointableFactory();
    public static final ITypeTraits TYPE_TRAITS = new FixedLengthTypeTrait(1);

    public static boolean getBoolean(byte[] bytes, int start) {
        return bytes[start] != 0;
    }

    public static void setBoolean(byte[] bytes, int start, boolean value) {
        bytes[start] = (byte)(value ? 1 : 0);
    }

    public boolean getBoolean() {
        return BooleanPointable.getBoolean(this.bytes, this.start);
    }

    public void setBoolean(boolean value) {
        if (this.bytes == null) {
            this.start = 0;
            this.length = TYPE_TRAITS.getFixedLength();
            this.bytes = new byte[this.length];
        }
        BooleanPointable.setBoolean(this.bytes, this.start, value);
    }

    @Override
    public int compareTo(IPointable pointer) {
        return this.compareTo(pointer.getByteArray(), pointer.getStartOffset(), pointer.getLength());
    }

    @Override
    public int compareTo(byte[] bytes, int start, int length) {
        boolean ob;
        boolean b = this.getBoolean();
        return b == (ob = BooleanPointable.getBoolean(bytes, start)) ? 0 : (b ? 1 : -1);
    }

    @Override
    public int hash() {
        return this.getBoolean() ? Boolean.TRUE.hashCode() : Boolean.FALSE.hashCode();
    }

    public static class BooleanPointableFactory
    implements IPointableFactory {
        private static final long serialVersionUID = 1L;

        @Override
        public BooleanPointable createPointable() {
            return new BooleanPointable();
        }

        public BooleanPointable createPointable(boolean value) {
            BooleanPointable pointable = new BooleanPointable();
            pointable.setBoolean(value);
            return pointable;
        }

        @Override
        public ITypeTraits getTypeTraits() {
            return TYPE_TRAITS;
        }

        public JsonNode toJson(IPersistedResourceRegistry registry) throws HyracksDataException {
            return registry.getClassIdentifier(this.getClass(), 1L);
        }

        public static IJsonSerializable fromJson(IPersistedResourceRegistry registry, JsonNode json) {
            return FACTORY;
        }
    }
}

