/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.storage;

import java.nio.file.Paths;
import org.apache.asterix.common.dataflow.DatasetLocalResource;
import org.apache.asterix.common.storage.ResourceReference;
import org.apache.hyracks.storage.common.LocalResource;

public class DatasetResourceReference
extends ResourceReference {
    private int datasetId;
    private int partitionId;
    private long resourceId;

    private DatasetResourceReference() {
    }

    public static DatasetResourceReference of(LocalResource localResource) {
        return DatasetResourceReference.parse(localResource);
    }

    public int getDatasetId() {
        return this.datasetId;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public long getResourceId() {
        return this.resourceId;
    }

    private static DatasetResourceReference parse(LocalResource localResource) {
        DatasetResourceReference datasetResourceReference = new DatasetResourceReference();
        String filePath = Paths.get(localResource.getPath(), ".metadata").toString();
        DatasetResourceReference.parse(datasetResourceReference, filePath);
        DatasetResourceReference.assignIds(localResource, datasetResourceReference);
        return datasetResourceReference;
    }

    private static void assignIds(LocalResource localResource, DatasetResourceReference lrr) {
        DatasetLocalResource dsResource = (DatasetLocalResource)localResource.getResource();
        lrr.datasetId = dsResource.getDatasetId();
        lrr.partitionId = dsResource.getPartition();
        lrr.resourceId = localResource.getId();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ResourceReference) {
            ResourceReference that = (ResourceReference)o;
            return this.getRelativePath().toString().equals(that.getRelativePath().toString());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getRelativePath().toString().hashCode();
    }

    @Override
    public String toString() {
        return this.getRelativePath().toString();
    }
}

