/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.asterix.common.context.BaseOperationTracker;
import org.apache.asterix.common.context.DatasetInfo;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.metadata.MetadataIndexImmutableProperties;
import org.apache.asterix.common.transactions.AbstractOperationCallback;
import org.apache.asterix.common.transactions.ILogManager;
import org.apache.asterix.common.transactions.LogRecord;
import org.apache.asterix.common.utils.TransactionUtil;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.common.impls.NoOpIndexAccessParameters;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentId;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentIdGenerator;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMemoryComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTracker;
import org.apache.hyracks.storage.am.lsm.common.api.IoOperationCompleteListener;
import org.apache.hyracks.storage.am.lsm.common.api.LSMOperationType;
import org.apache.hyracks.storage.am.lsm.common.impls.FlushOperation;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentId;
import org.apache.hyracks.storage.common.IIndexAccessParameters;
import org.apache.hyracks.storage.common.IModificationOperationCallback;
import org.apache.hyracks.storage.common.ISearchOperationCallback;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PrimaryIndexOperationTracker
extends BaseOperationTracker
implements IoOperationCompleteListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private final int partition;
    private final AtomicInteger numActiveOperations;
    private final ILogManager logManager;
    private final ILSMComponentIdGenerator idGenerator;
    private boolean flushOnExit = false;
    private boolean flushLogCreated = false;
    private final Map<String, FlushOperation> scheduledFlushes = new HashMap<String, FlushOperation>();

    public PrimaryIndexOperationTracker(int datasetID, int partition, ILogManager logManager, DatasetInfo dsInfo, ILSMComponentIdGenerator idGenerator) {
        super(datasetID, dsInfo);
        this.partition = partition;
        this.logManager = logManager;
        this.numActiveOperations = new AtomicInteger();
        this.idGenerator = idGenerator;
    }

    @Override
    public void beforeOperation(ILSMIndex index, LSMOperationType opType, ISearchOperationCallback searchCallback, IModificationOperationCallback modificationCallback) throws HyracksDataException {
        super.beforeOperation(index, opType, searchCallback, modificationCallback);
        if (opType == LSMOperationType.MODIFICATION || opType == LSMOperationType.FORCE_MODIFICATION) {
            this.incrementNumActiveOperations(modificationCallback);
        }
    }

    @Override
    public synchronized void completeOperation(ILSMIndex index, LSMOperationType opType, ISearchOperationCallback searchCallback, IModificationOperationCallback modificationCallback) throws HyracksDataException {
        super.completeOperation(index, opType, searchCallback, modificationCallback);
        if (opType == LSMOperationType.MODIFICATION || opType == LSMOperationType.FORCE_MODIFICATION) {
            this.decrementNumActiveOperations(modificationCallback);
            this.flushIfNeeded();
        }
    }

    public synchronized void flushIfNeeded() throws HyracksDataException {
        if (this.canSafelyFlush()) {
            this.flushIfRequested();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushIfRequested() throws HyracksDataException {
        boolean needsFlush = false;
        Set<ILSMIndex> indexes = this.dsInfo.getDatasetPartitionOpenIndexes(this.partition);
        if (!this.flushOnExit) {
            for (ILSMIndex lsmIndex : indexes) {
                if (!lsmIndex.hasFlushRequestForCurrentMutableComponent()) continue;
                needsFlush = true;
                break;
            }
        }
        ILSMIndex primaryLsmIndex = null;
        if (needsFlush || this.flushOnExit) {
            this.flushOnExit = false;
            LSMComponentId primaryId = null;
            PrimaryIndexOperationTracker primaryIndexOperationTracker = this;
            synchronized (primaryIndexOperationTracker) {
                if (this.numActiveOperations.get() > 0) {
                    throw new IllegalStateException("Can't request a flush on an index with active operations: " + this.numActiveOperations.get());
                }
                for (ILSMIndex lsmIndex : indexes) {
                    if (!lsmIndex.isPrimaryIndex()) continue;
                    if (lsmIndex.isCurrentMutableComponentEmpty()) {
                        LOGGER.info("Primary index on dataset {} and partition {} is empty... skipping flush", (Object)this.dsInfo.getDatasetID(), (Object)this.partition);
                        return;
                    }
                    primaryLsmIndex = lsmIndex;
                    break;
                }
            }
            if (primaryLsmIndex == null) {
                throw new IllegalStateException("Primary index not found in dataset " + this.dsInfo.getDatasetID() + " and partition " + this.partition);
            }
            for (ILSMIndex lsmIndex : indexes) {
                ILSMOperationTracker opTracker;
                ILSMOperationTracker iLSMOperationTracker = opTracker = lsmIndex.getOperationTracker();
                synchronized (iLSMOperationTracker) {
                    ILSMMemoryComponent memComponent = lsmIndex.getCurrentMemoryComponent();
                    if (memComponent.getWriterCount() > 0) {
                        throw new IllegalStateException("Can't request a flush on a component with writers inside: Index:" + lsmIndex + " Component:" + memComponent);
                    }
                    if (memComponent.getState() == ILSMComponent.ComponentState.READABLE_WRITABLE && memComponent.isModified()) {
                        memComponent.setUnwritable();
                    }
                    if (lsmIndex.isPrimaryIndex()) {
                        primaryId = (LSMComponentId)memComponent.getId();
                    }
                }
            }
            if (primaryId == null) {
                throw new IllegalStateException("Primary index found in dataset " + this.dsInfo.getDatasetID() + " and partition " + this.partition + " and is modified but its component id is null");
            }
            LogRecord logRecord = new LogRecord();
            if (this.dsInfo.isDurable()) {
                TransactionUtil.formFlushLogRecord(logRecord, this.datasetID, this.partition, primaryId.getMinId(), primaryId.getMaxId(), this);
                try {
                    this.logManager.log(logRecord);
                }
                catch (ACIDException e) {
                    throw new IllegalStateException("could not write flush log", e);
                }
                this.flushLogCreated = true;
            } else {
                this.triggerScheduleFlush(logRecord);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void triggerScheduleFlush(LogRecord logRecord) throws HyracksDataException {
        try {
            if (!this.canSafelyFlush()) {
                if (MetadataIndexImmutableProperties.isMetadataDataset(this.datasetID)) {
                    return;
                }
                throw new IllegalStateException("Operation started while index was pending scheduling a flush");
            }
            this.idGenerator.refresh();
            long flushLsn = logRecord.getLSN();
            ILSMComponentId nextComponentId = this.idGenerator.getId();
            HashMap<String, Long> flushMap = new HashMap<String, Long>();
            flushMap.put("FlushLogLsn", flushLsn);
            flushMap.put("NextComponentId", (Long)nextComponentId);
            Map<String, FlushOperation> map = this.scheduledFlushes;
            synchronized (map) {
                for (ILSMIndex lsmIndex : this.dsInfo.getDatasetPartitionOpenIndexes(this.partition)) {
                    ILSMIndexAccessor accessor = lsmIndex.createAccessor((IIndexAccessParameters)NoOpIndexAccessParameters.INSTANCE);
                    accessor.getOpContext().setParameters(flushMap);
                    ILSMIOOperation flush = accessor.scheduleFlush();
                    this.scheduledFlushes.put(flush.getTarget().getRelativePath(), (FlushOperation)flush);
                    flush.addCompleteListener((IoOperationCompleteListener)this);
                }
            }
        }
        finally {
            this.flushLogCreated = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completed(ILSMIOOperation operation) {
        Map<String, FlushOperation> map = this.scheduledFlushes;
        synchronized (map) {
            this.scheduledFlushes.remove(operation.getTarget().getRelativePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FlushOperation> getScheduledFlushes() {
        Map<String, FlushOperation> map = this.scheduledFlushes;
        synchronized (map) {
            Collection<FlushOperation> scheduled = this.scheduledFlushes.values();
            ArrayList<FlushOperation> flushes = new ArrayList<FlushOperation>(scheduled.size());
            flushes.addAll(scheduled);
            return flushes;
        }
    }

    public int getNumActiveOperations() {
        return this.numActiveOperations.get();
    }

    private void incrementNumActiveOperations(IModificationOperationCallback modificationCallback) {
        if (modificationCallback != NoOpOperationCallback.INSTANCE) {
            this.numActiveOperations.incrementAndGet();
            ((AbstractOperationCallback)modificationCallback).beforeOperation();
        }
    }

    private void decrementNumActiveOperations(IModificationOperationCallback modificationCallback) {
        if (modificationCallback != NoOpOperationCallback.INSTANCE) {
            if (this.numActiveOperations.decrementAndGet() < 0) {
                throw new IllegalStateException("The number of active operations cannot be negative!");
            }
            ((AbstractOperationCallback)modificationCallback).afterOperation();
        }
    }

    public boolean isFlushOnExit() {
        return this.flushOnExit;
    }

    public void setFlushOnExit(boolean flushOnExit) {
        this.flushOnExit = flushOnExit;
    }

    public boolean isFlushLogCreated() {
        return this.flushLogCreated;
    }

    public int getPartition() {
        return this.partition;
    }

    private boolean canSafelyFlush() {
        return this.numActiveOperations.get() == 0;
    }
}

