/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.config;

import java.util.Map;
import org.apache.asterix.common.config.AbstractProperties;
import org.apache.asterix.common.config.PropertiesAccessor;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.api.config.IOptionType;
import org.apache.hyracks.api.config.Section;
import org.apache.hyracks.control.common.config.OptionTypes;
import org.apache.hyracks.util.StorageUtil;

public class TransactionProperties
extends AbstractProperties {
    public static final String TXN_LOG_PARTITIONSIZE_KEY = Option.TXN_LOG_PARTITIONSIZE.ini();
    public static final String TXN_LOG_CHECKPOINT_POLLFREQUENCY_KEY = Option.TXN_LOG_CHECKPOINT_POLLFREQUENCY.ini();

    public TransactionProperties(PropertiesAccessor accessor) {
        super(accessor);
    }

    public String getLogDirectory(String nodeId) {
        return this.accessor.getTransactionLogDirs().get(nodeId);
    }

    public Map<String, String> getLogDirectories() {
        return this.accessor.getTransactionLogDirs();
    }

    public int getLogBufferNumPages() {
        return this.accessor.getInt(Option.TXN_LOG_BUFFER_NUMPAGES);
    }

    public int getLogBufferPageSize() {
        return this.accessor.getInt(Option.TXN_LOG_BUFFER_PAGESIZE);
    }

    public long getLogPartitionSize() {
        return this.accessor.getLong(Option.TXN_LOG_PARTITIONSIZE);
    }

    public int getCheckpointLSNThreshold() {
        return this.accessor.getInt(Option.TXN_LOG_CHECKPOINT_LSNTHRESHOLD);
    }

    public int getCheckpointPollFrequency() {
        return this.accessor.getInt(Option.TXN_LOG_CHECKPOINT_POLLFREQUENCY);
    }

    public int getCheckpointHistory() {
        return this.accessor.getInt(Option.TXN_LOG_CHECKPOINT_HISTORY);
    }

    public int getEntityToDatasetLockEscalationThreshold() {
        return this.accessor.getInt(Option.TXN_LOCK_ESCALATIONTHRESHOLD);
    }

    public int getLockManagerShrinkTimer() {
        return this.accessor.getInt(Option.TXN_LOCK_SHRINKTIMER);
    }

    public int getTimeoutWaitThreshold() {
        return this.accessor.getInt(Option.TXN_LOCK_TIMEOUT_WAITTHRESHOLD);
    }

    public int getTimeoutSweepThreshold() {
        return this.accessor.getInt(Option.TXN_LOCK_TIMEOUT_SWEEPTHRESHOLD);
    }

    public boolean isCommitProfilerEnabled() {
        return this.accessor.getBoolean(Option.TXN_COMMITPROFILER_ENABLED);
    }

    public int getCommitProfilerReportInterval() {
        return this.accessor.getInt(Option.TXN_COMMITPROFILER_REPORTINTERVAL);
    }

    public long getJobRecoveryMemorySize() {
        return this.accessor.getLong(Option.TXN_JOB_RECOVERY_MEMORYSIZE);
    }

    public static enum Option implements IOption
    {
        TXN_LOG_BUFFER_NUMPAGES(OptionTypes.INTEGER, 8, "The number of pages in the transaction log tail"),
        TXN_LOG_BUFFER_PAGESIZE(OptionTypes.INTEGER_BYTE_UNIT, StorageUtil.getIntSizeInBytes((int)4, (StorageUtil.StorageUnit)StorageUtil.StorageUnit.MEGABYTE), "The page size (in bytes) for transaction log buffer"),
        TXN_LOG_PARTITIONSIZE(OptionTypes.LONG_BYTE_UNIT, StorageUtil.getLongSizeInBytes((long)256L, (StorageUtil.StorageUnit)StorageUtil.StorageUnit.MEGABYTE), "The maximum size (in bytes) of each transaction log file"),
        TXN_LOG_CHECKPOINT_LSNTHRESHOLD(OptionTypes.INTEGER_BYTE_UNIT, StorageUtil.getIntSizeInBytes((int)64, (StorageUtil.StorageUnit)StorageUtil.StorageUnit.MEGABYTE), "The checkpoint threshold (in terms of LSNs (log sequence numbers) that have been written to the transaction log, i.e., the length of the transaction log) for transaction logs"),
        TXN_LOG_CHECKPOINT_POLLFREQUENCY(OptionTypes.INTEGER, 120, "The frequency (in seconds) the checkpoint thread should check to see if a checkpoint should be written"),
        TXN_LOG_CHECKPOINT_HISTORY(OptionTypes.INTEGER, 0, "The number of checkpoints to keep in the transaction log"),
        TXN_LOCK_ESCALATIONTHRESHOLD(OptionTypes.INTEGER, 1000, "The maximum number of entity locks to obtain before upgrading to a dataset lock"),
        TXN_LOCK_SHRINKTIMER(OptionTypes.INTEGER, 5000, "The time (in milliseconds) where under utilization of resources will trigger a shrink phase"),
        TXN_LOCK_TIMEOUT_WAITTHRESHOLD(OptionTypes.INTEGER, 60000, "Time out (in milliseconds) of waiting for a lock"),
        TXN_LOCK_TIMEOUT_SWEEPTHRESHOLD(OptionTypes.INTEGER, 10000, "Interval (in milliseconds) for checking lock timeout"),
        TXN_COMMITPROFILER_ENABLED(OptionTypes.BOOLEAN, false, "Enable output of commit profiler logs"),
        TXN_COMMITPROFILER_REPORTINTERVAL(OptionTypes.INTEGER, 5, "Interval (in seconds) to report commit profiler logs"),
        TXN_JOB_RECOVERY_MEMORYSIZE(OptionTypes.LONG_BYTE_UNIT, StorageUtil.getLongSizeInBytes((long)64L, (StorageUtil.StorageUnit)StorageUtil.StorageUnit.MEGABYTE), "The memory budget (in bytes) used for recovery");

        private final IOptionType type;
        private final Object defaultValue;
        private final String description;

        private Option(IOptionType type, Object defaultValue, String description) {
            this.type = type;
            this.defaultValue = defaultValue;
            this.description = description;
        }

        public Section section() {
            return Section.COMMON;
        }

        public String description() {
            return this.description;
        }

        public IOptionType type() {
            return this.type;
        }

        public Object defaultValue() {
            return this.defaultValue;
        }
    }
}

