/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.config;

import java.util.function.Function;
import org.apache.asterix.common.config.AbstractProperties;
import org.apache.asterix.common.config.PropertiesAccessor;
import org.apache.hyracks.api.config.IApplicationConfig;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.api.config.IOptionType;
import org.apache.hyracks.api.config.Section;
import org.apache.hyracks.control.common.config.OptionTypes;
import org.apache.hyracks.util.StorageUtil;

public class StorageProperties
extends AbstractProperties {
    private static final int SYSTEM_RESERVED_DATASETS = 0;

    public StorageProperties(PropertiesAccessor accessor) {
        super(accessor);
    }

    public int getBufferCachePageSize() {
        return this.accessor.getInt(Option.STORAGE_BUFFERCACHE_PAGESIZE);
    }

    public long getBufferCacheSize() {
        return this.accessor.getLong(Option.STORAGE_BUFFERCACHE_SIZE);
    }

    public int getBufferCacheMaxOpenFiles() {
        return this.accessor.getInt(Option.STORAGE_BUFFERCACHE_MAXOPENFILES);
    }

    public int getMemoryComponentPageSize() {
        return this.accessor.getInt(Option.STORAGE_MEMORYCOMPONENT_PAGESIZE);
    }

    public int getMemoryComponentNumPages() {
        long metadataReservedMem = this.getMetadataReservedMemory();
        long globalUserDatasetMem = this.getMemoryComponentGlobalBudget() - metadataReservedMem;
        long userDatasetMem = globalUserDatasetMem / (long)(this.getMaxActiveWritableDatasets() + this.geSystemReservedDatasets());
        return (int)(userDatasetMem / (long)this.getMemoryComponentPageSize());
    }

    public int getMetadataMemoryComponentNumPages() {
        return this.accessor.getInt(Option.STORAGE_METADATA_MEMORYCOMPONENT_NUMPAGES);
    }

    public int getMemoryComponentsNum() {
        return this.accessor.getInt(Option.STORAGE_MEMORYCOMPONENT_NUMCOMPONENTS);
    }

    public long getMemoryComponentGlobalBudget() {
        return this.accessor.getLong(Option.STORAGE_MEMORYCOMPONENT_GLOBALBUDGET);
    }

    public double getBloomFilterFalsePositiveRate() {
        return this.accessor.getDouble(Option.STORAGE_LSM_BLOOMFILTER_FALSEPOSITIVERATE);
    }

    public int getBufferCacheNumPages() {
        return (int)(this.getBufferCacheSize() / (long)(this.getBufferCachePageSize() + 8));
    }

    public long getJobExecutionMemoryBudget() {
        long jobExecutionMemory = Runtime.getRuntime().maxMemory() - this.getBufferCacheSize() - this.getMemoryComponentGlobalBudget();
        if (jobExecutionMemory <= 0L) {
            String msg = String.format("Invalid node memory configuration, more memory budgeted than available in JVM. Runtime max memory: (%d), Buffer cache memory (%d), memory component global budget (%d)", Runtime.getRuntime().maxMemory(), this.getBufferCacheSize(), this.getMemoryComponentGlobalBudget());
            throw new IllegalStateException(msg);
        }
        return jobExecutionMemory;
    }

    public int getMaxActiveWritableDatasets() {
        return this.accessor.getInt(Option.STORAGE_MAX_ACTIVE_WRITABLE_DATASETS);
    }

    protected int getMetadataDatasets() {
        return 14;
    }

    protected int geSystemReservedDatasets() {
        return 0;
    }

    private long getMetadataReservedMemory() {
        return (long)this.getMetadataMemoryComponentNumPages() * (long)this.getMemoryComponentPageSize() * (long)this.getMetadataDatasets();
    }

    public static enum Option implements IOption
    {
        STORAGE_BUFFERCACHE_PAGESIZE(OptionTypes.INTEGER_BYTE_UNIT, StorageUtil.getIntSizeInBytes((int)128, (StorageUtil.StorageUnit)StorageUtil.StorageUnit.KILOBYTE)),
        STORAGE_BUFFERCACHE_SIZE(OptionTypes.LONG_BYTE_UNIT, Runtime.getRuntime().maxMemory() / 4L),
        STORAGE_BUFFERCACHE_MAXOPENFILES(OptionTypes.INTEGER, Integer.MAX_VALUE),
        STORAGE_MEMORYCOMPONENT_GLOBALBUDGET(OptionTypes.LONG_BYTE_UNIT, Runtime.getRuntime().maxMemory() / 4L),
        STORAGE_MEMORYCOMPONENT_PAGESIZE(OptionTypes.INTEGER_BYTE_UNIT, StorageUtil.getIntSizeInBytes((int)128, (StorageUtil.StorageUnit)StorageUtil.StorageUnit.KILOBYTE)),
        STORAGE_MEMORYCOMPONENT_NUMCOMPONENTS(OptionTypes.INTEGER, 2),
        STORAGE_METADATA_MEMORYCOMPONENT_NUMPAGES(OptionTypes.INTEGER, 8),
        STORAGE_LSM_BLOOMFILTER_FALSEPOSITIVERATE(OptionTypes.DOUBLE, 0.01),
        STORAGE_MAX_ACTIVE_WRITABLE_DATASETS(OptionTypes.INTEGER, 8);

        private final IOptionType interpreter;
        private final Object defaultValue;

        private <T> Option(IOptionType<T> interpreter, T defaultValue) {
            this.interpreter = interpreter;
            this.defaultValue = defaultValue;
        }

        public Section section() {
            if (this == STORAGE_MAX_ACTIVE_WRITABLE_DATASETS) {
                return Section.COMMON;
            }
            return Section.NC;
        }

        public String description() {
            switch (this) {
                case STORAGE_BUFFERCACHE_PAGESIZE: {
                    return "The page size in bytes for pages in the buffer cache";
                }
                case STORAGE_BUFFERCACHE_SIZE: {
                    return "The size of memory allocated to the disk buffer cache.  The value should be a multiple of the buffer cache page size.";
                }
                case STORAGE_BUFFERCACHE_MAXOPENFILES: {
                    return "The maximum number of open files in the buffer cache";
                }
                case STORAGE_MEMORYCOMPONENT_GLOBALBUDGET: {
                    return "The size of memory allocated to the memory components.  The value should be a multiple of the memory component page size";
                }
                case STORAGE_MEMORYCOMPONENT_PAGESIZE: {
                    return "The page size in bytes for pages allocated to memory components";
                }
                case STORAGE_MEMORYCOMPONENT_NUMCOMPONENTS: {
                    return "The number of memory components to be used per lsm index";
                }
                case STORAGE_METADATA_MEMORYCOMPONENT_NUMPAGES: {
                    return "The number of pages to allocate for a metadata memory component";
                }
                case STORAGE_LSM_BLOOMFILTER_FALSEPOSITIVERATE: {
                    return "The maximum acceptable false positive rate for bloom filters associated with LSM indexes";
                }
                case STORAGE_MAX_ACTIVE_WRITABLE_DATASETS: {
                    return "The maximum number of datasets that can be concurrently modified";
                }
            }
            throw new IllegalStateException("NYI: " + (Object)((Object)this));
        }

        public IOptionType type() {
            return this.interpreter;
        }

        public Object defaultValue() {
            return this.defaultValue;
        }

        public String usageDefaultOverride(IApplicationConfig accessor, Function<IOption, String> optionPrinter) {
            if (this == STORAGE_METADATA_MEMORYCOMPONENT_NUMPAGES) {
                return "8 pages";
            }
            return null;
        }
    }
}

