/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.impls;

import java.util.List;
import org.apache.hyracks.api.dataflow.IDestroyable;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.util.CleanupUtils;
import org.apache.hyracks.storage.am.common.api.IExtendedModificationOperationCallback;
import org.apache.hyracks.storage.am.common.impls.NoOpIndexAccessParameters;
import org.apache.hyracks.storage.am.common.tuples.PermutingTupleReference;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMemoryComponent;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedIndexAccessor;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexMemoryComponent;
import org.apache.hyracks.storage.common.IIndexAccessParameters;
import org.apache.hyracks.storage.common.IIndexAccessor;
import org.apache.hyracks.util.trace.ITracer;

public class LSMInvertedIndexOpContext
extends AbstractLSMIndexOperationContext {
    private static final int NUM_DOCUMENT_FIELDS = 1;
    private PermutingTupleReference keysOnlyTuple;
    private IInvertedIndexAccessor[] mutableInvIndexAccessors;
    private IIndexAccessor[] deletedKeysBTreeAccessors;
    private IInvertedIndexAccessor currentMutableInvIndexAccessors;
    private IIndexAccessor currentDeletedKeysBTreeAccessors;
    private IIndexAccessParameters iap;
    private boolean destroyed = false;

    public LSMInvertedIndexOpContext(ILSMIndex index, List<ILSMMemoryComponent> mutableComponents, IIndexAccessParameters iap, int[] invertedIndexFields, int[] filterFields, IBinaryComparatorFactory[] filterComparatorFactories, ITracer tracer) throws HyracksDataException {
        super(index, invertedIndexFields, filterFields, filterComparatorFactories, iap.getSearchOperationCallback(), (IExtendedModificationOperationCallback)iap.getModificationCallback(), tracer);
        this.mutableInvIndexAccessors = new IInvertedIndexAccessor[mutableComponents.size()];
        this.deletedKeysBTreeAccessors = new IIndexAccessor[mutableComponents.size()];
        for (int i = 0; i < mutableComponents.size(); ++i) {
            LSMInvertedIndexMemoryComponent mutableComponent = (LSMInvertedIndexMemoryComponent)mutableComponents.get(i);
            this.mutableInvIndexAccessors[i] = mutableComponent.getIndex().createAccessor((IIndexAccessParameters)NoOpIndexAccessParameters.INSTANCE);
            this.deletedKeysBTreeAccessors[i] = mutableComponent.getBuddyIndex().createAccessor((IIndexAccessParameters)NoOpIndexAccessParameters.INSTANCE);
        }
        LSMInvertedIndexMemoryComponent c = (LSMInvertedIndexMemoryComponent)mutableComponents.get(0);
        int numKeyFields = c.getIndex().getInvListTypeTraits().length;
        int[] keyFieldPermutation = new int[numKeyFields];
        for (int i = 0; i < numKeyFields; ++i) {
            keyFieldPermutation[i] = 1 + i;
        }
        this.keysOnlyTuple = new PermutingTupleReference(keyFieldPermutation);
        this.iap = iap;
    }

    public void setCurrentMutableComponentId(int currentMutableComponentId) {
        this.currentMutableInvIndexAccessors = this.mutableInvIndexAccessors[currentMutableComponentId];
        this.currentDeletedKeysBTreeAccessors = this.deletedKeysBTreeAccessors[currentMutableComponentId];
    }

    public IInvertedIndexAccessor getCurrentMutableInvIndexAccessors() {
        return this.currentMutableInvIndexAccessors;
    }

    public PermutingTupleReference getKeysOnlyTuple() {
        return this.keysOnlyTuple;
    }

    public IIndexAccessor getCurrentDeletedKeysBTreeAccessors() {
        return this.currentDeletedKeysBTreeAccessors;
    }

    public IIndexAccessParameters getIndexAccessParameters() {
        return this.iap;
    }

    public void destroy() throws HyracksDataException {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        Throwable failure = CleanupUtils.destroy(null, (IDestroyable[])this.mutableInvIndexAccessors);
        if ((failure = CleanupUtils.destroy((Throwable)failure, (IDestroyable[])this.deletedKeysBTreeAccessors)) != null) {
            throw HyracksDataException.create((Throwable)failure);
        }
    }
}

