/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.impls;

import java.util.HashSet;
import java.util.Set;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilter;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.common.api.IMetadataPageManager;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.lsm.common.api.AbstractLSMWithBuddyDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilter;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndex;
import org.apache.hyracks.storage.am.lsm.common.impls.IChainedComponentBulkLoader;
import org.apache.hyracks.storage.am.lsm.common.impls.IndexWithBuddyBulkLoader;
import org.apache.hyracks.storage.am.lsm.common.util.ComponentUtils;
import org.apache.hyracks.storage.am.lsm.invertedindex.ondisk.OnDiskInvertedIndex;
import org.apache.hyracks.storage.common.IIndexBulkLoader;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.buffercache.IPageWriteFailureCallback;

public class LSMInvertedIndexDiskComponent
extends AbstractLSMWithBuddyDiskComponent {
    private final OnDiskInvertedIndex invIndex;
    private final BTree deletedKeysBTree;
    private final BloomFilter bloomFilter;

    public LSMInvertedIndexDiskComponent(AbstractLSMIndex lsmIndex, OnDiskInvertedIndex invIndex, BTree deletedKeysBTree, BloomFilter bloomFilter, ILSMComponentFilter filter) {
        super(lsmIndex, (IMetadataPageManager)deletedKeysBTree.getPageManager(), filter);
        this.invIndex = invIndex;
        this.deletedKeysBTree = deletedKeysBTree;
        this.bloomFilter = bloomFilter;
    }

    public OnDiskInvertedIndex getIndex() {
        return this.invIndex;
    }

    public BTree getMetadataHolder() {
        return this.invIndex.getBTree();
    }

    public BTree getBuddyIndex() {
        return this.deletedKeysBTree;
    }

    public BloomFilter getBloomFilter() {
        return this.bloomFilter;
    }

    public IBufferCache getBloomFilterBufferCache() {
        return this.invIndex.getBufferCache();
    }

    public long getComponentSize() {
        return this.invIndex.getInvListsFile().getFile().length() + this.invIndex.getBTree().getFileReference().getFile().length() + this.deletedKeysBTree.getFileReference().getFile().length() + this.bloomFilter.getFileReference().getFile().length();
    }

    public int getFileReferenceCount() {
        return this.deletedKeysBTree.getBufferCache().getFileReferenceCount(this.deletedKeysBTree.getFileId());
    }

    public Set<String> getLSMComponentPhysicalFiles() {
        HashSet<String> files = new HashSet<String>();
        files.add(this.invIndex.getInvListsFile().getFile().getAbsolutePath());
        files.add(this.invIndex.getBTree().getFileReference().getFile().getAbsolutePath());
        files.add(this.bloomFilter.getFileReference().getFile().getAbsolutePath());
        files.add(this.deletedKeysBTree.getFileReference().getFile().getAbsolutePath());
        return files;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ":" + this.invIndex.getInvListsFile().getRelativePath();
    }

    public void markAsValid(boolean persist, IPageWriteFailureCallback callback) throws HyracksDataException {
        ComponentUtils.markAsValid((IBufferCache)this.getBloomFilterBufferCache(), (BloomFilter)this.getBloomFilter(), (boolean)persist);
        this.invIndex.getBufferCache().force(this.invIndex.getInvListsFileId(), true);
        ComponentUtils.markAsValid((ITreeIndex)this.getMetadataHolder(), (boolean)persist, (IPageWriteFailureCallback)callback);
        if (!callback.hasFailed()) {
            ComponentUtils.markAsValid((ITreeIndex)this.getBuddyIndex(), (boolean)persist, (IPageWriteFailureCallback)callback);
        }
        if (callback.hasFailed()) {
            throw HyracksDataException.create((Throwable)callback.getFailure());
        }
    }

    protected IChainedComponentBulkLoader createMergeIndexBulkLoader(float fillFactor, boolean verifyInput, long numElementsHint, boolean checkIfEmptyIndex) throws HyracksDataException {
        IIndexBulkLoader indexBulkLoader = this.invIndex.createMergeBulkLoader(fillFactor, verifyInput, numElementsHint, checkIfEmptyIndex);
        IIndexBulkLoader buddyBulkLoader = this.getBuddyIndex().createBulkLoader(fillFactor, verifyInput, numElementsHint, checkIfEmptyIndex);
        return new IndexWithBuddyBulkLoader(indexBulkLoader, buddyBulkLoader);
    }
}

