/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.api;

import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexSearchCursorInitialState;
import org.apache.hyracks.storage.common.EnforcedIndexCursor;
import org.apache.hyracks.storage.common.ICursorInitialState;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.MultiComparator;

public abstract class InvertedListCursor
extends EnforcedIndexCursor
implements Comparable<InvertedListCursor> {
    protected void doOpen(ICursorInitialState initialState, ISearchPredicate searchPred) throws HyracksDataException {
        int invListStartPageId = -1;
        int invListEndPageId = -1;
        int invListStartOffset = -1;
        int invListNumElements = -1;
        if (initialState instanceof LSMInvertedIndexSearchCursorInitialState) {
            LSMInvertedIndexSearchCursorInitialState invIndexInitialState = (LSMInvertedIndexSearchCursorInitialState)initialState;
            invListStartPageId = invIndexInitialState.getInvListStartPageId();
            invListEndPageId = invIndexInitialState.getInvListEndPageId();
            invListStartOffset = invIndexInitialState.getInvListStartOffset();
            invListNumElements = invIndexInitialState.getInvListNumElements();
        }
        if (invListNumElements != -1) {
            this.setInvListInfo(invListStartPageId, invListEndPageId, invListStartOffset, invListNumElements);
        }
    }

    protected abstract void setInvListInfo(int var1, int var2, int var3, int var4) throws HyracksDataException;

    public abstract void prepareLoadPages() throws HyracksDataException;

    public abstract void loadPages() throws HyracksDataException;

    public abstract void unloadPages() throws HyracksDataException;

    public abstract int size() throws HyracksDataException;

    public abstract boolean containsKey(ITupleReference var1, MultiComparator var2) throws HyracksDataException;

    public abstract String printInvList(ISerializerDeserializer[] var1) throws HyracksDataException;

    public abstract String printCurrentElement(ISerializerDeserializer[] var1) throws HyracksDataException;
}

