/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.exceptions;

import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.IFormattedException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.api.util.ErrorMessageUtil;

public class HyracksException
extends IOException
implements IFormattedException {
    private static final long serialVersionUID = 1L;
    public static final int UNKNOWN = 0;
    private final String component;
    private final int errorCode;
    private final Serializable[] params;
    private final String nodeId;
    private final SourceLocation sourceLoc;
    private volatile transient String msgCache;

    public static HyracksException create(Throwable cause) {
        if (cause instanceof HyracksException) {
            return (HyracksException)cause;
        }
        return new HyracksException(cause);
    }

    public static HyracksException wrapOrThrowUnchecked(Throwable cause) {
        if (cause instanceof Error) {
            throw (Error)cause;
        }
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        if (cause instanceof HyracksException) {
            return (HyracksException)cause;
        }
        return new HyracksException(cause);
    }

    public static HyracksException create(int code, Serializable ... params) {
        return new HyracksException("HYR", code, ErrorCode.getErrorMessage(code), params);
    }

    public static HyracksException create(int code, Throwable cause, Serializable ... params) {
        return new HyracksException("HYR", code, ErrorCode.getErrorMessage(code), cause, params);
    }

    public HyracksException(String component, int errorCode, String message, Throwable cause, SourceLocation sourceLoc, String nodeId, Serializable ... params) {
        super(message, cause);
        this.sourceLoc = sourceLoc;
        this.component = component;
        this.errorCode = errorCode;
        this.nodeId = nodeId;
        this.params = params;
    }

    @Deprecated
    public HyracksException(String message) {
        this("", 0, message, (Throwable)null, (String)null, (Serializable[])null);
    }

    @Deprecated
    protected HyracksException(Throwable cause) {
        this("", 0, ErrorMessageUtil.getCauseMessage(cause), cause, (Serializable[])null);
    }

    @Deprecated
    protected HyracksException(String message, Throwable cause) {
        this("", 0, message, cause, (String)null, new Serializable[0]);
    }

    public HyracksException(String component, int errorCode, Serializable ... params) {
        this(component, errorCode, (String)null, (Throwable)null, (String)null, params);
    }

    public HyracksException(Throwable cause, int errorCode, Serializable ... params) {
        this("", errorCode, ErrorMessageUtil.getCauseMessage(cause), cause, (String)null, params);
    }

    public HyracksException(String component, int errorCode, String message, Serializable ... params) {
        this(component, errorCode, message, (Throwable)null, (String)null, params);
    }

    public HyracksException(String component, int errorCode, Throwable cause, Serializable ... params) {
        this(component, errorCode, ErrorMessageUtil.getCauseMessage(cause), cause, (String)null, params);
    }

    public HyracksException(String component, int errorCode, String message, Throwable cause, Serializable ... params) {
        this(component, errorCode, message, cause, (String)null, params);
    }

    public HyracksException(String component, int errorCode, String message, Throwable cause, String nodeId, Serializable ... params) {
        this(component, errorCode, message, cause, null, nodeId, params);
    }

    @Override
    public String getComponent() {
        return this.component;
    }

    @Override
    public int getErrorCode() {
        return this.errorCode;
    }

    public Object[] getParams() {
        return this.params;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public SourceLocation getSourceLocation() {
        return this.sourceLoc;
    }

    @Override
    public String getMessage() {
        if (this.msgCache == null) {
            this.msgCache = ErrorMessageUtil.formatMessage(this.component, this.errorCode, super.getMessage(), this.sourceLoc, this.params);
        }
        return this.msgCache;
    }

    public boolean matches(String component, int errorCode) {
        Objects.requireNonNull(component, "component");
        return component.equals(this.component) && errorCode == this.errorCode;
    }

    @Override
    public String toString() {
        return this.getLocalizedMessage();
    }
}

