/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.util;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.object.base.AdmObjectNode;
import org.apache.asterix.object.base.AdmStringNode;
import org.apache.asterix.object.base.IAdmNode;

public class MergePolicyUtils {
    public static final String MERGE_POLICY_PARAMETER_NAME = "merge-policy";
    public static final String MERGE_POLICY_NAME_PARAMETER_NAME = "name";
    public static final String MERGE_POLICY_PARAMETERS_PARAMETER_NAME = "parameters";

    private MergePolicyUtils() {
    }

    public static Map<String, String> toProperties(AdmObjectNode parameters) throws CompilationException {
        HashMap<String, String> map = new HashMap<String, String>();
        block4: for (Map.Entry field : parameters.getFields()) {
            IAdmNode value = (IAdmNode)field.getValue();
            switch (value.getType()) {
                case BOOLEAN: 
                case DOUBLE: 
                case BIGINT: {
                    map.put((String)field.getKey(), value.toString());
                    continue block4;
                }
                case STRING: {
                    map.put((String)field.getKey(), ((AdmStringNode)value).get());
                    continue block4;
                }
            }
            throw new CompilationException(1062, new Serializable[]{value.getType()});
        }
        return map;
    }
}

