/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.expression;

import java.util.Objects;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.AbstractExpression;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.struct.VarIdentifier;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;

public class VariableExpr
extends AbstractExpression {
    private VarIdentifier var;
    private boolean isNewVar;

    public VariableExpr() {
        this.isNewVar = true;
    }

    public VariableExpr(VarIdentifier var) {
        this.var = var;
        this.isNewVar = true;
    }

    public boolean getIsNewVar() {
        return this.isNewVar;
    }

    public void setIsNewVar(boolean isNewVar) {
        this.isNewVar = isNewVar;
    }

    public VarIdentifier getVar() {
        return this.var;
    }

    public void setVar(VarIdentifier var) {
        this.var = var;
    }

    @Override
    public Expression.Kind getKind() {
        return Expression.Kind.VARIABLE_EXPRESSION;
    }

    @Override
    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return visitor.visit(this, arg);
    }

    public int hashCode() {
        return Objects.hashCode(this.var);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VariableExpr)) {
            return false;
        }
        VariableExpr expr = (VariableExpr)obj;
        return Objects.equals(this.var, expr.var);
    }

    public String toString() {
        return this.var.getValue();
    }
}

