/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.context;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.lang.common.context.FunctionSignatures;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.parser.ScopeChecker;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.struct.VarIdentifier;
import org.apache.commons.collections4.iterators.ReverseListIterator;

public final class Scope {
    private final ScopeChecker scopeChecker;
    private final Scope parent;
    private final LinkedHashMap<String, Identifier> symbols;
    private final boolean maskParentScope;
    private FunctionSignatures functionSignatures;

    public Scope(ScopeChecker scopeChecker) {
        this(scopeChecker, null);
    }

    public Scope(ScopeChecker scopeChecker, Scope parent) {
        this(scopeChecker, parent, false);
    }

    public Scope(ScopeChecker scopeChecker, Scope parent, boolean maskParentScope) {
        this.scopeChecker = scopeChecker;
        this.parent = parent;
        this.maskParentScope = maskParentScope;
        this.symbols = new LinkedHashMap();
    }

    public Identifier findSymbol(String name) {
        Identifier ident = this.symbols.get(name);
        if (ident == null && !this.maskParentScope && this.parent != null) {
            ident = this.parent.findSymbol(name);
        }
        return ident;
    }

    public Identifier findLocalSymbol(String name) {
        return this.symbols.get(name);
    }

    public void addSymbolToScope(Identifier ident) {
        this.symbols.put(ident.getValue(), ident);
    }

    public void addNewVarSymbolToScope(VarIdentifier ident) {
        this.scopeChecker.incVarCounter();
        ident.setId(this.scopeChecker.getVarCounter());
        this.addSymbolToScope(ident);
    }

    public void addFunctionDescriptor(FunctionSignature signature, boolean varargs) {
        if (this.functionSignatures == null) {
            this.functionSignatures = new FunctionSignatures();
        }
        this.functionSignatures.put(signature, varargs);
    }

    public FunctionSignature findFunctionSignature(String dataverse, String name, int arity) {
        FunctionSignature fd = null;
        if (this.functionSignatures != null) {
            fd = this.functionSignatures.get(dataverse, name, arity);
        }
        if (fd == null && this.parent != null) {
            fd = this.parent.findFunctionSignature(dataverse, name, arity);
        }
        return fd;
    }

    public void merge(Scope scope) {
        this.symbols.putAll(scope.symbols);
        if (this.functionSignatures != null && scope.functionSignatures != null) {
            this.functionSignatures.addAll(scope.functionSignatures);
        }
    }

    public Iterator<Identifier> liveSymbols(Scope stopAtExclusive) {
        ReverseListIterator identifierIterator = new ReverseListIterator(new ArrayList<Identifier>(this.symbols.values()));
        Iterator<Identifier> parentIterator = this.parent == null || this.parent == stopAtExclusive ? null : this.parent.liveSymbols(stopAtExclusive);
        return new Iterator<Identifier>((Iterator)identifierIterator, parentIterator){
            private Identifier currentSymbol = null;
            final /* synthetic */ Iterator val$identifierIterator;
            final /* synthetic */ Iterator val$parentIterator;
            {
                this.val$identifierIterator = iterator;
                this.val$parentIterator = iterator2;
            }

            @Override
            public boolean hasNext() {
                this.currentSymbol = null;
                if (this.val$identifierIterator.hasNext()) {
                    this.currentSymbol = (Identifier)this.val$identifierIterator.next();
                } else if (!Scope.this.maskParentScope && this.val$parentIterator != null && this.val$parentIterator.hasNext()) {
                    do {
                        Identifier symbolFromParent = (Identifier)this.val$parentIterator.next();
                        if (Scope.this.symbols.containsKey(symbolFromParent.getValue())) continue;
                        this.currentSymbol = symbolFromParent;
                        break;
                    } while (this.val$parentIterator.hasNext());
                }
                return this.currentSymbol != null;
            }

            @Override
            public Identifier next() {
                if (this.currentSymbol == null) {
                    throw new IllegalStateException("Please make sure that hasNext() returns true before calling next().");
                }
                return this.currentSymbol;
            }
        };
    }

    public Set<VariableExpr> getLiveVariables() {
        return this.getLiveVariables(null);
    }

    public Set<VariableExpr> getLiveVariables(Scope stopAtExclusive) {
        return this.getLiveVariables(stopAtExclusive, null);
    }

    public Set<VariableExpr> getLiveVariables(Scope stopAtExclusive, Predicate<? super VarIdentifier> excludeFilter) {
        LinkedHashSet<VariableExpr> vars = new LinkedHashSet<VariableExpr>();
        Iterator<Identifier> identifierIterator = this.liveSymbols(stopAtExclusive);
        while (identifierIterator.hasNext()) {
            Identifier identifier = identifierIterator.next();
            if (!(identifier instanceof VarIdentifier)) continue;
            VarIdentifier varId = (VarIdentifier)identifier;
            if (excludeFilter != null && excludeFilter.test(varId)) continue;
            vars.add(new VariableExpr(varId));
        }
        return vars;
    }

    public Set<String> getLocalSymbols() {
        return this.symbols.keySet();
    }

    public Scope getParentScope() {
        return this.parent;
    }
}

