/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.aql.util;

import java.io.DataOutput;
import java.util.List;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.formats.nontagged.BinaryComparatorFactoryProvider;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.lang.aql.parser.AQLParserFactory;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.IParser;
import org.apache.asterix.lang.common.base.IParserFactory;
import org.apache.asterix.lang.common.base.Literal;
import org.apache.asterix.lang.common.base.Statement;
import org.apache.asterix.lang.common.expression.ListConstructor;
import org.apache.asterix.lang.common.expression.LiteralExpr;
import org.apache.asterix.lang.common.literal.DoubleLiteral;
import org.apache.asterix.lang.common.literal.FloatLiteral;
import org.apache.asterix.lang.common.literal.IntegerLiteral;
import org.apache.asterix.lang.common.literal.LongIntegerLiteral;
import org.apache.asterix.lang.common.literal.StringLiteral;
import org.apache.asterix.lang.common.statement.Query;
import org.apache.asterix.om.base.AMutableDouble;
import org.apache.asterix.om.base.AMutableFloat;
import org.apache.asterix.om.base.AMutableInt32;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.base.AMutableString;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.hyracks.algebricks.common.exceptions.NotImplementedException;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.partition.range.IRangeMap;
import org.apache.hyracks.dataflow.common.data.partition.range.RangeMap;

public abstract class RangeMapBuilder {
    private static final IParserFactory parserFactory = new AQLParserFactory();

    public static IRangeMap parseHint(Object hint) throws CompilationException {
        ArrayBackedValueStorage abvs = new ArrayBackedValueStorage();
        DataOutput out = abvs.getDataOutput();
        abvs.reset();
        IParser parser = parserFactory.createParser((String)hint);
        List hintStatements = parser.parse();
        if (hintStatements.size() != 1) {
            throw new CompilationException("Only one range statement is allowed for the range hint.");
        }
        if (((Statement)hintStatements.get(0)).getKind() != Statement.Kind.QUERY) {
            throw new CompilationException("Not a proper query for the range hint.");
        }
        Query q = (Query)hintStatements.get(0);
        if (q.getBody().getKind() != Expression.Kind.LIST_CONSTRUCTOR_EXPRESSION) {
            throw new CompilationException("The range hint must be a list.");
        }
        List el = ((ListConstructor)q.getBody()).getExprList();
        int[] offsets = new int[el.size()];
        for (int i = 0; i < el.size(); ++i) {
            Expression item = (Expression)el.get(i);
            if (item.getKind() != Expression.Kind.LITERAL_EXPRESSION) continue;
            RangeMapBuilder.parseLiteralToBytes(item, out);
            offsets[i] = abvs.getLength();
        }
        return new RangeMap(1, abvs.getByteArray(), offsets);
    }

    private static void parseLiteralToBytes(Expression item, DataOutput out) throws CompilationException {
        AMutableDouble aDouble = new AMutableDouble(0.0);
        AMutableFloat aFloat = new AMutableFloat(0.0f);
        AMutableInt64 aInt64 = new AMutableInt64(0L);
        AMutableInt32 aInt32 = new AMutableInt32(0);
        AMutableString aString = new AMutableString("");
        Literal l = ((LiteralExpr)item).getValue();
        try {
            switch (l.getLiteralType()) {
                case DOUBLE: {
                    DoubleLiteral dl = (DoubleLiteral)l;
                    ISerializerDeserializer serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADOUBLE);
                    aDouble.setValue(dl.getValue().doubleValue());
                    serde.serialize((Object)aDouble, out);
                    break;
                }
                case FLOAT: {
                    FloatLiteral fl = (FloatLiteral)l;
                    ISerializerDeserializer serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AFLOAT);
                    aFloat.setValue(fl.getValue().floatValue());
                    serde.serialize((Object)aFloat, out);
                    break;
                }
                case INTEGER: {
                    IntegerLiteral il = (IntegerLiteral)l;
                    ISerializerDeserializer serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT32);
                    aInt32.setValue(il.getValue().intValue());
                    serde.serialize((Object)aInt32, out);
                    break;
                }
                case LONG: {
                    LongIntegerLiteral lil = (LongIntegerLiteral)l;
                    ISerializerDeserializer serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT64);
                    aInt64.setValue(lil.getValue().longValue());
                    serde.serialize((Object)aInt64, out);
                    break;
                }
                case STRING: {
                    StringLiteral sl = (StringLiteral)l;
                    ISerializerDeserializer serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ASTRING);
                    aString.setValue(sl.getValue());
                    serde.serialize((Object)aString, out);
                    break;
                }
                default: {
                    throw new NotImplementedException("The range map builder has not been implemented for " + item.getKind() + " type of expressions.");
                }
            }
        }
        catch (HyracksDataException e) {
            throw new CompilationException(e.getMessage());
        }
    }

    public static void verifyRangeOrder(IRangeMap rangeMap, boolean ascending) throws CompilationException {
        int fieldIndex = 0;
        int fieldType = rangeMap.getTag(0, 0);
        BinaryComparatorFactoryProvider comparatorFactory = BinaryComparatorFactoryProvider.INSTANCE;
        IBinaryComparatorFactory bcf = comparatorFactory.getBinaryComparatorFactory(ATypeTag.VALUE_TYPE_MAPPING[fieldType], ascending);
        IBinaryComparator comparator = bcf.createBinaryComparator();
        int c = 0;
        for (int split = 1; split < rangeMap.getSplitCount(); ++split) {
            if (fieldType != rangeMap.getTag(fieldIndex, split)) {
                throw new CompilationException("Range field contains more than a single type of items (" + fieldType + " and " + rangeMap.getTag(fieldIndex, split) + ").");
            }
            int previousSplit = split - 1;
            try {
                c = comparator.compare(rangeMap.getByteArray(fieldIndex, previousSplit), rangeMap.getStartOffset(fieldIndex, previousSplit), rangeMap.getLength(fieldIndex, previousSplit), rangeMap.getByteArray(fieldIndex, split), rangeMap.getStartOffset(fieldIndex, split), rangeMap.getLength(fieldIndex, split));
            }
            catch (HyracksDataException e) {
                throw new CompilationException((Throwable)e);
            }
            if (c < 0) continue;
            throw new CompilationException("Range fields are not in sorted order.");
        }
    }
}

