/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.impls;

import java.util.Iterator;
import java.util.PriorityQueue;
import org.apache.hyracks.api.dataflow.IDestroyable;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.util.CleanupUtils;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.utils.TupleUtils;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.common.impls.NoOpIndexAccessParameters;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeCursorInitialState;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMMemoryComponent;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMIndexSearchCursor;
import org.apache.hyracks.storage.common.ICursorInitialState;
import org.apache.hyracks.storage.common.IIndexAccessParameters;
import org.apache.hyracks.storage.common.IIndexAccessor;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.IModificationOperationCallback;
import org.apache.hyracks.storage.common.ISearchOperationCallback;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.util.IndexCursorUtils;

public class LSMBTreeRangeSearchCursor
extends LSMIndexSearchCursor {
    private final ArrayTupleReference copyTuple = new ArrayTupleReference();
    private final RangePredicate reusablePred = new RangePredicate(null, null, true, true, null, null);
    private ISearchOperationCallback searchCallback;
    private BTree.BTreeAccessor[] btreeAccessors;
    private boolean[] isMemoryComponent;
    private ArrayTupleBuilder tupleBuilder;
    private boolean canCallProceed = true;
    private boolean resultOfSearchCallbackProceed = false;
    private int tupleFromMemoryComponentCount = 0;

    public LSMBTreeRangeSearchCursor(ILSMIndexOperationContext opCtx) {
        this(opCtx, false);
    }

    public LSMBTreeRangeSearchCursor(ILSMIndexOperationContext opCtx, boolean returnDeletedTuples) {
        super(opCtx, returnDeletedTuples);
    }

    public void doClose() throws HyracksDataException {
        super.doClose();
        this.canCallProceed = true;
    }

    public void doNext() throws HyracksDataException {
        this.outputElement = (LSMIndexSearchCursor.PriorityQueueElement)this.outputPriorityQueue.poll();
        this.needPushElementIntoQueue = true;
        this.canCallProceed = false;
        if (this.outputElement.getCursorIndex() == 0) {
            ++this.tupleFromMemoryComponentCount;
        }
    }

    protected void checkPriorityQueue() throws HyracksDataException {
        if (this.hasNextCallCount >= 100) {
            this.replaceMemoryComponentWithDiskComponentIfNeeded();
            this.hasNextCallCount = 0;
        }
        while (!this.outputPriorityQueue.isEmpty() || this.needPushElementIntoQueue) {
            if (!this.outputPriorityQueue.isEmpty()) {
                LSMIndexSearchCursor.PriorityQueueElement queueHead = (LSMIndexSearchCursor.PriorityQueueElement)this.outputPriorityQueue.peek();
                if (this.canCallProceed) {
                    if (this.includeMutableComponent) {
                        this.resultOfSearchCallbackProceed = this.searchCallback.proceed(queueHead.getTuple());
                        if (!this.resultOfSearchCallbackProceed) {
                            LSMIndexSearchCursor.PriorityQueueElement mutableElement = this.remove(this.outputPriorityQueue, 0);
                            if (mutableElement != null) {
                                if (this.tupleBuilder == null) {
                                    this.tupleBuilder = new ArrayTupleBuilder(this.cmp.getKeyFieldCount());
                                }
                                TupleUtils.copyTuple((ArrayTupleBuilder)this.tupleBuilder, (ITupleReference)queueHead.getTuple(), (int)this.cmp.getKeyFieldCount());
                                this.copyTuple.reset(this.tupleBuilder.getFieldEndOffsets(), this.tupleBuilder.getByteArray());
                                this.rangeCursors[0].close();
                                this.searchCallback.reconcile((ITupleReference)this.copyTuple);
                                this.reusablePred.setLowKey((ITupleReference)this.copyTuple, true);
                                this.btreeAccessors[0].search(this.rangeCursors[0], (ISearchPredicate)this.reusablePred);
                                this.pushIntoQueueFromCursorAndReplaceThisElement(mutableElement);
                                queueHead = (LSMIndexSearchCursor.PriorityQueueElement)this.outputPriorityQueue.peek();
                                if (queueHead == null || this.cmp.compare((ITupleReference)this.copyTuple, queueHead.getTuple()) != 0) {
                                    this.searchCallback.cancel((ITupleReference)this.copyTuple);
                                    continue;
                                }
                                this.searchCallback.complete((ITupleReference)this.copyTuple);
                            } else {
                                this.includeMutableComponent = false;
                            }
                        }
                    } else {
                        this.resultOfSearchCallbackProceed = true;
                    }
                }
                if (this.outputElement == null) {
                    if (!this.isDeleted(queueHead) || this.returnDeletedTuples) break;
                    this.outputElement = (LSMIndexSearchCursor.PriorityQueueElement)this.outputPriorityQueue.poll();
                    this.needPushElementIntoQueue = true;
                    this.canCallProceed = false;
                    continue;
                }
                if (this.compare(this.cmp, this.outputElement.getTuple(), queueHead.getTuple()) == 0) {
                    LSMIndexSearchCursor.PriorityQueueElement e = (LSMIndexSearchCursor.PriorityQueueElement)this.outputPriorityQueue.poll();
                    this.pushIntoQueueFromCursorAndReplaceThisElement(e);
                    continue;
                }
                this.pushOutputElementIntoQueueIfNeeded();
                this.canCallProceed = true;
                this.outputElement = null;
                continue;
            }
            this.pushIntoQueueFromCursorAndReplaceThisElement(this.outputElement);
            this.needPushElementIntoQueue = false;
            this.outputElement = null;
            this.canCallProceed = true;
        }
    }

    private void pushOutputElementIntoQueueIfNeeded() throws HyracksDataException {
        if (this.needPushElementIntoQueue) {
            this.pushIntoQueueFromCursorAndReplaceThisElement(this.outputElement);
            this.needPushElementIntoQueue = false;
        }
    }

    private void replaceMemoryComponentWithDiskComponentIfNeeded() throws HyracksDataException {
        int replaceFrom = this.replaceFrom();
        if (replaceFrom < 0) {
            this.redoMemoryComponentSearchIfNeeded();
            return;
        }
        this.opCtx.getIndex().getHarness().replaceMemoryComponentsWithDiskComponents(this.getOpCtx(), replaceFrom);
        for (int i = replaceFrom; i < this.switchRequest.length && i < this.operationalComponents.size(); ++i) {
            if (this.switchRequest[i]) {
                ILSMComponent component = (ILSMComponent)this.operationalComponents.get(i);
                BTree btree = (BTree)component.getIndex();
                if (i == 0 && component.getType() != ILSMComponent.LSMComponentType.MEMORY) {
                    this.includeMutableComponent = false;
                }
                if (this.switchedElements[i] != null) {
                    this.copyTuple.reset(this.switchComponentTupleBuilders[i].getFieldEndOffsets(), this.switchComponentTupleBuilders[i].getByteArray());
                    this.reusablePred.setLowKey((ITupleReference)this.copyTuple, true);
                    this.rangeCursors[i].close();
                    this.btreeAccessors[i].reset(btree, (IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
                    this.btreeAccessors[i].search(this.rangeCursors[i], (ISearchPredicate)this.reusablePred);
                    this.pushIntoQueueFromCursorAndReplaceThisElement(this.switchedElements[i]);
                }
            }
            this.switchRequest[i] = false;
            this.switchPossible = this.switchPossible && ((ILSMComponent)this.operationalComponents.get(i)).getType() == ILSMComponent.LSMComponentType.DISK;
        }
    }

    private int replaceFrom() throws HyracksDataException {
        int replaceFrom = -1;
        if (!this.switchPossible) {
            return replaceFrom;
        }
        for (int i = 0; i < this.operationalComponents.size(); ++i) {
            LSMIndexSearchCursor.PriorityQueueElement element;
            ILSMComponent next = (ILSMComponent)this.operationalComponents.get(i);
            if (next.getType() == ILSMComponent.LSMComponentType.DISK) {
                if (i != 0) break;
                this.switchPossible = false;
                break;
            }
            if (next.getState() != ILSMComponent.ComponentState.UNREADABLE_UNWRITABLE) continue;
            if (replaceFrom < 0) {
                replaceFrom = i;
            }
            if (this.outputElement != null && this.outputElement.getCursorIndex() == i) {
                this.pushIntoQueueFromCursorAndReplaceThisElement(this.outputElement);
                this.needPushElementIntoQueue = false;
                this.outputElement = null;
                this.canCallProceed = true;
            }
            if ((element = this.remove(this.outputPriorityQueue, i)) != null) {
                if (this.switchComponentTupleBuilders[i] == null) {
                    this.switchComponentTupleBuilders[i] = new ArrayTupleBuilder(this.cmp.getKeyFieldCount());
                }
                TupleUtils.copyTuple((ArrayTupleBuilder)this.switchComponentTupleBuilders[i], (ITupleReference)element.getTuple(), (int)this.cmp.getKeyFieldCount());
            }
            this.rangeCursors[i].close();
            this.switchRequest[i] = true;
            this.switchedElements[i] = element;
        }
        return replaceFrom;
    }

    private void redoMemoryComponentSearchIfNeeded() throws HyracksDataException {
        LSMIndexSearchCursor.PriorityQueueElement mutableElement;
        if (!this.includeMutableComponent) {
            return;
        }
        if (this.tupleFromMemoryComponentCount == 0 && ((AbstractLSMMemoryComponent)this.operationalComponents.get(0)).getWriterCount() > 0 && (mutableElement = this.remove(this.outputPriorityQueue, 0)) != null) {
            if (this.tupleBuilder == null) {
                this.tupleBuilder = new ArrayTupleBuilder(this.cmp.getKeyFieldCount());
            }
            TupleUtils.copyTuple((ArrayTupleBuilder)this.tupleBuilder, (ITupleReference)mutableElement.getTuple(), (int)this.cmp.getKeyFieldCount());
            this.copyTuple.reset(this.tupleBuilder.getFieldEndOffsets(), this.tupleBuilder.getByteArray());
            this.rangeCursors[0].close();
            this.reusablePred.setLowKey((ITupleReference)this.copyTuple, true);
            this.btreeAccessors[0].search(this.rangeCursors[0], (ISearchPredicate)this.reusablePred);
            this.pushIntoQueueFromCursorAndReplaceThisElement(mutableElement);
        }
        this.tupleFromMemoryComponentCount = 0;
    }

    private LSMIndexSearchCursor.PriorityQueueElement remove(PriorityQueue<LSMIndexSearchCursor.PriorityQueueElement> outputPriorityQueue, int cursorIndex) {
        Iterator<LSMIndexSearchCursor.PriorityQueueElement> it = outputPriorityQueue.iterator();
        while (it.hasNext()) {
            LSMIndexSearchCursor.PriorityQueueElement e = it.next();
            if (e.getCursorIndex() != cursorIndex) continue;
            it.remove();
            return e;
        }
        return null;
    }

    public void doOpen(ICursorInitialState initialState, ISearchPredicate searchPred) throws HyracksDataException {
        LSMBTreeCursorInitialState lsmInitialState = (LSMBTreeCursorInitialState)initialState;
        this.cmp = lsmInitialState.getOriginalKeyComparator();
        this.operationalComponents = lsmInitialState.getOperationalComponents();
        this.lsmHarness = lsmInitialState.getLSMHarness();
        this.searchCallback = lsmInitialState.getSearchOperationCallback();
        RangePredicate predicate = (RangePredicate)lsmInitialState.getSearchPredicate();
        this.reusablePred.setLowKeyComparator(this.cmp);
        this.reusablePred.setHighKey(predicate.getHighKey(), predicate.isHighKeyInclusive());
        this.reusablePred.setHighKeyComparator(predicate.getHighKeyComparator());
        this.includeMutableComponent = false;
        int numBTrees = this.operationalComponents.size();
        if (this.rangeCursors == null) {
            this.rangeCursors = new IIndexCursor[numBTrees];
            this.btreeAccessors = new BTree.BTreeAccessor[numBTrees];
            this.isMemoryComponent = new boolean[numBTrees];
        } else if (this.rangeCursors.length != numBTrees) {
            Throwable failure = CleanupUtils.destroy(null, (IDestroyable[])this.btreeAccessors);
            this.btreeAccessors = null;
            failure = CleanupUtils.destroy((Throwable)failure, (IDestroyable[])this.rangeCursors);
            this.rangeCursors = null;
            if (failure != null) {
                throw HyracksDataException.create((Throwable)failure);
            }
            this.rangeCursors = new IIndexCursor[numBTrees];
            this.btreeAccessors = new BTree.BTreeAccessor[numBTrees];
            this.isMemoryComponent = new boolean[numBTrees];
        }
        for (int i = 0; i < numBTrees; ++i) {
            ILSMComponent component = (ILSMComponent)this.operationalComponents.get(i);
            if (component.getType() == ILSMComponent.LSMComponentType.MEMORY) {
                this.includeMutableComponent = true;
            }
            BTree btree = (BTree)component.getIndex();
            if (this.btreeAccessors[i] == null || this.destroyIncompatible(component, i)) {
                this.btreeAccessors[i] = btree.createAccessor((IIndexAccessParameters)NoOpIndexAccessParameters.INSTANCE);
                this.rangeCursors[i] = this.btreeAccessors[i].createSearchCursor(false);
            } else {
                this.btreeAccessors[i].reset(btree, (IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
                this.rangeCursors[i].close();
            }
            this.isMemoryComponent[i] = component.getType() == ILSMComponent.LSMComponentType.MEMORY;
        }
        IndexCursorUtils.open((IIndexAccessor[])this.btreeAccessors, (IIndexCursor[])this.rangeCursors, (ISearchPredicate)searchPred);
        try {
            this.setPriorityQueueComparator();
            this.initPriorityQueue();
            this.canCallProceed = true;
        }
        catch (Throwable th) {
            IndexCursorUtils.close((IIndexCursor[])this.rangeCursors, (Throwable)th);
            throw HyracksDataException.create((Throwable)th);
        }
    }

    private boolean destroyIncompatible(ILSMComponent component, int index) throws HyracksDataException {
        if (component.getType() == ILSMComponent.LSMComponentType.MEMORY ^ this.isMemoryComponent[index]) {
            Throwable failure = CleanupUtils.destroy(null, (IDestroyable[])new IDestroyable[]{this.btreeAccessors[index]});
            this.btreeAccessors[index] = null;
            failure = CleanupUtils.destroy((Throwable)failure, (IDestroyable[])new IDestroyable[]{this.rangeCursors[index]});
            this.rangeCursors[index] = null;
            if (failure != null) {
                throw HyracksDataException.create((Throwable)failure);
            }
            return true;
        }
        return false;
    }

    public boolean getSearchOperationCallbackProceedResult() {
        return this.resultOfSearchCallbackProceed;
    }
}

