/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.impls;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.btree.api.ITupleAcceptor;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.btree.impls.BTreeRangeSearchCursor;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.common.api.IExtendedModificationOperationCallback;
import org.apache.hyracks.storage.am.common.api.IIndexOperationContext;
import org.apache.hyracks.storage.am.common.api.IPageManager;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.common.api.ITreeIndexCursor;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrameFactory;
import org.apache.hyracks.storage.am.common.impls.NoOpIndexAccessParameters;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.lsm.btree.impls.AntimatterAwareTupleAcceptor;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeFlushOperation;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeMemoryComponent;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeMergeOperation;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeOpContext;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreePointSearchCursor;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeRangeSearchCursor;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeSearchCursor;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeWithBloomFilterDiskComponentFactory;
import org.apache.hyracks.storage.am.lsm.btree.tuples.LSMBTreeTupleReference;
import org.apache.hyracks.storage.am.lsm.common.api.AbstractLSMWithBloomFilterDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.IComponentFilterHelper;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilterFrameFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponentFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallbackFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationScheduler;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexFileManager;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicy;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTracker;
import org.apache.hyracks.storage.am.lsm.common.api.IVirtualBufferCache;
import org.apache.hyracks.storage.am.lsm.common.freepage.VirtualFreePageManager;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndex;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.impls.ChainedLSMDiskComponentBulkLoader;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFileReferences;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFilterManager;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMTreeIndexAccessor;
import org.apache.hyracks.storage.common.ICursorInitialState;
import org.apache.hyracks.storage.common.IIndexAccessParameters;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.MultiComparator;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.util.trace.ITracer;

public class LSMBTree
extends AbstractLSMIndex
implements ITreeIndex {
    private static final LSMTreeIndexAccessor.ICursorFactory cursorFactory = LSMBTreeSearchCursor::new;
    protected final ITreeIndexFrameFactory insertLeafFrameFactory;
    protected final ITreeIndexFrameFactory deleteLeafFrameFactory;
    protected final IBinaryComparatorFactory[] cmpFactories;
    private final boolean updateAware;
    private final boolean needKeyDupCheck;
    private final boolean hasBloomFilter;

    public LSMBTree(IIOManager ioManager, List<IVirtualBufferCache> virtualBufferCaches, ITreeIndexFrameFactory interiorFrameFactory, ITreeIndexFrameFactory insertLeafFrameFactory, ITreeIndexFrameFactory deleteLeafFrameFactory, IBufferCache diskBufferCache, ILSMIndexFileManager fileManager, ILSMDiskComponentFactory componentFactory, ILSMDiskComponentFactory bulkLoadComponentFactory, IComponentFilterHelper filterHelper, ILSMComponentFilterFrameFactory filterFrameFactory, LSMComponentFilterManager filterManager, double bloomFilterFalsePositiveRate, int fieldCount, IBinaryComparatorFactory[] cmpFactories, ILSMMergePolicy mergePolicy, ILSMOperationTracker opTracker, ILSMIOOperationScheduler ioScheduler, ILSMIOOperationCallbackFactory ioOpCallbackFactory, boolean needKeyDupCheck, int[] btreeFields, int[] filterFields, boolean durable, boolean updateAware, ITracer tracer) throws HyracksDataException {
        super(ioManager, virtualBufferCaches, diskBufferCache, fileManager, bloomFilterFalsePositiveRate, mergePolicy, opTracker, ioScheduler, ioOpCallbackFactory, componentFactory, bulkLoadComponentFactory, filterFrameFactory, filterManager, filterFields, durable, filterHelper, btreeFields, tracer);
        this.insertLeafFrameFactory = insertLeafFrameFactory;
        this.deleteLeafFrameFactory = deleteLeafFrameFactory;
        this.cmpFactories = cmpFactories;
        this.updateAware = updateAware;
        int i = 0;
        for (IVirtualBufferCache virtualBufferCache : virtualBufferCaches) {
            LSMBTreeMemoryComponent mutableComponent = new LSMBTreeMemoryComponent(this, new BTree((IBufferCache)virtualBufferCache, (IPageManager)new VirtualFreePageManager((IBufferCache)virtualBufferCache), interiorFrameFactory, insertLeafFrameFactory, cmpFactories, fieldCount, ioManager.resolveAbsolutePath(fileManager.getBaseDir() + "_virtual_" + i)), virtualBufferCache, filterHelper == null ? null : filterHelper.createFilter());
            this.memoryComponents.add(mutableComponent);
            ++i;
        }
        this.needKeyDupCheck = needKeyDupCheck;
        this.hasBloomFilter = needKeyDupCheck;
    }

    public LSMBTree(IIOManager ioManager, ITreeIndexFrameFactory insertLeafFrameFactory, ITreeIndexFrameFactory deleteLeafFrameFactory, IBufferCache bufferCache, ILSMIndexFileManager fileManager, ILSMDiskComponentFactory componentFactory, ILSMDiskComponentFactory bulkLoadComponentFactory, double bloomFilterFalsePositiveRate, IBinaryComparatorFactory[] cmpFactories, ILSMMergePolicy mergePolicy, ILSMOperationTracker opTracker, ILSMIOOperationScheduler ioScheduler, ILSMIOOperationCallbackFactory ioOpCallbackFactory, boolean needKeyDupCheck, boolean durable, ITracer tracer) throws HyracksDataException {
        super(ioManager, bufferCache, fileManager, bloomFilterFalsePositiveRate, mergePolicy, opTracker, ioScheduler, ioOpCallbackFactory, componentFactory, bulkLoadComponentFactory, durable, tracer);
        this.insertLeafFrameFactory = insertLeafFrameFactory;
        this.deleteLeafFrameFactory = deleteLeafFrameFactory;
        this.cmpFactories = cmpFactories;
        this.needKeyDupCheck = needKeyDupCheck;
        this.hasBloomFilter = true;
        this.updateAware = false;
    }

    public boolean isPrimaryIndex() {
        return this.needKeyDupCheck;
    }

    public IBinaryComparatorFactory[] getComparatorFactories() {
        return this.cmpFactories;
    }

    public void modify(IIndexOperationContext ictx, ITupleReference tuple) throws HyracksDataException {
        ITupleReference indexTuple;
        LSMBTreeOpContext ctx = (LSMBTreeOpContext)ictx;
        if (ctx.getIndexTuple() != null) {
            ctx.getIndexTuple().reset(tuple);
            indexTuple = ctx.getIndexTuple();
        } else {
            indexTuple = tuple;
        }
        switch (ctx.getOperation()) {
            case PHYSICALDELETE: {
                ctx.getCurrentMutableBTreeAccessor().delete(indexTuple);
                break;
            }
            case INSERT: {
                this.insert(indexTuple, ctx);
                break;
            }
            default: {
                ctx.getCurrentMutableBTreeAccessor().upsert(indexTuple);
            }
        }
        this.updateFilter((ILSMIndexOperationContext)ctx, tuple);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean insert(ITupleReference tuple, LSMBTreeOpContext ctx) throws HyracksDataException {
        LSMBTreePointSearchCursor searchCursor = ctx.getInsertSearchCursor();
        BTreeRangeSearchCursor memCursor = ctx.getMemCursor();
        RangePredicate predicate = (RangePredicate)ctx.getSearchPredicate();
        predicate.setHighKey(tuple);
        predicate.setLowKey(tuple);
        if (this.needKeyDupCheck) {
            boolean found;
            ctx.getCurrentMutableBTreeAccessor().search((IIndexCursor)memCursor, (ISearchPredicate)predicate);
            try {
                found = memCursor.hasNext();
                if (found) {
                    memCursor.next();
                    LSMBTreeTupleReference lsmbtreeTuple = (LSMBTreeTupleReference)memCursor.getTuple();
                    if (!lsmbtreeTuple.isAntimatter()) {
                        throw HyracksDataException.create((int)33, (Serializable[])new Serializable[0]);
                    }
                }
            }
            finally {
                memCursor.close();
            }
            if (found) {
                ctx.getCurrentMutableBTreeAccessor().upsertIfConditionElseInsert(tuple, (ITupleAcceptor)AntimatterAwareTupleAcceptor.INSTANCE);
                return true;
            }
            ILSMComponent firstComponent = (ILSMComponent)ctx.getComponentHolder().remove(0);
            this.search((ILSMIndexOperationContext)ctx, (IIndexCursor)searchCursor, (ISearchPredicate)predicate);
            try {
                if (searchCursor.hasNext()) {
                    throw HyracksDataException.create((int)33, (Serializable[])new Serializable[0]);
                }
            }
            finally {
                searchCursor.close();
                ctx.getComponentHolder().add(0, firstComponent);
            }
        }
        ctx.getCurrentMutableBTreeAccessor().upsertIfConditionElseInsert(tuple, (ITupleAcceptor)AntimatterAwareTupleAcceptor.INSTANCE);
        return true;
    }

    public void search(ILSMIndexOperationContext ictx, IIndexCursor cursor, ISearchPredicate pred) throws HyracksDataException {
        LSMBTreeOpContext ctx = (LSMBTreeOpContext)ictx;
        List operationalComponents = ctx.getComponentHolder();
        ctx.getSearchInitialState().reset(pred, operationalComponents);
        cursor.open((ICursorInitialState)ctx.getSearchInitialState(), pred);
    }

    public void scanDiskComponents(ILSMIndexOperationContext ictx, IIndexCursor cursor) throws HyracksDataException {
        if (!this.isPrimaryIndex()) {
            throw HyracksDataException.create((int)56, (Serializable[])new Serializable[0]);
        }
        LSMBTreeOpContext ctx = (LSMBTreeOpContext)ictx;
        List operationalComponents = ctx.getComponentHolder();
        MultiComparator comp = MultiComparator.create((IBinaryComparatorFactory[])this.getComparatorFactories());
        RangePredicate pred = new RangePredicate(null, null, true, true, comp, comp);
        ctx.getSearchInitialState().reset((ISearchPredicate)pred, operationalComponents);
        ctx.getSearchInitialState().setDiskComponentScan(true);
        ((LSMBTreeSearchCursor)cursor).open(ctx.getSearchInitialState(), (ISearchPredicate)pred);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILSMDiskComponent doFlush(ILSMIOOperation operation) throws HyracksDataException {
        ChainedLSMDiskComponentBulkLoader componentBulkLoader;
        ILSMDiskComponent component;
        LSMBTreeFlushOperation flushOp = (LSMBTreeFlushOperation)operation;
        LSMBTreeMemoryComponent flushingComponent = (LSMBTreeMemoryComponent)flushOp.getFlushingComponent();
        BTree.BTreeAccessor accessor = flushingComponent.getIndex().createAccessor((IIndexAccessParameters)NoOpIndexAccessParameters.INSTANCE);
        try {
            RangePredicate nullPred = new RangePredicate(null, null, true, true, null, null);
            long numElements = 0L;
            if (this.hasBloomFilter) {
                ITreeIndexCursor countingCursor = accessor.createCountingSearchCursor();
                accessor.search((IIndexCursor)countingCursor, (ISearchPredicate)nullPred);
                try {
                    while (countingCursor.hasNext()) {
                        countingCursor.next();
                        ITupleReference countTuple = countingCursor.getTuple();
                        numElements = IntegerPointable.getInteger((byte[])countTuple.getFieldData(0), (int)countTuple.getFieldStart(0));
                    }
                }
                finally {
                    try {
                        countingCursor.close();
                    }
                    finally {
                        countingCursor.destroy();
                    }
                }
            }
            component = this.createDiskComponent(this.componentFactory, flushOp.getTarget(), null, flushOp.getBloomFilterTarget(), true);
            componentBulkLoader = component.createBulkLoader(operation, 1.0f, false, numElements, false, false, false);
            IIndexCursor scanCursor = accessor.createSearchCursor(false);
            accessor.search(scanCursor, (ISearchPredicate)nullPred);
            try {
                while (scanCursor.hasNext()) {
                    scanCursor.next();
                    if (this.updateAware && ((LSMBTreeTupleReference)scanCursor.getTuple()).isUpdated()) continue;
                    componentBulkLoader.add(scanCursor.getTuple());
                }
            }
            finally {
                try {
                    scanCursor.close();
                }
                finally {
                    scanCursor.destroy();
                }
            }
        }
        finally {
            accessor.destroy();
        }
        if (component.getLSMComponentFilter() != null) {
            ArrayList<ITupleReference> filterTuples = new ArrayList<ITupleReference>();
            filterTuples.add(flushingComponent.getLSMComponentFilter().getMinTuple());
            filterTuples.add(flushingComponent.getLSMComponentFilter().getMaxTuple());
            this.getFilterManager().updateFilter(component.getLSMComponentFilter(), filterTuples, (IExtendedModificationOperationCallback)NoOpOperationCallback.INSTANCE);
            this.getFilterManager().writeFilter(component.getLSMComponentFilter(), component.getMetadataHolder());
        }
        flushingComponent.getMetadata().copy(component.getMetadata());
        componentBulkLoader.end();
        return component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILSMDiskComponent doMerge(ILSMIOOperation operation) throws HyracksDataException {
        ILSMDiskComponent mergedComponent;
        LSMBTreeMergeOperation mergeOp = (LSMBTreeMergeOperation)operation;
        IIndexCursor cursor = mergeOp.getCursor();
        ChainedLSMDiskComponentBulkLoader componentBulkLoader = null;
        try {
            try {
                RangePredicate rangePred = new RangePredicate(null, null, true, true, null, null);
                this.search(mergeOp.getAccessor().getOpContext(), cursor, (ISearchPredicate)rangePred);
                try {
                    List mergedComponents = mergeOp.getMergingComponents();
                    long numElements = this.getNumberOfElements(mergedComponents);
                    mergedComponent = this.createDiskComponent(this.componentFactory, mergeOp.getTarget(), null, mergeOp.getBloomFilterTarget(), true);
                    componentBulkLoader = mergedComponent.createBulkLoader(operation, 1.0f, false, numElements, false, false, false);
                    while (cursor.hasNext()) {
                        cursor.next();
                        ITupleReference frameTuple = cursor.getTuple();
                        componentBulkLoader.add(frameTuple);
                    }
                }
                finally {
                    cursor.close();
                }
            }
            finally {
                cursor.destroy();
            }
            if (mergedComponent.getLSMComponentFilter() != null) {
                ArrayList<ITupleReference> filterTuples = new ArrayList<ITupleReference>();
                for (int i = 0; i < mergeOp.getMergingComponents().size(); ++i) {
                    filterTuples.add(((ILSMComponent)mergeOp.getMergingComponents().get(i)).getLSMComponentFilter().getMinTuple());
                    filterTuples.add(((ILSMComponent)mergeOp.getMergingComponents().get(i)).getLSMComponentFilter().getMaxTuple());
                }
                this.getFilterManager().updateFilter(mergedComponent.getLSMComponentFilter(), filterTuples, (IExtendedModificationOperationCallback)NoOpOperationCallback.INSTANCE);
                this.getFilterManager().writeFilter(mergedComponent.getLSMComponentFilter(), mergedComponent.getMetadataHolder());
            }
        }
        catch (Throwable e) {
            try {
                if (componentBulkLoader != null) {
                    componentBulkLoader.abort();
                }
            }
            catch (Throwable th) {
                e.addSuppressed(th);
            }
            throw e;
        }
        componentBulkLoader.end();
        return mergedComponent;
    }

    private long getNumberOfElements(List<ILSMComponent> mergedComponents) throws HyracksDataException {
        long numElements = 0L;
        if (this.hasBloomFilter) {
            for (int i = 0; i < mergedComponents.size(); ++i) {
                numElements += ((AbstractLSMWithBloomFilterDiskComponent)mergedComponents.get(i)).getBloomFilter().getNumElements();
            }
        }
        return numElements;
    }

    protected ILSMIOOperation createFlushOperation(AbstractLSMIndexOperationContext opCtx, LSMComponentFileReferences componentFileRefs, ILSMIOOperationCallback callback) {
        ILSMIndexAccessor accessor = this.createAccessor(opCtx);
        return new LSMBTreeFlushOperation(accessor, componentFileRefs.getInsertIndexFileReference(), componentFileRefs.getBloomFilterFileReference(), callback, this.getIndexIdentifier());
    }

    public LSMBTreeOpContext createOpContext(IIndexAccessParameters iap) {
        int numBloomFilterKeyFields = this.hasBloomFilter ? ((LSMBTreeWithBloomFilterDiskComponentFactory)this.componentFactory).getBloomFilterKeyFields().length : 0;
        return new LSMBTreeOpContext((ILSMIndex)this, this.memoryComponents, this.insertLeafFrameFactory, this.deleteLeafFrameFactory, (IExtendedModificationOperationCallback)iap.getModificationCallback(), iap.getSearchOperationCallback(), numBloomFilterKeyFields, this.getTreeFields(), this.getFilterFields(), this.getHarness(), this.getFilterCmpFactories(), this.tracer);
    }

    public ILSMIndexAccessor createAccessor(IIndexAccessParameters iap) {
        return this.createAccessor(this.createOpContext(iap));
    }

    public ILSMIndexAccessor createAccessor(AbstractLSMIndexOperationContext opCtx) {
        return new LSMTreeIndexAccessor(this.getHarness(), (ILSMIndexOperationContext)opCtx, cursorFactory);
    }

    public ITreeIndexFrameFactory getInteriorFrameFactory() {
        LSMBTreeMemoryComponent mutableComponent = (LSMBTreeMemoryComponent)((Object)this.memoryComponents.get(this.currentMutableComponentId.get()));
        return mutableComponent.getIndex().getInteriorFrameFactory();
    }

    public int getFieldCount() {
        LSMBTreeMemoryComponent mutableComponent = (LSMBTreeMemoryComponent)((Object)this.memoryComponents.get(this.currentMutableComponentId.get()));
        return mutableComponent.getIndex().getFieldCount();
    }

    public int getFileId() {
        LSMBTreeMemoryComponent mutableComponent = (LSMBTreeMemoryComponent)((Object)this.memoryComponents.get(this.currentMutableComponentId.get()));
        return mutableComponent.getIndex().getFileId();
    }

    public IPageManager getPageManager() {
        LSMBTreeMemoryComponent mutableComponent = (LSMBTreeMemoryComponent)((Object)this.memoryComponents.get(this.currentMutableComponentId.get()));
        return mutableComponent.getIndex().getPageManager();
    }

    public ITreeIndexFrameFactory getLeafFrameFactory() {
        LSMBTreeMemoryComponent mutableComponent = (LSMBTreeMemoryComponent)((Object)this.memoryComponents.get(this.currentMutableComponentId.get()));
        return mutableComponent.getIndex().getLeafFrameFactory();
    }

    public int getRootPageId() {
        LSMBTreeMemoryComponent mutableComponent = (LSMBTreeMemoryComponent)((Object)this.memoryComponents.get(this.currentMutableComponentId.get()));
        return mutableComponent.getIndex().getRootPageId();
    }

    protected LSMComponentFileReferences getMergeFileReferences(ILSMDiskComponent firstComponent, ILSMDiskComponent lastComponent) throws HyracksDataException {
        BTree firstBTree = (BTree)firstComponent.getIndex();
        BTree lastBTree = (BTree)lastComponent.getIndex();
        FileReference firstFile = firstBTree.getFileReference();
        FileReference lastFile = lastBTree.getFileReference();
        return this.fileManager.getRelMergeFileReference(firstFile.getFile().getName(), lastFile.getFile().getName());
    }

    protected ILSMIOOperation createMergeOperation(AbstractLSMIndexOperationContext opCtx, LSMComponentFileReferences mergeFileRefs, ILSMIOOperationCallback callback) {
        boolean returnDeletedTuples = false;
        ILSMIndexAccessor accessor = this.createAccessor(opCtx);
        List mergingComponents = opCtx.getComponentHolder();
        if (mergingComponents.get(mergingComponents.size() - 1) != this.diskComponents.get(this.diskComponents.size() - 1)) {
            returnDeletedTuples = true;
        }
        LSMBTreeRangeSearchCursor cursor = new LSMBTreeRangeSearchCursor((ILSMIndexOperationContext)opCtx, returnDeletedTuples);
        return new LSMBTreeMergeOperation(accessor, (IIndexCursor)cursor, mergeFileRefs.getInsertIndexFileReference(), mergeFileRefs.getBloomFilterFileReference(), callback, this.getIndexIdentifier());
    }
}

