/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.geo.evaluators.functions;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.exceptions.InvalidDataFormatException;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.dataflow.common.data.marshalling.ByteArraySerializerDeserializer;

public class STGeomFromWKBDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new STGeomFromWKBDescriptor();
        }
    };
    private static final long serialVersionUID = 1L;

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.ST_GEOM_FROM_WKB;
    }

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(IHyracksTaskContext ctx) throws HyracksDataException {
                return new STGeomFromWKBEvaulator(args, ctx);
            }
        };
    }

    private class STGeomFromWKBEvaulator
    implements IScalarEvaluator {
        private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
        private DataOutput out = this.resultStorage.getDataOutput();
        private IPointable inputArg = new VoidPointable();
        private IScalarEvaluator eval;

        public STGeomFromWKBEvaulator(IScalarEvaluatorFactory[] args, IHyracksTaskContext ctx) throws HyracksDataException {
            this.eval = args[0].createScalarEvaluator(ctx);
        }

        public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
            this.eval.evaluate(tuple, this.inputArg);
            byte[] data = this.inputArg.getByteArray();
            int offset = this.inputArg.getStartOffset();
            int len = this.inputArg.getLength();
            if (data[offset] != ATypeTag.SERIALIZED_BINARY_TYPE_TAG) {
                throw new TypeMismatchException(STGeomFromWKBDescriptor.this.sourceLoc, BuiltinFunctions.ST_GEOM_FROM_WKB, Integer.valueOf(0), data[offset], new byte[]{ATypeTag.SERIALIZED_BINARY_TYPE_TAG});
            }
            try {
                this.out.writeByte(ATypeTag.SERIALIZED_GEOMETRY_TYPE_TAG);
                ByteArrayInputStream inStream = new ByteArrayInputStream(data, offset + 1, len - 1);
                DataInputStream dataIn = new DataInputStream(inStream);
                data = ByteArraySerializerDeserializer.read((DataInput)dataIn);
                this.out.writeInt(data.length);
                this.out.write(data);
                result.set((IValueReference)this.resultStorage);
            }
            catch (IOException e) {
                throw new InvalidDataFormatException(STGeomFromWKBDescriptor.this.sourceLoc, STGeomFromWKBDescriptor.this.getIdentifier(), (Throwable)e, ATypeTag.SERIALIZED_GEOMETRY_TYPE_TAG);
            }
        }
    }
}

