/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.common.data.partition.range;

import java.io.Serializable;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.dataflow.common.data.partition.range.IRangeMap;

public class RangeMap
implements IRangeMap,
Serializable {
    private static final long serialVersionUID = -7523433293419648234L;
    private final int fields;
    private final byte[] bytes;
    private final int[] offsets;

    public RangeMap(int fields, byte[] bytes, int[] offsets) {
        this.fields = fields;
        this.bytes = bytes;
        this.offsets = offsets;
    }

    @Override
    public IPointable getFieldSplit(int columnIndex, int splitIndex) {
        VoidPointable p = VoidPointable.FACTORY.createPointable();
        int index = this.getFieldIndex(columnIndex, splitIndex);
        p.set(this.bytes, this.getFieldStart(index), this.getFieldLength(index));
        return p;
    }

    @Override
    public int getSplitCount() {
        return this.offsets.length / this.fields;
    }

    @Override
    public byte[] getByteArray(int columnIndex, int splitIndex) {
        return this.bytes;
    }

    @Override
    public int getTag(int columnIndex, int splitIndex) {
        return this.getFieldTag(this.getFieldIndex(columnIndex, splitIndex));
    }

    @Override
    public int getStartOffset(int columnIndex, int splitIndex) {
        return this.getFieldStart(this.getFieldIndex(columnIndex, splitIndex));
    }

    @Override
    public int getLength(int columnIndex, int splitIndex) {
        return this.getFieldLength(this.getFieldIndex(columnIndex, splitIndex));
    }

    private int getFieldIndex(int columnIndex, int splitIndex) {
        return splitIndex * this.fields + columnIndex;
    }

    private int getFieldTag(int index) {
        return this.bytes[this.getFieldStart(index)];
    }

    private int getFieldStart(int index) {
        int start = 0;
        if (index != 0) {
            start = this.offsets[index - 1];
        }
        return start;
    }

    private int getFieldLength(int index) {
        int length = this.offsets[index];
        if (index != 0) {
            length -= this.offsets[index - 1];
        }
        return length;
    }
}

