/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.sort;

import java.util.List;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.ActivityId;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.INormalizedKeyComputer;
import org.apache.hyracks.api.dataflow.value.INormalizedKeyComputerFactory;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.dataflow.common.io.GeneratedRunFileReader;
import org.apache.hyracks.dataflow.std.sort.AbstractSortRunGenerator;
import org.apache.hyracks.dataflow.std.sort.AbstractSorterOperatorDescriptor;
import org.apache.hyracks.dataflow.std.sort.ExternalSortRunMerger;
import org.apache.hyracks.dataflow.std.sort.HybridTopKSortRunGenerator;
import org.apache.hyracks.dataflow.std.sort.ISorter;

public class TopKSorterOperatorDescriptor
extends AbstractSorterOperatorDescriptor {
    private static final long serialVersionUID = 1L;
    private final int topK;

    public TopKSorterOperatorDescriptor(IOperatorDescriptorRegistry spec, int framesLimit, int topK, int[] sortFields, INormalizedKeyComputerFactory firstKeyNormalizerFactory, IBinaryComparatorFactory[] comparatorFactories, RecordDescriptor recordDescriptor) {
        INormalizedKeyComputerFactory[] iNormalizedKeyComputerFactoryArray;
        if (firstKeyNormalizerFactory != null) {
            INormalizedKeyComputerFactory[] iNormalizedKeyComputerFactoryArray2 = new INormalizedKeyComputerFactory[1];
            iNormalizedKeyComputerFactoryArray = iNormalizedKeyComputerFactoryArray2;
            iNormalizedKeyComputerFactoryArray2[0] = firstKeyNormalizerFactory;
        } else {
            iNormalizedKeyComputerFactoryArray = null;
        }
        this(spec, framesLimit, topK, sortFields, iNormalizedKeyComputerFactoryArray, comparatorFactories, recordDescriptor);
    }

    public TopKSorterOperatorDescriptor(IOperatorDescriptorRegistry spec, int framesLimit, int topK, int[] sortFields, INormalizedKeyComputerFactory[] keyNormalizerFactories, IBinaryComparatorFactory[] comparatorFactories, RecordDescriptor recordDescriptor) {
        super(spec, framesLimit, sortFields, keyNormalizerFactories, comparatorFactories, recordDescriptor);
        this.topK = topK;
    }

    @Override
    public AbstractSorterOperatorDescriptor.SortActivity getSortActivity(ActivityId id) {
        return new AbstractSorterOperatorDescriptor.SortActivity(id){
            private static final long serialVersionUID = 1L;

            @Override
            protected AbstractSortRunGenerator getRunGenerator(IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider) {
                return new HybridTopKSortRunGenerator(ctx, TopKSorterOperatorDescriptor.this.framesLimit, TopKSorterOperatorDescriptor.this.topK, TopKSorterOperatorDescriptor.this.sortFields, TopKSorterOperatorDescriptor.this.keyNormalizerFactories, TopKSorterOperatorDescriptor.this.comparatorFactories, TopKSorterOperatorDescriptor.this.outRecDescs[0]);
            }
        };
    }

    @Override
    public AbstractSorterOperatorDescriptor.MergeActivity getMergeActivity(ActivityId id) {
        return new AbstractSorterOperatorDescriptor.MergeActivity(id){
            private static final long serialVersionUID = 1L;

            @Override
            protected ExternalSortRunMerger getSortRunMerger(IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, IFrameWriter writer, ISorter sorter, List<GeneratedRunFileReader> runs, IBinaryComparator[] comparators, INormalizedKeyComputer nmkComputer, int necessaryFrames) {
                return new ExternalSortRunMerger(ctx, sorter, runs, TopKSorterOperatorDescriptor.this.sortFields, comparators, nmkComputer, TopKSorterOperatorDescriptor.this.outRecDescs[0], necessaryFrames, TopKSorterOperatorDescriptor.this.topK, writer);
            }
        };
    }
}

