/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.buffermanager;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.hyracks.api.comm.FixedSizeFrame;
import org.apache.hyracks.api.comm.FrameHelper;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.FixedSizeFrameTupleAppender;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.std.buffermanager.AbstractTuplePointerAccessor;
import org.apache.hyracks.dataflow.std.buffermanager.BufferInfo;
import org.apache.hyracks.dataflow.std.buffermanager.DeallocatableFramePool;
import org.apache.hyracks.dataflow.std.buffermanager.FrameBufferManager;
import org.apache.hyracks.dataflow.std.buffermanager.IDeallocatableFramePool;
import org.apache.hyracks.dataflow.std.buffermanager.IFrameBufferManager;
import org.apache.hyracks.dataflow.std.buffermanager.IPartitionedMemoryConstrain;
import org.apache.hyracks.dataflow.std.buffermanager.IPartitionedTupleBufferManager;
import org.apache.hyracks.dataflow.std.buffermanager.ITuplePointerAccessor;
import org.apache.hyracks.dataflow.std.structures.TuplePointer;

public class VPartitionTupleBufferManager
implements IPartitionedTupleBufferManager {
    public static final IPartitionedMemoryConstrain NO_CONSTRAIN = new IPartitionedMemoryConstrain(){

        @Override
        public int frameLimit(int partitionId) {
            return Integer.MAX_VALUE;
        }
    };
    private IDeallocatableFramePool framePool;
    private IFrameBufferManager[] partitionArray;
    private int[] numTuples;
    private final FixedSizeFrame appendFrame;
    private final FixedSizeFrameTupleAppender appender;
    private BufferInfo tempInfo;
    private final IPartitionedMemoryConstrain constrain;

    public VPartitionTupleBufferManager(IPartitionedMemoryConstrain constrain, int partitions, IDeallocatableFramePool framePool) throws HyracksDataException {
        this.constrain = constrain;
        this.framePool = framePool;
        this.partitionArray = new IFrameBufferManager[partitions];
        this.numTuples = new int[partitions];
        this.appendFrame = new FixedSizeFrame();
        this.appender = new FixedSizeFrameTupleAppender();
        this.tempInfo = new BufferInfo(null, -1, -1);
    }

    public VPartitionTupleBufferManager(IHyracksFrameMgrContext ctx, IPartitionedMemoryConstrain constrain, int partitions, int frameLimitInBytes) throws HyracksDataException {
        this.constrain = constrain;
        this.framePool = new DeallocatableFramePool(ctx, frameLimitInBytes);
        this.partitionArray = new IFrameBufferManager[partitions];
        this.numTuples = new int[partitions];
        this.appendFrame = new FixedSizeFrame();
        this.appender = new FixedSizeFrameTupleAppender();
        this.tempInfo = new BufferInfo(null, -1, -1);
    }

    @Override
    public void reset() throws HyracksDataException {
        for (IFrameBufferManager part : this.partitionArray) {
            if (part == null) continue;
            for (int i = 0; i < part.getNumFrames(); ++i) {
                this.framePool.deAllocateBuffer(part.getFrame(i, this.tempInfo).getBuffer());
            }
            part.reset();
        }
        Arrays.fill(this.numTuples, 0);
        this.appendFrame.reset(null);
    }

    @Override
    public int getNumPartitions() {
        return this.partitionArray.length;
    }

    @Override
    public int getNumTuples(int partition) {
        return this.numTuples[partition];
    }

    @Override
    public int getPhysicalSize(int partitionId) {
        int size = 0;
        IFrameBufferManager partition = this.partitionArray[partitionId];
        if (partition != null) {
            for (int i = 0; i < partition.getNumFrames(); ++i) {
                size += partition.getFrame(i, this.tempInfo).getLength();
            }
        }
        return size;
    }

    @Override
    public void clearPartition(int partitionId) throws HyracksDataException {
        IFrameBufferManager partition = this.partitionArray[partitionId];
        if (partition != null) {
            for (int i = 0; i < partition.getNumFrames(); ++i) {
                this.framePool.deAllocateBuffer(partition.getFrame(i, this.tempInfo).getBuffer());
            }
            partition.reset();
        }
        this.numTuples[partitionId] = 0;
    }

    @Override
    public boolean insertTuple(int partition, byte[] byteArray, int[] fieldEndOffsets, int start, int size, TuplePointer pointer) throws HyracksDataException {
        int actualSize = VPartitionTupleBufferManager.calculateActualSize(fieldEndOffsets, size);
        int fid = this.getLastBufferOrCreateNewIfNotExist(partition, actualSize);
        if (fid < 0) {
            return false;
        }
        this.partitionArray[partition].getFrame(fid, this.tempInfo);
        int tid = this.appendTupleToBuffer(this.tempInfo, fieldEndOffsets, byteArray, start, size);
        if (tid < 0) {
            if (this.partitionArray[partition].getNumFrames() >= this.constrain.frameLimit(partition)) {
                return false;
            }
            fid = this.createNewBuffer(partition, actualSize);
            if (fid < 0) {
                return false;
            }
            this.partitionArray[partition].getFrame(fid, this.tempInfo);
            tid = this.appendTupleToBuffer(this.tempInfo, fieldEndOffsets, byteArray, start, size);
        }
        pointer.reset(this.makeGroupFrameId(partition, fid), tid);
        int n = partition;
        this.numTuples[n] = this.numTuples[n] + 1;
        return true;
    }

    @Override
    public boolean insertTuple(int partition, IFrameTupleAccessor tupleAccessor, int tupleId, TuplePointer pointer) throws HyracksDataException {
        return this.insertTuple(partition, tupleAccessor.getBuffer().array(), null, tupleAccessor.getTupleStartOffset(tupleId), tupleAccessor.getTupleLength(tupleId), pointer);
    }

    @Override
    public void cancelInsertTuple(int partition) throws HyracksDataException {
        int fid = this.getLastBuffer(partition);
        if (fid < 0) {
            throw new HyracksDataException("Couldn't get the last frame for the given partition.");
        }
        this.partitionArray[partition].getFrame(fid, this.tempInfo);
        this.deleteTupleFromBuffer(this.tempInfo);
        int n = partition;
        this.numTuples[n] = this.numTuples[n] - 1;
    }

    private static int calculateActualSize(int[] fieldEndOffsets, int size) {
        if (fieldEndOffsets != null) {
            return FrameHelper.calcRequiredSpace((int)fieldEndOffsets.length, (int)size);
        }
        return FrameHelper.calcRequiredSpace((int)0, (int)size);
    }

    private int makeGroupFrameId(int partition, int fid) {
        return fid * this.getNumPartitions() + partition;
    }

    private int parsePartitionId(int externalFrameId) {
        return externalFrameId % this.getNumPartitions();
    }

    private int parseFrameIdInPartition(int externalFrameId) {
        return externalFrameId / this.getNumPartitions();
    }

    private int createNewBuffer(int partition, int size) throws HyracksDataException {
        ByteBuffer newBuffer = this.requestNewBufferFromPool(size);
        if (newBuffer == null) {
            return -1;
        }
        this.appendFrame.reset(newBuffer);
        this.appender.reset((IFrame)this.appendFrame, true);
        return this.partitionArray[partition].insertFrame(newBuffer);
    }

    private ByteBuffer requestNewBufferFromPool(int recordSize) throws HyracksDataException {
        int frameSize = FrameHelper.calcAlignedFrameSizeToStore((int)0, (int)recordSize, (int)this.framePool.getMinFrameSize());
        return this.framePool.allocateFrame(frameSize);
    }

    private int appendTupleToBuffer(BufferInfo bufferInfo, int[] fieldEndOffsets, byte[] byteArray, int start, int size) throws HyracksDataException {
        assert (bufferInfo.getStartOffset() == 0) : "Haven't supported yet in FrameTupleAppender";
        if (bufferInfo.getBuffer() != this.appendFrame.getBuffer()) {
            this.appendFrame.reset(bufferInfo.getBuffer());
            this.appender.reset((IFrame)this.appendFrame, false);
        }
        if (fieldEndOffsets == null ? this.appender.append(byteArray, start, size) : this.appender.append(fieldEndOffsets, byteArray, start, size)) {
            return this.appender.getTupleCount() - 1;
        }
        return -1;
    }

    private void deleteTupleFromBuffer(BufferInfo bufferInfo) throws HyracksDataException {
        if (bufferInfo.getBuffer() != this.appendFrame.getBuffer()) {
            this.appendFrame.reset(bufferInfo.getBuffer());
            this.appender.reset((IFrame)this.appendFrame, false);
        }
        if (!this.appender.cancelAppend()) {
            throw new HyracksDataException("Undoing the last insertion in the given frame couldn't be done.");
        }
    }

    private int getLastBufferOrCreateNewIfNotExist(int partition, int actualSize) throws HyracksDataException {
        if (this.partitionArray[partition] == null || this.partitionArray[partition].getNumFrames() == 0) {
            this.partitionArray[partition] = new FrameBufferManager();
            return this.createNewBuffer(partition, actualSize);
        }
        return this.getLastBuffer(partition);
    }

    private int getLastBuffer(int partition) throws HyracksDataException {
        return this.partitionArray[partition].getNumFrames() - 1;
    }

    @Override
    public void close() {
        for (IFrameBufferManager part : this.partitionArray) {
            if (part == null) continue;
            part.close();
        }
        this.framePool.close();
        Arrays.fill(this.partitionArray, null);
    }

    @Override
    public ITuplePointerAccessor getTuplePointerAccessor(final RecordDescriptor recordDescriptor) {
        return new AbstractTuplePointerAccessor(){
            FrameTupleAccessor innerAccessor;
            {
                this.innerAccessor = new FrameTupleAccessor(recordDescriptor);
            }

            @Override
            IFrameTupleAccessor getInnerAccessor() {
                return this.innerAccessor;
            }

            @Override
            void resetInnerAccessor(TuplePointer tuplePointer) {
                VPartitionTupleBufferManager.this.partitionArray[VPartitionTupleBufferManager.this.parsePartitionId(tuplePointer.getFrameIndex())].getFrame(VPartitionTupleBufferManager.this.parseFrameIdInPartition(tuplePointer.getFrameIndex()), VPartitionTupleBufferManager.this.tempInfo);
                this.innerAccessor.reset(VPartitionTupleBufferManager.this.tempInfo.getBuffer(), VPartitionTupleBufferManager.this.tempInfo.getStartOffset(), VPartitionTupleBufferManager.this.tempInfo.getLength());
            }
        };
    }

    @Override
    public void flushPartition(int pid, IFrameWriter writer) throws HyracksDataException {
        IFrameBufferManager partition = this.partitionArray[pid];
        if (partition != null && this.getNumTuples(pid) > 0) {
            for (int i = 0; i < partition.getNumFrames(); ++i) {
                partition.getFrame(i, this.tempInfo);
                this.tempInfo.getBuffer().position(this.tempInfo.getStartOffset());
                this.tempInfo.getBuffer().limit(this.tempInfo.getStartOffset() + this.tempInfo.getLength());
                writer.nextFrame(this.tempInfo.getBuffer());
            }
        }
    }
}

