/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.buffermanager;

import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hyracks.dataflow.std.buffermanager.IFrameFreeSlotPolicy;

class FrameFreeSlotSmallestFit
implements IFrameFreeSlotPolicy {
    private TreeMap<Integer, LinkedList<Integer>> freeSpaceIndex = new TreeMap();

    @Override
    public int popBestFit(int tobeInsertedSize) {
        Map.Entry<Integer, LinkedList<Integer>> entry = this.freeSpaceIndex.ceilingEntry(tobeInsertedSize);
        if (entry == null) {
            return -1;
        }
        int id = entry.getValue().removeFirst();
        if (entry.getValue().isEmpty()) {
            this.freeSpaceIndex.remove(entry.getKey());
        }
        return id;
    }

    @Override
    public void pushNewFrame(int frameID, int freeSpace) {
        Map.Entry<Integer, LinkedList<Integer>> entry = this.freeSpaceIndex.ceilingEntry(freeSpace);
        if (entry == null || entry.getKey() != freeSpace) {
            LinkedList<Integer> linkedList = new LinkedList<Integer>();
            linkedList.add(frameID);
            this.freeSpaceIndex.put(freeSpace, linkedList);
        } else {
            entry.getValue().add(frameID);
        }
    }

    @Override
    public void reset() {
        this.freeSpaceIndex.clear();
    }
}

