/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.messaging;

import io.netty.util.collection.LongObjectHashMap;
import io.netty.util.collection.LongObjectMap;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.config.MessagingProperties;
import org.apache.asterix.common.memory.ConcurrentFramePool;
import org.apache.asterix.common.messaging.api.ICcAddressedMessage;
import org.apache.asterix.common.messaging.api.INCMessageBroker;
import org.apache.asterix.common.messaging.api.INcAddressedMessage;
import org.apache.asterix.common.messaging.api.MessageFuture;
import org.apache.hyracks.api.comm.IChannelControlBlock;
import org.apache.hyracks.api.control.CcId;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.messages.IMessage;
import org.apache.hyracks.api.util.JavaSerializationUtils;
import org.apache.hyracks.control.nc.NodeControllerService;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NCMessageBroker
implements INCMessageBroker {
    private static final Logger LOGGER = LogManager.getLogger();
    private final NodeControllerService ncs;
    private final INcApplicationContext appContext;
    private final LinkedBlockingQueue<INcAddressedMessage> receivedMsgsQ;
    private final ConcurrentFramePool messagingFramePool;
    private final int maxMsgSize;
    private final AtomicLong futureIdGenerator;
    private final LongObjectMap<MessageFuture> futureMap;

    public NCMessageBroker(NodeControllerService ncs, MessagingProperties messagingProperties) {
        this.ncs = ncs;
        this.appContext = (INcApplicationContext)ncs.getApplicationContext();
        this.maxMsgSize = messagingProperties.getFrameSize();
        int messagingMemoryBudget = messagingProperties.getFrameSize() * messagingProperties.getFrameCount();
        this.messagingFramePool = new ConcurrentFramePool(ncs.getId(), (long)messagingMemoryBudget, messagingProperties.getFrameSize());
        this.receivedMsgsQ = new LinkedBlockingQueue();
        this.futureIdGenerator = new AtomicLong();
        this.futureMap = new LongObjectHashMap();
        MessageDeliveryService msgDeliverySvc = new MessageDeliveryService();
        this.appContext.getThreadExecutor().execute(msgDeliverySvc);
    }

    public void sendMessageToCC(CcId ccId, ICcAddressedMessage message) throws Exception {
        this.ncs.sendApplicationMessageToCC(ccId, JavaSerializationUtils.serialize((Serializable)message), null);
    }

    public void sendMessageToPrimaryCC(ICcAddressedMessage message) throws Exception {
        this.sendMessageToCC(this.ncs.getPrimaryCcId(), message);
    }

    public void sendMessageToNC(String nodeId, INcAddressedMessage message) throws Exception {
        IChannelControlBlock messagingChannel = this.ncs.getMessagingNetworkManager().getMessagingChannel(nodeId);
        this.sendMessageToChannel(messagingChannel, message);
    }

    public void queueReceivedMessage(INcAddressedMessage msg) {
        this.receivedMsgsQ.offer(msg);
    }

    public void receivedMessage(IMessage message, String nodeId) throws Exception {
        INcAddressedMessage absMessage = (INcAddressedMessage)message;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Received message: " + absMessage);
        }
        this.ncs.getExecutor().submit(() -> {
            try {
                absMessage.handle(this.appContext);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARN, "Could not process message: {}", (Object)message, (Object)e);
            }
        });
    }

    public ConcurrentFramePool getMessagingFramePool() {
        return this.messagingFramePool;
    }

    private void sendMessageToChannel(IChannelControlBlock ccb, INcAddressedMessage msg) throws IOException {
        byte[] serializedMsg = JavaSerializationUtils.serialize((Serializable)msg);
        if (serializedMsg.length > this.maxMsgSize) {
            throw new HyracksDataException("Message exceeded maximum size");
        }
        ByteBuffer msgBuffer = this.messagingFramePool.get();
        if (msgBuffer == null) {
            throw new HyracksDataException("Could not get an empty buffer");
        }
        msgBuffer.clear();
        msgBuffer.put(serializedMsg);
        msgBuffer.flip();
        ccb.getWriteInterface().getFullBufferAcceptor().accept(msgBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageFuture registerMessageFuture() {
        long futureId = this.futureIdGenerator.incrementAndGet();
        MessageFuture future = new MessageFuture(futureId);
        LongObjectMap<MessageFuture> longObjectMap = this.futureMap;
        synchronized (longObjectMap) {
            if (this.futureMap.containsKey(futureId)) {
                throw new IllegalStateException();
            }
            this.futureMap.put(futureId, (Object)future);
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageFuture deregisterMessageFuture(long futureId) {
        LongObjectMap<MessageFuture> longObjectMap = this.futureMap;
        synchronized (longObjectMap) {
            return (MessageFuture)this.futureMap.remove(futureId);
        }
    }

    private class MessageDeliveryService
    implements Runnable {
        private MessageDeliveryService() {
        }

        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                INcAddressedMessage msg = null;
                try {
                    msg = (INcAddressedMessage)NCMessageBroker.this.receivedMsgsQ.take();
                    NCMessageBroker.this.receivedMessage((IMessage)msg, null);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception e) {
                    if (LOGGER.isWarnEnabled() && msg != null) {
                        LOGGER.log(Level.WARN, "Could not process message : " + msg, (Throwable)e);
                        continue;
                    }
                    if (!LOGGER.isWarnEnabled()) continue;
                    LOGGER.log(Level.WARN, "Could not process message", (Throwable)e);
                }
            }
        }
    }
}

