/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.hyracks.bootstrap;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import org.apache.asterix.api.http.server.StorageApiServlet;
import org.apache.asterix.app.io.PersistedResourceRegistry;
import org.apache.asterix.app.nc.NCAppRuntimeContext;
import org.apache.asterix.app.nc.RecoveryManager;
import org.apache.asterix.app.replication.message.RegistrationTasksRequestMessage;
import org.apache.asterix.common.api.AsterixThreadFactory;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.api.IPropertiesFactory;
import org.apache.asterix.common.config.AsterixExtension;
import org.apache.asterix.common.config.ExternalProperties;
import org.apache.asterix.common.config.MessagingProperties;
import org.apache.asterix.common.config.MetadataProperties;
import org.apache.asterix.common.config.NodeProperties;
import org.apache.asterix.common.config.PropertiesAccessor;
import org.apache.asterix.common.config.PropertiesFactory;
import org.apache.asterix.common.config.StorageProperties;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.transactions.Checkpoint;
import org.apache.asterix.common.transactions.IRecoveryManager;
import org.apache.asterix.common.transactions.IRecoveryManagerFactory;
import org.apache.asterix.common.utils.PrintUtil;
import org.apache.asterix.common.utils.StoragePathUtil;
import org.apache.asterix.hyracks.bootstrap.ApplicationConfigurator;
import org.apache.asterix.messaging.MessagingChannelInterfaceFactory;
import org.apache.asterix.messaging.NCMessageBroker;
import org.apache.asterix.transaction.management.resource.PersistentLocalResourceRepository;
import org.apache.asterix.util.MetadataBuiltinFunctions;
import org.apache.hyracks.api.application.INCServiceContext;
import org.apache.hyracks.api.application.IServiceContext;
import org.apache.hyracks.api.client.NodeStatus;
import org.apache.hyracks.api.comm.IChannelInterfaceFactory;
import org.apache.hyracks.api.config.IApplicationConfig;
import org.apache.hyracks.api.config.IConfigManager;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.api.control.CcId;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IFileDeviceResolver;
import org.apache.hyracks.api.io.IODeviceHandle;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;
import org.apache.hyracks.api.job.resource.NodeCapacity;
import org.apache.hyracks.api.messages.IMessageBroker;
import org.apache.hyracks.control.common.controllers.NCConfig;
import org.apache.hyracks.control.nc.BaseNCApplication;
import org.apache.hyracks.control.nc.NodeControllerService;
import org.apache.hyracks.http.api.IServlet;
import org.apache.hyracks.http.server.HttpServer;
import org.apache.hyracks.http.server.HttpServerConfig;
import org.apache.hyracks.http.server.HttpServerConfigBuilder;
import org.apache.hyracks.http.server.WebManager;
import org.apache.hyracks.util.LoggingConfigUtil;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NCApplication
extends BaseNCApplication {
    private static final Logger LOGGER = LogManager.getLogger();
    protected INCServiceContext ncServiceCtx;
    private INcApplicationContext runtimeContext;
    private String nodeId;
    private boolean stopInitiated;
    private boolean startupCompleted;
    protected WebManager webManager;

    public void registerConfig(IConfigManager configManager) {
        super.registerConfig(configManager);
        ApplicationConfigurator.registerConfigOptions(configManager);
    }

    public void init(IServiceContext serviceCtx) throws Exception {
        this.ncServiceCtx = (INCServiceContext)serviceCtx;
        ((NodeControllerService)serviceCtx.getControllerService()).setNodeStatus(NodeStatus.IDLE);
        this.ncServiceCtx.setThreadFactory((ThreadFactory)new AsterixThreadFactory(this.ncServiceCtx.getThreadFactory(), this.ncServiceCtx.getLifeCycleComponentManager()));
        this.validateEnvironment();
        this.configurePersistedResourceRegistry();
    }

    public void start(String[] args) throws Exception {
        if (args.length > 0) {
            throw new IllegalArgumentException("Unrecognized argument(s): " + Arrays.toString(args));
        }
        this.nodeId = this.ncServiceCtx.getNodeId();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Starting Asterix node controller: " + this.nodeId);
        }
        this.configureLoggingLevel(this.ncServiceCtx.getAppConfig().getLoggingLevel((IOption)ExternalProperties.Option.LOG_LEVEL));
        NodeControllerService controllerService = (NodeControllerService)this.ncServiceCtx.getControllerService();
        if (System.getProperty("java.rmi.server.hostname") == null) {
            System.setProperty("java.rmi.server.hostname", controllerService.getConfiguration().getClusterPublicAddress());
        }
        MetadataBuiltinFunctions.init();
        this.runtimeContext = new NCAppRuntimeContext(this.ncServiceCtx, this.getExtensions(), this.getPropertiesFactory());
        MetadataProperties metadataProperties = this.runtimeContext.getMetadataProperties();
        if (!metadataProperties.getNodeNames().contains(this.ncServiceCtx.getNodeId())) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Substitute node joining : " + this.ncServiceCtx.getNodeId());
            }
            this.updateOnNodeJoin();
        }
        this.runtimeContext.initialize(this.getRecoveryManagerFactory(), this.runtimeContext.getNodeProperties().isInitialRun());
        MessagingProperties messagingProperties = this.runtimeContext.getMessagingProperties();
        NCMessageBroker messageBroker = new NCMessageBroker(controllerService, messagingProperties);
        this.ncServiceCtx.setMessageBroker((IMessageBroker)messageBroker);
        MessagingChannelInterfaceFactory interfaceFactory = new MessagingChannelInterfaceFactory(messageBroker, messagingProperties);
        this.ncServiceCtx.setMessagingChannelInterfaceFactory((IChannelInterfaceFactory)interfaceFactory);
        Checkpoint latestCheckpoint = this.runtimeContext.getTransactionSubsystem().getCheckpointManager().getLatest();
        if (latestCheckpoint != null && latestCheckpoint.getStorageVersion() != 12) {
            throw new IllegalStateException(String.format("Storage version mismatch.. Current version (%s). On disk version: (%s)", 12, latestCheckpoint.getStorageVersion()));
        }
        if (LOGGER.isInfoEnabled()) {
            IRecoveryManager recoveryMgr = this.runtimeContext.getTransactionSubsystem().getRecoveryManager();
            LOGGER.info("System state: " + recoveryMgr.getSystemState());
            LOGGER.info("Node ID: " + this.nodeId);
            LOGGER.info("Stores: " + PrintUtil.toString((Map)metadataProperties.getStores()));
        }
        this.webManager = new WebManager();
        this.performLocalCleanUp();
    }

    protected IRecoveryManagerFactory getRecoveryManagerFactory() {
        return RecoveryManager::new;
    }

    protected void configureLoggingLevel(Level level) {
        super.configureLoggingLevel(level);
        LoggingConfigUtil.defaultIfMissing((String)"org.apache.asterix", (Level)level);
    }

    protected void configureServers() throws Exception {
        ExternalProperties externalProperties = this.getApplicationContext().getExternalProperties();
        HttpServerConfig config = HttpServerConfigBuilder.custom().setMaxRequestSize(externalProperties.getMaxWebRequestSize()).build();
        HttpServer apiServer = new HttpServer(this.webManager.getBosses(), this.webManager.getWorkers(), externalProperties.getNcApiPort(), config);
        apiServer.setAttribute("org.apache.asterix.SERVICE_CONTEXT", (Object)this.ncServiceCtx);
        apiServer.addServlet((IServlet)new StorageApiServlet(apiServer.ctx(), this.getApplicationContext(), "/admin/storage/*"));
        this.webManager.add(apiServer);
    }

    protected List<AsterixExtension> getExtensions() {
        return Collections.emptyList();
    }

    protected IPropertiesFactory getPropertiesFactory() throws IOException, AsterixException {
        PropertiesAccessor propertiesAccessor = PropertiesAccessor.getInstance((IApplicationConfig)this.ncServiceCtx.getAppConfig());
        return new PropertiesFactory(propertiesAccessor);
    }

    public void stop() throws Exception {
        if (!this.stopInitiated) {
            this.runtimeContext.setShuttingdown(true);
            this.stopInitiated = true;
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Stopping Asterix node controller: " + this.nodeId);
            }
            this.webManager.stop();
            this.performLocalCleanUp();
            this.ncServiceCtx.getLifeCycleComponentManager().stopAll(false);
            this.runtimeContext.deinitialize();
        } else if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Duplicate attempt to stop ignored: " + this.nodeId);
        }
    }

    public void preStop() throws Exception {
        this.runtimeContext.preStop();
    }

    public synchronized void startupCompleted() throws Exception {
        this.configureServers();
        this.webManager.start();
        this.startupCompleted = true;
        ((Object)((Object)this)).notifyAll();
    }

    public synchronized void tasksCompleted(CcId ccId) throws Exception {
        while (!this.startupCompleted) {
            ((Object)((Object)this)).wait();
        }
        NodeControllerService ncs = (NodeControllerService)this.ncServiceCtx.getControllerService();
        NodeStatus currentStatus = ncs.getNodeStatus();
        IRecoveryManager.SystemState systemState = this.isPendingStartupTasks(currentStatus, ncs.getPrimaryCcId(), ccId) ? this.getCurrentSystemState() : IRecoveryManager.SystemState.HEALTHY;
        RegistrationTasksRequestMessage.send(ccId, (NodeControllerService)this.ncServiceCtx.getControllerService(), currentStatus, systemState);
    }

    public NodeCapacity getCapacity() {
        StorageProperties storageProperties = this.runtimeContext.getStorageProperties();
        long memorySize = storageProperties.getJobExecutionMemoryBudget();
        int allCores = Runtime.getRuntime().availableProcessors();
        return new NodeCapacity(memorySize, allCores);
    }

    private void performLocalCleanUp() throws HyracksDataException {
        this.runtimeContext.getIoManager().deleteWorkspaceFiles();
        Set nodePartitions = this.runtimeContext.getReplicaManager().getPartitions();
        PersistentLocalResourceRepository localResourceRepository = (PersistentLocalResourceRepository)this.runtimeContext.getLocalResourceRepository();
        localResourceRepository.deleteCorruptedResources();
        for (Integer partition : nodePartitions) {
            localResourceRepository.cleanup(partition.intValue());
        }
    }

    private void updateOnNodeJoin() {
        MetadataProperties metadataProperties = this.runtimeContext.getMetadataProperties();
        if (!metadataProperties.getNodeNames().contains(this.nodeId)) {
            NCConfig ncConfig = ((NodeControllerService)this.ncServiceCtx.getControllerService()).getConfiguration();
            ncConfig.getConfigManager().ensureNode(this.nodeId);
        }
    }

    public INcApplicationContext getApplicationContext() {
        return this.runtimeContext;
    }

    public IFileDeviceResolver getFileDeviceResolver() {
        return (relPath, devices) -> {
            int ioDeviceIndex = Math.abs(StoragePathUtil.getPartitionNumFromRelativePath((String)relPath) % devices.size());
            return (IODeviceHandle)devices.get(ioDeviceIndex);
        };
    }

    private boolean isPendingStartupTasks(NodeStatus nodeStatus, CcId primaryCc, CcId registeredCc) {
        return nodeStatus == NodeStatus.IDLE && (primaryCc == null || primaryCc.equals((Object)registeredCc));
    }

    private IRecoveryManager.SystemState getCurrentSystemState() {
        NodeProperties nodeProperties = this.runtimeContext.getNodeProperties();
        IRecoveryManager recoveryMgr = this.runtimeContext.getTransactionSubsystem().getRecoveryManager();
        IRecoveryManager.SystemState state = recoveryMgr.getSystemState();
        if (state == IRecoveryManager.SystemState.PERMANENT_DATA_LOSS && (nodeProperties.isInitialRun() || nodeProperties.isVirtualNc())) {
            state = IRecoveryManager.SystemState.BOOTSTRAPPING;
        }
        return state;
    }

    protected void validateEnvironment() throws HyracksDataException {
        this.validateJavaRuntime();
    }

    protected void validateJavaRuntime() throws HyracksDataException {
        ApplicationConfigurator.validateJavaRuntime();
    }

    protected void configurePersistedResourceRegistry() {
        this.ncServiceCtx.setPersistedResourceRegistry((IPersistedResourceRegistry)new PersistedResourceRegistry());
    }
}

