/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.function;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.metadata.declared.FunctionDataSource;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.functions.IFunctionToDataSourceRewriter;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.optimizer.rules.UnnestToDataScanRule;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSource;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;

public abstract class FunctionRewriter
implements IFunctionToDataSourceRewriter {
    private FunctionIdentifier functionId;

    public FunctionRewriter(FunctionIdentifier functionId) {
        this.functionId = functionId;
    }

    public final boolean rewrite(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractFunctionCallExpression f = UnnestToDataScanRule.getFunctionCall(opRef);
        List args = f.getArguments();
        if (args.size() != this.functionId.getArity()) {
            throw new CompilationException(1079, f.getSourceLocation(), new Serializable[]{"Function " + this.functionId.getNamespace() + "." + this.functionId.getName() + " expects " + this.functionId.getArity() + " arguments"});
        }
        for (int i = 0; i < args.size(); ++i) {
            ILogicalExpression argExpr = (ILogicalExpression)((Mutable)args.get(i)).getValue();
            if (argExpr.getExpressionTag() == LogicalExpressionTag.CONSTANT) continue;
            throw new CompilationException(1079, argExpr.getSourceLocation(), new Serializable[]{"Function " + this.functionId.getNamespace() + "." + this.functionId.getName() + " expects constant arguments while arg[" + i + "] is of type " + argExpr.getExpressionTag()});
        }
        UnnestOperator unnest = (UnnestOperator)opRef.getValue();
        if (unnest.getPositionalVariable() != null) {
            throw new CompilationException(1079, unnest.getSourceLocation(), new Serializable[]{"No positional variables are allowed over datasource functions"});
        }
        FunctionDataSource datasource = this.toDatasource(context, f);
        ArrayList<LogicalVariable> variables = new ArrayList<LogicalVariable>();
        variables.add(unnest.getVariable());
        DataSourceScanOperator scan = new DataSourceScanOperator(variables, (IDataSource)datasource);
        scan.setSourceLocation(unnest.getSourceLocation());
        List scanInpList = scan.getInputs();
        scanInpList.addAll(unnest.getInputs());
        opRef.setValue((Object)scan);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)scan);
        return true;
    }

    protected abstract FunctionDataSource toDatasource(IOptimizationContext var1, AbstractFunctionCallExpression var2) throws AlgebricksException;

    protected String getString(List<Mutable<ILogicalExpression>> args, int i) throws AlgebricksException {
        ConstantExpression ce = (ConstantExpression)args.get(i).getValue();
        IAlgebricksConstantValue acv = ce.getValue();
        if (!(acv instanceof AsterixConstantValue)) {
            throw new AlgebricksException("Expected arg[" + i + "] to be of type String");
        }
        AsterixConstantValue acv2 = (AsterixConstantValue)acv;
        if (acv2.getObject().getType().getTypeTag() != ATypeTag.STRING) {
            throw new AlgebricksException("Expected arg[" + i + "] to be of type String");
        }
        return ((AString)acv2.getObject()).getStringValue();
    }
}

