/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.api.http.server;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Date;
import java.util.concurrent.ConcurrentMap;
import org.apache.asterix.common.api.IClusterManagementWork;
import org.apache.asterix.common.cluster.IClusterStateManager;
import org.apache.asterix.common.config.GlobalConfig;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.http.api.IServletRequest;
import org.apache.hyracks.http.api.IServletResponse;
import org.apache.hyracks.http.server.AbstractServlet;
import org.apache.hyracks.http.server.utils.HttpUtil;
import org.apache.hyracks.util.JSONUtil;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShutdownApiServlet
extends AbstractServlet {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String NODE_ID_KEY = "node_id";
    public static final String NCSERVICE_PID = "ncservice_pid";
    public static final String INI = "ini";
    public static final String PID = "pid";
    private final ICcApplicationContext appCtx;

    public ShutdownApiServlet(ICcApplicationContext appCtx, ConcurrentMap<String, Object> ctx, String[] paths) {
        super(ctx, paths);
        this.appCtx = appCtx;
    }

    protected void post(IServletRequest request, IServletResponse response) {
        IHyracksClientConnection hcc = (IHyracksClientConnection)this.ctx.get("org.apache.asterix.HYRACKS_CONNECTION");
        IClusterStateManager csm = this.appCtx.getClusterStateManager();
        boolean terminateNCServices = "true".equalsIgnoreCase(request.getParameter((CharSequence)"all"));
        Thread t = new Thread(() -> {
            try {
                hcc.stopCluster(terminateNCServices);
            }
            catch (Exception e) {
                GlobalConfig.ASTERIX_LOGGER.log(Level.ERROR, "Exception stopping cluster", (Throwable)e);
            }
        }, "Shutdown Servlet Worker");
        try {
            HttpUtil.setContentType((IServletResponse)response, (String)"application/json", (String)"utf-8");
        }
        catch (IOException e) {
            LOGGER.log(Level.WARN, "Failure handling request", (Throwable)e);
            response.setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
            return;
        }
        response.setStatus(HttpResponseStatus.ACCEPTED);
        ObjectNode jsonObject = OBJECT_MAPPER.createObjectNode();
        try {
            jsonObject.put("status", "SHUTTING_DOWN");
            jsonObject.put("date", new Date().toString());
            ObjectNode clusterState = csm.getClusterStateDescription();
            ArrayNode ncs = (ArrayNode)clusterState.get("ncs");
            for (int i = 0; i < ncs.size(); ++i) {
                ObjectNode nc = (ObjectNode)ncs.get(i);
                String node = nc.get(NODE_ID_KEY).asText();
                String detailsString = hcc.getNodeDetailsJSON(node, false, true);
                if (detailsString != null) {
                    ObjectNode details = (ObjectNode)OBJECT_MAPPER.readTree(detailsString);
                    nc.set(PID, details.get(PID));
                    if (!details.has(INI) || !details.get(INI).has(NCSERVICE_PID)) continue;
                    nc.put(NCSERVICE_PID, details.get(INI).get(NCSERVICE_PID).asInt());
                    continue;
                }
                LOGGER.warn("Unable to get node details for " + node + " from hcc");
            }
            jsonObject.set("cluster", (JsonNode)clusterState);
            PrintWriter writer = response.writer();
            JSONUtil.writeNode((Writer)writer, (JsonNode)jsonObject);
            csm.setState(IClusterManagementWork.ClusterState.SHUTTING_DOWN);
            writer.close();
        }
        catch (Exception e) {
            GlobalConfig.ASTERIX_LOGGER.log(Level.INFO, "Exception writing response", (Throwable)e);
        }
        t.start();
    }
}

