/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.api.http.server;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.util.concurrent.ConcurrentMap;
import org.apache.asterix.api.http.server.QueryServiceServlet;
import org.apache.asterix.common.api.IClientRequest;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.translator.IStatementExecutorContext;
import org.apache.hyracks.http.api.IServletRequest;
import org.apache.hyracks.http.api.IServletResponse;
import org.apache.hyracks.http.server.AbstractServlet;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CcQueryCancellationServlet
extends AbstractServlet {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ICcApplicationContext appCtx;

    public CcQueryCancellationServlet(ConcurrentMap<String, Object> ctx, ICcApplicationContext appCtx, String ... paths) {
        super(ctx, paths);
        this.appCtx = appCtx;
    }

    protected void delete(IServletRequest request, IServletResponse response) throws IOException {
        String clientContextId = request.getParameter((CharSequence)QueryServiceServlet.Parameter.CLIENT_ID.str());
        if (clientContextId == null) {
            response.setStatus(HttpResponseStatus.BAD_REQUEST);
            return;
        }
        IStatementExecutorContext executorCtx = (IStatementExecutorContext)this.ctx.get("org.apache.asterix.RUNINNG_QUERIES");
        IClientRequest req = executorCtx.get(clientContextId);
        if (req == null) {
            response.setStatus(HttpResponseStatus.NOT_FOUND);
            return;
        }
        try {
            req.cancel(this.appCtx);
            response.setStatus(HttpResponseStatus.OK);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARN, "unexpected exception thrown from cancel", (Throwable)e);
            response.setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
    }
}

