/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.api.http.server;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import org.apache.asterix.api.http.server.ResultUtil;
import org.apache.asterix.api.http.server.ServletUtil;
import org.apache.asterix.common.api.IApplicationContext;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.api.result.IResultSet;
import org.apache.hyracks.http.server.AbstractServlet;
import org.apache.hyracks.ipc.exceptions.IPCException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AbstractQueryApiServlet
extends AbstractServlet {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final IApplicationContext appCtx;

    AbstractQueryApiServlet(IApplicationContext appCtx, ConcurrentMap<String, Object> ctx, String[] paths) {
        super(ctx, paths);
        this.appCtx = appCtx;
    }

    protected IResultSet getResultSet() throws Exception {
        try {
            return ServletUtil.getResultSet(this.getHyracksClientConnection(), this.appCtx, this.ctx);
        }
        catch (IPCException e) {
            LOGGER.log(Level.WARN, "Failed getting hyracks dataset connection. Resetting hyracks connection.", (Throwable)e);
            this.ctx.put("org.apache.asterix.HYRACKS_CONNECTION", this.appCtx.getHcc());
            return ServletUtil.getResultSet(this.getHyracksClientConnection(), this.appCtx, this.ctx);
        }
    }

    protected IHyracksClientConnection getHyracksClientConnection() throws Exception {
        IHyracksClientConnection hcc = (IHyracksClientConnection)this.ctx.get("org.apache.asterix.HYRACKS_CONNECTION");
        if (hcc == null) {
            throw new RuntimeDataException(14, new Serializable[]{"org.apache.asterix.HYRACKS_CONNECTION"});
        }
        return hcc;
    }

    protected static UUID printRequestId(PrintWriter pw) {
        UUID requestId = UUID.randomUUID();
        ResultUtil.printField(pw, ResultFields.REQUEST_ID.str(), requestId.toString());
        return requestId;
    }

    protected static void printHandle(PrintWriter pw, String handle, boolean comma) {
        ResultUtil.printField(pw, ResultFields.HANDLE.str(), handle, comma);
    }

    public static enum ErrorField {
        CODE("code"),
        MSG("msg"),
        STACK("stack");

        private final String str;

        private ErrorField(String str) {
            this.str = str;
        }

        public String str() {
            return this.str;
        }
    }

    public static enum ResultStatus {
        RUNNING("running"),
        SUCCESS("success"),
        TIMEOUT("timeout"),
        FAILED("failed"),
        FATAL("fatal");

        private final String str;

        private ResultStatus(String str) {
            this.str = str;
        }

        public String str() {
            return this.str;
        }
    }

    public static enum ResultFields {
        REQUEST_ID("requestID"),
        CLIENT_ID("clientContextID"),
        SIGNATURE("signature"),
        TYPE("type"),
        STATUS("status"),
        RESULTS("results"),
        HANDLE("handle"),
        ERRORS("errors"),
        METRICS("metrics"),
        PLANS("plans"),
        WARNINGS("warnings");

        private final String str;

        private ResultFields(String str) {
            this.str = str;
        }

        public String str() {
            return this.str;
        }
    }
}

