/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.parser;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TreeTraversingParser;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.BitSet;
import org.apache.asterix.builders.IARecordBuilder;
import org.apache.asterix.builders.IAsterixListBuilder;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.external.api.IRawRecord;
import org.apache.asterix.external.api.IRecordDataParser;
import org.apache.asterix.external.api.IStreamDataParser;
import org.apache.asterix.external.parser.AbstractNestedDataParser;
import org.apache.asterix.external.parser.jackson.ADMToken;
import org.apache.asterix.external.parser.jackson.GeometryCoParser;
import org.apache.asterix.external.parser.jackson.ParserContext;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.base.ANull;
import org.apache.asterix.om.base.AUnorderedList;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.RecordUtil;
import org.apache.asterix.runtime.exceptions.UnsupportedTypeException;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IMutableValueStorage;
import org.apache.hyracks.data.std.api.IValueReference;

public class JSONDataParser
extends AbstractNestedDataParser<ADMToken>
implements IStreamDataParser,
IRecordDataParser<char[]> {
    protected final ParserContext parserContext;
    protected final JsonFactory jsonFactory;
    protected final ARecordType rootType;
    protected final GeometryCoParser geometryCoParser;
    protected JsonParser jsonParser;

    public JSONDataParser(ARecordType recordType, JsonFactory jsonFactory) {
        this.rootType = recordType != null ? recordType : RecordUtil.FULLY_OPEN_RECORD_TYPE;
        this.jsonFactory = jsonFactory;
        this.geometryCoParser = new GeometryCoParser(this.jsonParser);
        this.parserContext = new ParserContext();
    }

    @Override
    public final void parse(IRawRecord<? extends char[]> record, DataOutput out) throws HyracksDataException {
        try {
            this.jsonParser = this.jsonFactory.createParser(record.get(), 0, record.size());
            this.geometryCoParser.reset(this.jsonParser);
            this.nextToken();
            this.parseObject(this.rootType, out);
        }
        catch (IOException e) {
            throw new RuntimeDataException(3021, (Throwable)e, new Serializable[0]);
        }
    }

    @Override
    public void setInputStream(InputStream in) throws IOException {
        this.setInput(this.jsonFactory.createParser(in));
    }

    public void setInputNode(JsonNode node) {
        this.setInput((JsonParser)new TreeTraversingParser(node));
    }

    private void setInput(JsonParser parser) {
        this.jsonParser = parser;
        this.geometryCoParser.reset(this.jsonParser);
    }

    @Override
    public boolean parse(DataOutput out) throws HyracksDataException {
        try {
            if (this.nextToken() == ADMToken.EOF) {
                return false;
            }
            this.parseObject(this.rootType, out);
            return true;
        }
        catch (IOException e) {
            throw new RuntimeDataException(3021, (Throwable)e, new Serializable[0]);
        }
    }

    public boolean parseAnyValue(DataOutput out) throws HyracksDataException {
        try {
            if (this.nextToken() == ADMToken.EOF) {
                return false;
            }
            this.parseValue((IAType)BuiltinType.ANY, out);
            return true;
        }
        catch (IOException e) {
            throw new RuntimeDataException(3021, (Throwable)e, new Serializable[0]);
        }
    }

    @Override
    public boolean reset(InputStream in) throws IOException {
        this.setInputStream(in);
        return true;
    }

    @Override
    protected final ADMToken advanceToNextToken() throws IOException {
        ADMToken token;
        JsonToken jsonToken = this.jsonParser.nextToken();
        if (jsonToken == null) {
            return ADMToken.EOF;
        }
        switch (jsonToken) {
            case VALUE_FALSE: {
                token = ADMToken.FALSE;
                break;
            }
            case VALUE_TRUE: {
                token = ADMToken.TRUE;
                break;
            }
            case VALUE_STRING: {
                token = ADMToken.STRING;
                break;
            }
            case VALUE_NULL: {
                token = ADMToken.NULL;
                break;
            }
            case VALUE_NUMBER_FLOAT: {
                token = ADMToken.DOUBLE;
                break;
            }
            case VALUE_NUMBER_INT: {
                token = ADMToken.INT;
                break;
            }
            case START_OBJECT: {
                token = ADMToken.OBJECT_START;
                break;
            }
            case END_OBJECT: {
                token = ADMToken.OBJECT_END;
                break;
            }
            case START_ARRAY: {
                token = ADMToken.ARRAY_START;
                break;
            }
            case END_ARRAY: {
                token = ADMToken.ARRAY_END;
                break;
            }
            case FIELD_NAME: {
                token = ADMToken.FIELD_NAME;
                break;
            }
            default: {
                throw new RuntimeDataException(4, new Serializable[]{this.jsonParser.currentToken().toString()});
            }
        }
        return token;
    }

    @Override
    protected boolean isConvertable(ATypeTag parsedTypeTag, ATypeTag definedTypeTag) {
        if (parsedTypeTag == ATypeTag.OBJECT && (definedTypeTag == ATypeTag.POINT || definedTypeTag == ATypeTag.LINE || definedTypeTag == ATypeTag.POLYGON)) {
            return true;
        }
        return super.isConvertable(parsedTypeTag, definedTypeTag);
    }

    @Override
    protected final void parseObject(ARecordType recordType, DataOutput out) throws IOException {
        IMutableValueStorage valueBuffer = this.parserContext.enterObject();
        IARecordBuilder objectBuilder = this.parserContext.getObjectBuilder(recordType);
        BitSet nullBitMap = this.parserContext.getNullBitmap(recordType.getFieldTypes().length);
        while (this.nextToken() != ADMToken.OBJECT_END) {
            String fieldName = this.jsonParser.getCurrentName();
            int fieldIndex = recordType.getFieldIndex(fieldName);
            if (!recordType.isOpen() && fieldIndex < 0) {
                throw new RuntimeDataException(3058, new Serializable[]{fieldName});
            }
            valueBuffer.reset();
            this.nextToken();
            if (fieldIndex < 0) {
                this.parseValue((IAType)BuiltinType.ANY, valueBuffer.getDataOutput());
                objectBuilder.addField((IValueReference)this.parserContext.getSerializedFieldName(fieldName), (IValueReference)valueBuffer);
                continue;
            }
            IAType fieldType = recordType.getFieldType(fieldName);
            if (this.currentToken() == ADMToken.NULL && !this.isNullableType(fieldType)) {
                throw new RuntimeDataException(3075, new Serializable[]{fieldName});
            }
            nullBitMap.set(fieldIndex);
            this.parseValue(fieldType, valueBuffer.getDataOutput());
            objectBuilder.addField(fieldIndex, (IValueReference)valueBuffer);
        }
        if (nullBitMap != null) {
            this.checkOptionalConstraints(recordType, nullBitMap);
        }
        this.parserContext.exitObject(valueBuffer, nullBitMap, objectBuilder);
        objectBuilder.write(out, true);
    }

    private void parseGeometry(ATypeTag typeTag, DataOutput out) throws IOException {
        this.geometryCoParser.starGeometry();
        while (this.nextToken() != ADMToken.OBJECT_END) {
            if (this.currentToken() == ADMToken.FIELD_NAME) {
                this.geometryCoParser.checkFieldName(this.jsonParser.getCurrentName());
                continue;
            }
            if (this.geometryCoParser.checkValue((ADMToken)((Object)this.currentToken()))) continue;
            throw new IOException(this.geometryCoParser.getErrorMessage());
        }
        this.geometryCoParser.serialize(typeTag, out);
    }

    @Override
    protected final void parseArray(AOrderedListType listType, DataOutput out) throws IOException {
        this.parseCollection((AbstractCollectionType)listType, ADMToken.ARRAY_END, out);
    }

    @Override
    protected void parseMultiset(AUnorderedList listType, DataOutput out) throws IOException {
        throw new UnsupportedTypeException("JSON parser", ATypeTag.SERIALIZED_UNORDEREDLIST_TYPE_TAG);
    }

    protected final void parseCollection(AbstractCollectionType collectionType, ADMToken endToken, DataOutput out) throws IOException {
        boolean isOpen;
        IMutableValueStorage valueBuffer = this.parserContext.enterCollection();
        IAsterixListBuilder arrayBuilder = this.parserContext.getCollectionBuilder(collectionType);
        boolean bl = isOpen = collectionType.getItemType().getTypeTag() == ATypeTag.ANY;
        while (this.nextToken() != endToken) {
            valueBuffer.reset();
            if (isOpen) {
                this.parseValue((IAType)BuiltinType.ANY, valueBuffer.getDataOutput());
            } else {
                if (this.currentToken() == ADMToken.NULL) {
                    throw new RuntimeDataException(3112, new Serializable[0]);
                }
                this.parseValue(collectionType.getItemType(), valueBuffer.getDataOutput());
            }
            arrayBuilder.addItem((IValueReference)valueBuffer);
        }
        this.parserContext.exitCollection(valueBuffer, arrayBuilder);
        arrayBuilder.write(out, true);
    }

    private void parseObject(IAType actualType, DataOutput out) throws IOException {
        if (actualType.getTypeTag() == ATypeTag.OBJECT) {
            this.parseObject((ARecordType)actualType, out);
        } else {
            this.parseGeometry(actualType.getTypeTag(), out);
        }
    }

    protected void parseValue(IAType definedType, DataOutput out) throws IOException {
        ATypeTag currentTypeTag = ((ADMToken)((Object)this.currentToken())).getTypeTag();
        IAType actualType = this.checkAndGetType(definedType, currentTypeTag);
        switch ((ADMToken)((Object)this.currentToken())) {
            case NULL: {
                this.nullSerde.serialize((Object)ANull.NULL, out);
                break;
            }
            case FALSE: {
                this.booleanSerde.serialize((Object)ABoolean.FALSE, out);
                break;
            }
            case TRUE: {
                this.booleanSerde.serialize((Object)ABoolean.TRUE, out);
                break;
            }
            case INT: 
            case DOUBLE: {
                this.serailizeNumeric(actualType.getTypeTag(), out);
                break;
            }
            case STRING: {
                this.serializeString(actualType.getTypeTag(), out);
                break;
            }
            case OBJECT_START: {
                this.parseObject(actualType, out);
                break;
            }
            case ARRAY_START: {
                this.parseArray((AOrderedListType)actualType, out);
                break;
            }
            default: {
                throw new RuntimeDataException(1001, new Serializable[]{this.jsonParser.currentToken().toString()});
            }
        }
    }

    private void serailizeNumeric(ATypeTag numericType, DataOutput out) throws IOException {
        ATypeTag typeToUse = numericType == ATypeTag.ANY ? ((ADMToken)((Object)this.currentToken())).getTypeTag() : numericType;
        switch (typeToUse) {
            case BIGINT: {
                this.aInt64.setValue(this.jsonParser.getLongValue());
                this.int64Serde.serialize((Object)this.aInt64, out);
                break;
            }
            case INTEGER: {
                this.aInt32.setValue(this.jsonParser.getIntValue());
                this.int32Serde.serialize((Object)this.aInt32, out);
                break;
            }
            case SMALLINT: {
                this.aInt16.setValue(this.jsonParser.getShortValue());
                this.int16Serde.serialize((Object)this.aInt16, out);
                break;
            }
            case TINYINT: {
                this.aInt8.setValue(this.jsonParser.getByteValue());
                this.int8Serde.serialize((Object)this.aInt8, out);
                break;
            }
            case DOUBLE: {
                this.aDouble.setValue(this.jsonParser.getDoubleValue());
                this.doubleSerde.serialize((Object)this.aDouble, out);
                break;
            }
            case FLOAT: {
                this.aFloat.setValue(this.jsonParser.getFloatValue());
                this.floatSerde.serialize((Object)this.aFloat, out);
                break;
            }
            default: {
                throw new RuntimeDataException(4, new Serializable[]{this.jsonParser.currentToken().toString()});
            }
        }
    }

    private void serializeString(ATypeTag stringVariantType, DataOutput out) throws IOException {
        char[] buffer = this.jsonParser.getTextCharacters();
        int begin = this.jsonParser.getTextOffset();
        int len = this.jsonParser.getTextLength();
        ATypeTag typeToUse = stringVariantType == ATypeTag.ANY ? ((ADMToken)((Object)this.currentToken())).getTypeTag() : stringVariantType;
        switch (typeToUse) {
            case STRING: {
                this.parseString(buffer, begin, len, out);
                break;
            }
            case DATE: {
                this.parseDate(buffer, begin, len, out);
                break;
            }
            case DATETIME: {
                this.parseDateTime(buffer, begin, len, out);
                break;
            }
            case TIME: {
                this.parseTime(buffer, begin, len, out);
                break;
            }
            default: {
                throw new RuntimeDataException(4, new Serializable[]{this.jsonParser.currentToken().toString()});
            }
        }
    }
}

