/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.library.java.base;

import java.io.DataOutput;
import java.util.List;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.external.api.IJObject;
import org.apache.asterix.external.api.IJType;
import org.apache.asterix.external.library.java.base.JList;
import org.apache.asterix.om.base.AMutableOrderedList;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;

public final class JOrderedList
extends JList {
    private AOrderedListType listType;

    public JOrderedList(IJType listItemType) {
        this.listType = new AOrderedListType(listItemType.getIAType(), null);
    }

    public JOrderedList(IAType listItemType) {
        this.listType = new AOrderedListType(listItemType, null);
    }

    public List<IJObject> getValue() {
        return this.jObjects;
    }

    @Override
    public IAType getIAType() {
        return this.listType;
    }

    @Override
    public IAObject getIAObject() {
        AMutableOrderedList v = new AMutableOrderedList(this.listType);
        for (IJObject jObj : this.jObjects) {
            v.add(jObj.getIAObject());
        }
        return v;
    }

    @Override
    public void serialize(DataOutput dataOutput, boolean writeTypeTag) throws HyracksDataException {
        OrderedListBuilder listBuilder = new OrderedListBuilder();
        listBuilder.reset((AbstractCollectionType)this.listType);
        ArrayBackedValueStorage fieldValue = new ArrayBackedValueStorage();
        for (IJObject jObject : this.jObjects) {
            fieldValue.reset();
            jObject.serialize(fieldValue.getDataOutput(), true);
            listBuilder.addItem((IValueReference)fieldValue);
        }
        listBuilder.write(dataOutput, writeTypeTag);
    }

    @Override
    public void reset() {
        this.jObjects.clear();
    }
}

